/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BooleanHolder;
import fm.icelink.Global;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.Log;
import fm.icelink.ManagedThread;
import fm.icelink.StreamSocket;
import fm.icelink.TimeoutTimer;
import fm.icelink.VirtualAdapter;
import fm.icelink.VirtualPacket;

class VirtualTcpSocket
extends StreamSocket {
    private boolean __iPv6;
    private boolean __isClosed;
    private String __localIPAddress;
    private int __localPort;
    private String __remoteIPAddress;
    private int __remotePort;
    private boolean __secure;
    private boolean __server;
    private boolean _receiveActive = false;
    private Object _receiveLock = new Object();
    private TimeoutTimer _receiveTimer;
    private VirtualAdapter _virtualAdapter;

    @Override
    public void acceptAsync(final IAction1<StreamSocket> onSuccess, final IAction1<Exception> onFailure) {
        ManagedThread.dispatch(new IAction0(){

            @Override
            public void invoke() {
                try {
                    VirtualTcpSocket.this.raiseAcceptSuccess(onSuccess, null);
                }
                catch (Exception exception) {
                    VirtualTcpSocket.this.raiseAcceptFailure(onFailure, exception);
                }
            }
        });
    }

    @Override
    public boolean bind(String ipAddress, int port, BooleanHolder addressInUse) {
        addressInUse.setValue(false);
        if (!Global.equals(ipAddress, this._virtualAdapter.getIPAddress())) {
            return false;
        }
        this.__localIPAddress = ipAddress;
        this.__localPort = port;
        return true;
    }

    @Override
    public void close() {
        this.__isClosed = true;
    }

    public void connect(String ipAddress, int port) {
        this.__remoteIPAddress = ipAddress;
        this.__remotePort = port;
    }

    @Override
    public void connectAsync(final String ipAddress, final int port, int timeout, final IAction0 onSuccess, final IAction2<Exception, Boolean> onFailure) {
        ManagedThread.dispatch(new IAction0(){

            @Override
            public void invoke() {
                try {
                    VirtualTcpSocket.this.connect(ipAddress, port);
                    VirtualTcpSocket.this.raiseConnectSuccess(onSuccess);
                }
                catch (Exception exception) {
                    VirtualTcpSocket.this.raiseConnectFailure(onFailure, exception, false);
                }
            }
        });
    }

    @Override
    public boolean getIPv6() {
        return this.__iPv6;
    }

    @Override
    public boolean getIsClosed() {
        return this.__isClosed;
    }

    @Override
    public String getLocalIPAddress() {
        return this.__localIPAddress;
    }

    @Override
    public int getLocalPort() {
        return this.__localPort;
    }

    @Override
    public String getRemoteIPAddress() {
        return this.__remoteIPAddress;
    }

    @Override
    public int getRemotePort() {
        return this.__remotePort;
    }

    @Override
    public boolean getSecure() {
        return this.__secure;
    }

    @Override
    public boolean getServer() {
        return this.__server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualPacket receive(int timeout) {
        Object obj2;
        IAction1<Object> callback = null;
        Object object = obj2 = this._receiveLock;
        synchronized (object) {
            if (this._receiveActive) {
                return null;
            }
            this._receiveActive = true;
        }
        if (timeout > 0) {
            if (callback == null) {
                callback = new IAction1<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void invoke(Object state) {
                        Object object = VirtualTcpSocket.this._receiveLock;
                        synchronized (object) {
                            VirtualTcpSocket.this._receiveActive = false;
                        }
                    }
                };
            }
            this._receiveTimer = new TimeoutTimer(callback, null);
            try {
                this._receiveTimer.start(timeout);
            }
            catch (Exception exception) {
                Log.error("Could not start virtual TCP socket receive timer.", exception);
            }
        }
        try {
            while (this._receiveActive && !this.__isClosed) {
                VirtualPacket delivery = this._virtualAdapter.getDelivery(this.getLocalPort());
                if (delivery != null) {
                    VirtualPacket virtualPacket = delivery;
                    return virtualPacket;
                }
                ManagedThread.sleep(10);
            }
        }
        finally {
            if (timeout > 0) {
                this._receiveTimer.stop();
            }
            Object object2 = obj2 = this._receiveLock;
            synchronized (object2) {
                this._receiveActive = false;
            }
        }
        return null;
    }

    @Override
    public void receiveAsync(int timeout) {
        ManagedThread.dispatch(this.receiveAsyncDelegate(timeout));
    }

    private IAction0 receiveAsyncDelegate(final int timeout) {
        return new IAction0(){

            @Override
            public void invoke() {
                try {
                    VirtualPacket packet = VirtualTcpSocket.this.receive(timeout);
                    if (packet == null) {
                        if (VirtualTcpSocket.this.__isClosed) {
                            VirtualTcpSocket.this.raiseReceiveFailure(VirtualTcpSocket.this.getOnReceiveFailure(), new Exception("Socket closed."), false);
                        } else {
                            VirtualTcpSocket.this.raiseReceiveFailure(VirtualTcpSocket.this.getOnReceiveFailure(), new Exception("Receive cancelled."), false);
                        }
                    } else {
                        VirtualTcpSocket.this.raiseReceiveSuccess(VirtualTcpSocket.this.getOnReceiveSuccess(), packet.getPayload());
                    }
                }
                catch (Exception exception) {
                    VirtualTcpSocket.this.raiseReceiveFailure(VirtualTcpSocket.this.getOnReceiveFailure(), exception, false);
                }
            }
        };
    }

    @Override
    public boolean send(byte[] buffer) {
        VirtualPacket packet = new VirtualPacket();
        packet.setSourceIPAddress(this.getLocalIPAddress());
        packet.setSourcePort(this.getLocalPort());
        packet.setPayload(buffer);
        this._virtualAdapter.getNetwork().send(packet, this.getRemoteIPAddress(), this.getRemotePort());
        return true;
    }

    @Override
    public void sendAsync(final byte[] buffer, int timeout, final IAction0 onSuccess, final IAction2<Exception, Boolean> onFailure) {
        ManagedThread.dispatch(new IAction0(){

            @Override
            public void invoke() {
                try {
                    VirtualTcpSocket.this.send(buffer);
                    VirtualTcpSocket.this.raiseSendSuccess(onSuccess);
                }
                catch (Exception exception) {
                    VirtualTcpSocket.this.raiseSendFailure(onFailure, exception, false);
                }
            }
        });
    }

    public VirtualTcpSocket(VirtualAdapter adapter, boolean server, boolean ipv6, boolean secure) {
        this._virtualAdapter = adapter;
        this.__server = server;
        this.__iPv6 = ipv6;
        this.__secure = secure;
    }
}

