/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IntegerExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.VirtualNetwork;
import fm.icelink.VirtualPacket;
import fm.icelink.VirtualPacketDeliveredArgs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class VirtualDevice {
    private List<IAction1<VirtualPacketDeliveredArgs>> __packetDelivered = new ArrayList<IAction1<VirtualPacketDeliveredArgs>>();
    private HashMap<String, ArrayList<VirtualPacket>> _deliveries;
    private Object _deliveriesLock;
    private int _ipAddress1;
    private int _ipAddress2;
    private int _ipAddress3;
    private int _ipAddress4;
    private VirtualNetwork _network;
    private IAction1<VirtualPacketDeliveredArgs> _packetDelivered = new IAction1<VirtualPacketDeliveredArgs>(){

        @Override
        public void invoke(VirtualPacketDeliveredArgs p0) {
            for (IAction1 action : new ArrayList(VirtualDevice.this.__packetDelivered)) {
                action.invoke(p0);
            }
        }
    };
    private Object _stateLock = new Object();
    private boolean _useDhcp;

    void addPacketDelivered(IAction1<VirtualPacketDeliveredArgs> value) {
        this.__packetDelivered.add(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deliver(VirtualPacket packet, int port) {
        Object object = this._deliveriesLock;
        synchronized (object) {
            ArrayList<VirtualPacket> list = null;
            Holder<Object> _var0 = new Holder<Object>(list);
            boolean _var1 = HashMapExtensions.tryGetValue(this._deliveries, IntegerExtensions.toString(port), _var0);
            list = _var0.getValue();
            if (!_var1) {
                list = new ArrayList<VirtualPacket>();
                HashMapExtensions.set(HashMapExtensions.getItem(this._deliveries), IntegerExtensions.toString(port), list);
            }
            list.add(packet);
        }
        IAction1<VirtualPacketDeliveredArgs> packetDelivered = this._packetDelivered;
        if (packetDelivered != null) {
            VirtualPacketDeliveredArgs p = new VirtualPacketDeliveredArgs();
            p.setPort(port);
            packetDelivered.invoke(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VirtualPacket getDelivery(int port) {
        Object object = this._deliveriesLock;
        synchronized (object) {
            ArrayList list = null;
            Holder<Object> _var0 = new Holder<Object>(list);
            boolean _var1 = HashMapExtensions.tryGetValue(this._deliveries, IntegerExtensions.toString(port), _var0);
            list = _var0.getValue();
            if (_var1 && ArrayListExtensions.getCount(list) > 0) {
                VirtualPacket packet = (VirtualPacket)ArrayListExtensions.getItem(list).get(0);
                ArrayListExtensions.removeAt(list, 0);
                return packet;
            }
        }
        return null;
    }

    public String getIPAddress() {
        return StringExtensions.format("{0}.{1}.{2}.{3}", new Object[]{IntegerExtensions.toString(this.getIPAddress1()), IntegerExtensions.toString(this.getIPAddress2()), IntegerExtensions.toString(this.getIPAddress3()), IntegerExtensions.toString(this.getIPAddress4())});
    }

    public int getIPAddress1() {
        return this._ipAddress1;
    }

    public int getIPAddress2() {
        return this._ipAddress2;
    }

    public int getIPAddress3() {
        return this._ipAddress3;
    }

    public int getIPAddress4() {
        return this._ipAddress4;
    }

    public VirtualNetwork getNetwork() {
        return this._network;
    }

    public boolean getUseDhcp() {
        return this._useDhcp;
    }

    void removePacketDelivered(IAction1<VirtualPacketDeliveredArgs> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__packetDelivered, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__packetDelivered.remove(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAddressAndNetwork(int ipAddress1, int ipAddress2, int ipAddress3, int ipAddress4, VirtualNetwork network) {
        Object object = this._stateLock;
        synchronized (object) {
            this.setIPAddress1(ipAddress1);
            this.setIPAddress2(ipAddress2);
            this.setIPAddress3(ipAddress3);
            this.setIPAddress4(ipAddress4);
            this.setNetwork(network);
        }
    }

    void setIPAddress1(int value) {
        this._ipAddress1 = value;
    }

    void setIPAddress2(int value) {
        this._ipAddress2 = value;
    }

    void setIPAddress3(int value) {
        this._ipAddress3 = value;
    }

    void setIPAddress4(int value) {
        this._ipAddress4 = value;
    }

    void setNetwork(VirtualNetwork value) {
        this._network = value;
    }

    private void setUseDhcp(boolean value) {
        this._useDhcp = value;
    }

    public VirtualDevice() {
        this._deliveries = new HashMap();
        this._deliveriesLock = new Object();
        this.setUseDhcp(true);
    }

    public VirtualDevice(int ipAddress1, int ipAddress2, int ipAddress3, int ipAddress4) {
        this._deliveries = new HashMap();
        this._deliveriesLock = new Object();
        this.setUseDhcp(false);
        this.setIPAddress1(ipAddress1);
        this.setIPAddress2(ipAddress2);
        this.setIPAddress3(ipAddress3);
        this.setIPAddress4(ipAddress4);
    }
}

