/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.IAction2;
import fm.icelink.IceCandidate;
import fm.icelink.IceGatherer;
import fm.icelink.IceTransport;
import fm.icelink.VirtualAdapter;
import fm.icelink.VirtualSessionServer;
import fm.icelink.VirtualSessionServerEventType;

class VirtualClient {
    private VirtualAdapter[] _adapters;
    private IceGatherer _gatherer;
    private String _name;
    private IceTransport _transport;

    public VirtualAdapter[] getAdapters() {
        return this._adapters;
    }

    public IceGatherer getGatherer() {
        return this._gatherer;
    }

    public String getName() {
        return this._name;
    }

    public IceTransport getTransport() {
        return this._transport;
    }

    public void send(String text) {
    }

    public void sessionServerNotify(VirtualSessionServerEventType eventType, String peerClientName) {
    }

    private void setAdapters(VirtualAdapter[] value) {
        this._adapters = value;
    }

    public void setCandidate(IceCandidate candidate, String peerClientName) {
        if (this.getTransport() != null) {
            this.getTransport().addRemoteCandidate(candidate);
        }
    }

    private void setGatherer(IceGatherer value) {
        this._gatherer = value;
    }

    private void setName(String value) {
        this._name = value;
    }

    private void setTransport(IceTransport value) {
        this._transport = value;
    }

    public VirtualClient(final VirtualSessionServer sessionServer, String clientName, VirtualAdapter[] adapters, IceGatherer gatherer, IceTransport transport) {
        IAction2<IceGatherer, IceCandidate> action = null;
        this.setName(clientName);
        this.setAdapters(adapters);
        this.setGatherer(gatherer);
        if (action == null) {
            action = new IAction2<IceGatherer, IceCandidate>(){

                @Override
                public void invoke(IceGatherer g, IceCandidate c) {
                    sessionServer.sendCandidate(c, VirtualClient.this.getName());
                }
            };
        }
        this.getGatherer().addOnLocalCandidate(action);
        this.setTransport(transport);
    }
}

