/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Constants;
import fm.icelink.DateExtensions;
import fm.icelink.IElement;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaSource;
import fm.icelink.ISource;
import fm.icelink.IVideoElement;
import fm.icelink.IVideoSink;
import fm.icelink.IVideoSinkCollection;
import fm.icelink.IVideoSource;
import fm.icelink.MathAssistant;
import fm.icelink.MediaSource;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoBufferCollection;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;

public abstract class VideoSource
extends MediaSource<IVideoSource, IVideoSink, IVideoSinkCollection, VideoSource, VideoFrame, VideoBuffer, VideoBufferCollection, VideoFormat>
implements IVideoSource,
IMediaSource<IVideoSource, IVideoSink, VideoFrame, VideoBuffer, VideoBufferCollection, VideoFormat>,
ISource<IVideoSource, IVideoSink, VideoFrame, VideoBuffer, VideoBufferCollection, VideoFormat>,
IVideoElement,
IMediaElement,
IElement {
    private long _frameCount;
    private long _startTicks = -1L;

    @Override
    protected IVideoSinkCollection createSinkCollection(IVideoSource source) {
        return new IVideoSinkCollection(source);
    }

    public int getAverageFrameRate() {
        if (this.getFrameCount() == 0L) {
            return -1;
        }
        long num = DateExtensions.getTicks(DateExtensions.getUtcNow()) - this._startTicks;
        if (num < (long)Constants.getTicksPerSecond()) {
            return -1;
        }
        return (int)(this.getFrameCount() * (long)Constants.getTicksPerSecond() / num);
    }

    public long getFrameCount() {
        return this._frameCount;
    }

    public int getFrameRateDistance(int frameRate1, int frameRate2) {
        if (frameRate2 > 0) {
            return MathAssistant.abs(frameRate2 - frameRate1);
        }
        return -1;
    }

    protected long getNextTimestamp() {
        long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        if (this._startTicks == -1L) {
            this._startTicks = ticks;
        }
        long num2 = ticks - this._startTicks;
        return num2 * (long)((VideoFormat)super.getOutputFormat()).getClockRate() / (long)Constants.getTicksPerSecond();
    }

    public int getSizeDistance(int width1, int height1, int width2, int height2) {
        if (width2 > 0 && height2 > 0) {
            return MathAssistant.abs(width2 - width1) + MathAssistant.abs(height2 - height1);
        }
        if (width2 <= 0) {
            return MathAssistant.abs(height2 - height1);
        }
        if (height2 <= 0) {
            return MathAssistant.abs(width2 - width1);
        }
        return -1;
    }

    @Override
    protected void raiseFrame(VideoFrame frame) {
        if (frame.getTimestamp() < 0L) {
            frame.setTimestamp(this.getNextTimestamp());
        }
        this.setFrameCount(this.getFrameCount() + 1L);
        super.raiseFrame(frame);
    }

    private void setFrameCount(long value) {
        this._frameCount = value;
    }

    public VideoSource(VideoFormat outputFormat) {
        super(outputFormat);
    }
}

