/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.Error;
import fm.icelink.IVideoSource;
import fm.icelink.LongHolder;
import fm.icelink.PliControlFrame;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.VideoPipe;
import fm.icelink.sdp.MediaDescription;

public abstract class VideoDepacketizer
extends VideoPipe {
    private boolean __requireKeyframe = true;
    private long _lastSequenceNumber = -1L;

    private static VideoFormat cloneFormat(VideoFormat format, boolean isPacketized) {
        VideoFormat format2 = format.clone();
        format2.setIsPacketized(isPacketized);
        return format2;
    }

    protected abstract DataBuffer depacketize(VideoBuffer var1, LongHolder var2);

    @Override
    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        int num2;
        long newSequenceNumber = -1L;
        LongHolder _var0 = new LongHolder(newSequenceNumber);
        DataBuffer _var1 = this.depacketize(inputBuffer, _var0);
        newSequenceNumber = _var0.getValue();
        DataBuffer buffer = _var1;
        if (this._lastSequenceNumber == -1L && !this.isKeyFrame(buffer)) {
            this.sendPli();
        }
        if ((num2 = this.updateSequenceNumber(newSequenceNumber)) > 0) {
            this.sendPli();
        } else if (buffer != null) {
            if (this.__requireKeyframe && this.isKeyFrame(buffer)) {
                this.__requireKeyframe = false;
            }
            if (!this.__requireKeyframe && num2 == 0) {
                frame.addBuffer(new VideoBuffer(inputBuffer.getWidth(), inputBuffer.getHeight(), buffer, (VideoFormat)super.getOutputFormat()));
                this.raiseFrame(frame);
            }
        }
    }

    @Override
    protected Error doProcessSdpMediaDescription(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        if (isLocalDescription) {
            mediaDescription.insertNackPliAttribute(super.getInputFormat());
        }
        return null;
    }

    protected abstract boolean isKeyFrame(DataBuffer var1);

    private void sendPli() {
        this.__requireKeyframe = true;
        super.raiseControlFrame(new PliControlFrame());
    }

    private int updateSequenceNumber(long sequenceNumber) {
        int num = 0;
        if (sequenceNumber > this._lastSequenceNumber) {
            if (this._lastSequenceNumber > -1L) {
                long num2 = sequenceNumber - this._lastSequenceNumber;
                num = (int)(num2 - 1L);
            }
            this._lastSequenceNumber = sequenceNumber;
            return num;
        }
        if (sequenceNumber < this._lastSequenceNumber) {
            num = (int)(sequenceNumber - this._lastSequenceNumber);
        }
        return num;
    }

    public VideoDepacketizer(IVideoSource source) {
        this((VideoFormat)source.getOutputFormat());
        super.addSource(source);
    }

    public VideoDepacketizer(VideoFormat format) {
        super(VideoDepacketizer.cloneFormat(format, true), VideoDepacketizer.cloneFormat(format, false));
    }
}

