/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.Error;
import fm.icelink.PliControlFrame;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.VideoPipe;
import fm.icelink.sdp.MediaDescription;

public abstract class VideoDecoder
extends VideoPipe {
    private boolean __delayDecodeOnPendingKeyFrame = true;
    private volatile boolean __keyFrameReceived = false;

    @Override
    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        if (this.getDelayDecode()) {
            if (this.isKeyFrame(inputBuffer.getDataBuffer())) {
                this.setKeyFrameReceived(true);
            } else {
                this.sendPli("Pending keyframe required.");
            }
        }
    }

    @Override
    protected Error doProcessSdpMediaDescription(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        if (isLocalDescription) {
            mediaDescription.insertNackPliAttribute(super.getInputFormat());
        }
        return null;
    }

    protected boolean getDelayDecode() {
        return this.getDelayDecodeOnPendingKeyFrame() && !this.getKeyFrameReceived();
    }

    public boolean getDelayDecodeOnPendingKeyFrame() {
        return this.__delayDecodeOnPendingKeyFrame;
    }

    boolean getKeyFrameReceived() {
        return this.__keyFrameReceived;
    }

    protected abstract boolean isKeyFrame(DataBuffer var1);

    public void sendPli(String reason) {
        super.raiseControlFrame(new PliControlFrame());
        this.setKeyFrameReceived(false);
    }

    public void setDelayDecodeOnPendingKeyFrame(boolean value) {
        this.__delayDecodeOnPendingKeyFrame = value;
    }

    void setKeyFrameReceived(boolean value) {
        this.__keyFrameReceived = value;
    }

    public VideoDecoder(VideoFormat inputFormat, VideoFormat outputFormat) {
        super(inputFormat, outputFormat);
    }
}

