/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Holder;
import fm.icelink.UriKind;
import java.net.URI;
import java.net.URLEncoder;

public class UriExtensions {
    public static boolean tryCreate(String uriString, UriKind uriKind, Holder<URI> result) {
        try {
            result.setValue(URI.create(uriString));
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static boolean tryCreate(URI baseUri, String relativeUri, Holder<URI> result) {
        if (baseUri == null) {
            return false;
        }
        try {
            result.setValue(URI.create(baseUri.toString()).resolve(relativeUri));
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static String escapeDataString(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getAbsolutePath(URI uri) {
        return uri.getPath();
    }

    public static String getDnsSafeHost(URI uri) {
        return uri.getHost();
    }

    public static String getQuery(URI uri) {
        StringBuilder sb = new StringBuilder();
        String query = uri.getQuery();
        if (query != null && query.length() > 0) {
            sb.append("?");
            sb.append(query);
        }
        return sb.toString();
    }
}

