/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DatagramSocket;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IAction3;
import fm.icelink.IActionDelegate1;
import fm.icelink.IActionDelegate3;
import fm.icelink.Log;
import fm.icelink.StreamSocket;
import fm.icelink.StringExtensions;
import fm.icelink.TransportAddress;
import fm.icelink.TurnAllocation;

class TurnUdpAllocation
extends TurnAllocation {
    private IAction3<TurnUdpAllocation, TransportAddress, byte[]> _onReceive;
    private boolean _receiving = false;
    private Object _receivingLock = new Object();
    private DatagramSocket _socket;
    private StreamSocket _tcpServerSocket;
    private DatagramSocket _udpServerSocket;

    @Override
    public void close() {
        try {
            this.getSocket().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doReceive() {
        if (!this.getIsClosed() && !super.getIsExpired()) {
            this.receive();
        }
    }

    public boolean getIsClosed() {
        return this.getSocket().getIsClosed();
    }

    @Override
    public String getLocalIPAddress() {
        return this.getSocket().getLocalIPAddress();
    }

    @Override
    public int getLocalPort() {
        return this.getSocket().getLocalPort();
    }

    @Override
    public String getPublicIPAddress() {
        return this.getSocket().getPublicIPAddress();
    }

    public DatagramSocket getSocket() {
        return this._socket;
    }

    public StreamSocket getTcpServerSocket() {
        return this._tcpServerSocket;
    }

    public DatagramSocket getUdpServerSocket() {
        return this._udpServerSocket;
    }

    private void receive() {
        try {
            this.getSocket().receiveAsync((IAction3<byte[], String, Integer>)new IActionDelegate3<byte[], String, Integer>(){

                @Override
                public String getId() {
                    return "fm.icelink.TurnUdpAllocation.receiveSuccess";
                }

                @Override
                public void invoke(byte[] data, String remoteIPAddress, Integer remotePort) {
                    TurnUdpAllocation.this.receiveSuccess(data, remoteIPAddress, remotePort);
                }
            }, (IAction1<Exception>)new IActionDelegate1<Exception>(){

                @Override
                public String getId() {
                    return "fm.icelink.TurnUdpAllocation.receiveFailure";
                }

                @Override
                public void invoke(Exception ex) {
                    TurnUdpAllocation.this.receiveFailure(ex);
                }
            });
        }
        catch (Exception exception) {
            if (Log.getIsDebugEnabled()) {
                Log.debug(StringExtensions.format("Could not receive on allocation socket. {0}", exception.getMessage()));
            }
            this.getSocket().close();
        }
    }

    private void receiveFailure(Exception ex) {
        this.doReceive();
    }

    private void receiveSuccess(byte[] data, String remoteIPAddress, int remotePort) {
        try {
            TransportAddress address = new TransportAddress(remoteIPAddress, remotePort);
            this._onReceive.invoke(this, address, data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.doReceive();
    }

    public boolean sendData(byte[] data, TransportAddress remoteAddress, Holder<Exception> exception) {
        try {
            this.getSocket().send(data, remoteAddress.getIPAddress(), remoteAddress.getPort());
            exception.setValue(null);
            return true;
        }
        catch (Exception exception2) {
            exception.setValue(exception2);
            return false;
        }
    }

    private void setSocket(DatagramSocket value) {
        this._socket = value;
    }

    private void setTcpServerSocket(StreamSocket value) {
        this._tcpServerSocket = value;
    }

    private void setUdpServerSocket(DatagramSocket value) {
        this._udpServerSocket = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReceiving() {
        Object object = this._receivingLock;
        synchronized (object) {
            if (this._receiving) {
                return;
            }
            this._receiving = true;
        }
        this.doReceive();
    }

    public TurnUdpAllocation(DatagramSocket udpServerSocket, StreamSocket tcpServerSocket, byte[] transactionId, byte[] reservation, DatagramSocket socket, TransportAddress clientAddress, String username, String realm, int lifetime, IAction3<TurnUdpAllocation, TransportAddress, byte[]> onReceive, IAction1<TransportAddress> onExpires) {
        super(transactionId, reservation, clientAddress, username, realm, lifetime, onExpires);
        if (udpServerSocket == null && tcpServerSocket == null) {
            throw new RuntimeException(new Exception("UDP and TCP server sockets cannot both be null."));
        }
        if (socket == null) {
            throw new RuntimeException(new Exception("Socket cannot be null."));
        }
        if (onReceive == null) {
            throw new RuntimeException(new Exception("Receive callback cannot be null."));
        }
        this.setUdpServerSocket(udpServerSocket);
        this.setTcpServerSocket(tcpServerSocket);
        this.setSocket(socket);
        this._onReceive = onReceive;
    }
}

