/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum StreamType {
    Audio(1),
    Video(2),
    Application(3),
    Message(4),
    Text(5);

    private final int value;
    private static final Map<Integer, StreamType> lookup;

    private StreamType(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static StreamType getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, StreamType>();
        for (StreamType s : EnumSet.allOf(StreamType.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

