/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.Candidate;
import fm.icelink.CoreTransport;
import fm.icelink.Crypto;
import fm.icelink.DtlsFingerprint;
import fm.icelink.DtlsParameters;
import fm.icelink.DtlsRole;
import fm.icelink.DtlsTransport;
import fm.icelink.EncryptionMode;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.IceCandidate;
import fm.icelink.IceGatherer;
import fm.icelink.IceParameters;
import fm.icelink.IceTransport;
import fm.icelink.StreamBase;
import fm.icelink.StreamDirection;
import fm.icelink.StreamType;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.ConnectionData;
import fm.icelink.sdp.CryptoAttribute;
import fm.icelink.sdp.CryptoSuite;
import fm.icelink.sdp.Media;
import fm.icelink.sdp.MediaDescription;
import fm.icelink.sdp.Message;
import fm.icelink.sdp.Setup;
import fm.icelink.sdp.SetupAttribute;
import fm.icelink.sdp.ice.FingerprintAttribute;
import fm.icelink.sdp.ice.PasswordAttribute;
import fm.icelink.sdp.ice.UfragAttribute;
import java.util.ArrayList;

public abstract class Stream
extends StreamBase {
    private boolean __disabled;
    private ArrayList<EncryptionMode> __encryptionModes;
    private ArrayList<Candidate> __localCandidates;
    private CryptoAttribute[] __localCryptoAttributes;
    private IceParameters __localIceParameters;
    private Object __localIceParametersLock = new Object();
    private CryptoAttribute[] __remoteCryptoAttributes;
    private String _canonicalName;
    private CoreTransport _coreTransportRtcp;
    private CoreTransport _coreTransportRtp;
    private int _index;
    private DtlsParameters _localDtlsParameters;
    private DtlsParameters _remoteDtlsParameters;
    private IceParameters _remoteIceParameters;
    private boolean _useDtls;

    void addLocalCandidate(Candidate candidate) {
        this.get_LocalCandidates().add(candidate);
    }

    void assignLocalParametersToCoreTransports() {
        for (CoreTransport transport : new CoreTransport[]{this.getCoreTransportRtp(), this.getCoreTransportRtcp()}) {
            if (transport == null) continue;
            IceGatherer gatherer = transport.getGatherer();
            DtlsTransport dtlsTransport = transport.getDtlsTransport();
            if (gatherer != null) {
                gatherer.setLocalParameters(this.getLocalIceParameters());
            }
            if (dtlsTransport == null) continue;
            dtlsTransport.setLocalParameters(this.getLocalDtlsParameters());
        }
    }

    void copyLocalParameters(Stream otherStream) {
        this.setLocalIceParameters(otherStream.getLocalIceParameters());
        this.setLocalDtlsParameters(otherStream.getLocalDtlsParameters());
        this.setRemoteIceParameters(otherStream.getRemoteIceParameters());
        this.setRemoteDtlsParameters(otherStream.getRemoteDtlsParameters());
    }

    public MediaDescription createSdpMediaDescription(Message sdpMessage, boolean supportSdes, boolean isOffer, boolean renegotiation) {
        DtlsFingerprint fingerprint;
        Candidate[] localCandidates;
        Candidate[] activeCandidatePair;
        IceTransport iceTransport;
        Media media = new Media();
        MediaDescription description = new MediaDescription(media);
        String connectionAddress = "0.0.0.0";
        int port = 9;
        if (this.getCoreTransportRtp() != null && (iceTransport = this.getCoreTransportRtp().getIceTransport()) != null && (activeCandidatePair = iceTransport.getActiveCandidatePair()) != null) {
            IceCandidate local = activeCandidatePair.getLocal();
            connectionAddress = local.getIPAddress();
            port = local.getPort();
        }
        description.setConnectionData(new ConnectionData(connectionAddress));
        description.addMediaAttribute(new UfragAttribute(this.getLocalIceParameters().getUsernameFragment()));
        description.addMediaAttribute(new PasswordAttribute(this.getLocalIceParameters().getPassword()));
        description.getMedia().setTransportPort(this.getDisabled() ? 0 : port);
        for (Candidate candidate2 : localCandidates = this.getLocalCandidates()) {
            candidate2.setDispatched(true);
            description.addMediaAttribute(candidate2.getSdpCandidateAttribute());
        }
        DtlsFingerprint dtlsFingerprint = fingerprint = this.getLocalDtlsParameters() == null ? null : this.getLocalDtlsParameters().getFingerprint();
        if (this.getUseDtls()) {
            if (fingerprint == null) {
                throw new RuntimeException(new Exception(StringExtensions.format("Cannot create SDP media description for local stream {0}: stream is setup to use DTLS but the DTLS fingerprint has not been set in local DTLS parameters.", super.getId())));
            }
            FingerprintAttribute attribute = new FingerprintAttribute(fingerprint.getAlgorithm(), fingerprint.getValue());
            description.addMediaAttribute(attribute);
            if (Global.equals((Object)this.getLocalDtlsParameters().getRole(), (Object)DtlsRole.Auto) || isOffer && renegotiation) {
                description.addMediaAttribute(new SetupAttribute(Setup.getActPass()));
            } else if (Global.equals((Object)this.getLocalDtlsParameters().getRole(), (Object)DtlsRole.Client)) {
                description.addMediaAttribute(new SetupAttribute(Setup.getActive()));
            } else if (Global.equals((Object)this.getLocalDtlsParameters().getRole(), (Object)DtlsRole.Server)) {
                description.addMediaAttribute(new SetupAttribute(Setup.getPassive()));
            }
        }
        if (supportSdes) {
            this.generateCryptoAttributes();
            for (CryptoAttribute attribute2 : this.getLocalCryptoAttributes()) {
                description.addMediaAttribute(attribute2);
            }
        }
        return description;
    }

    void eraseLocalCandidatesForSecondaryComponent() {
        Candidate[] candidateArray;
        for (Candidate candidate : candidateArray = this.get_LocalCandidates().toArray(new Candidate[0])) {
            if (candidate.getSdpCandidateAttribute().getComponentId() != 2) continue;
            this.get_LocalCandidates().remove(candidate);
        }
    }

    private void generateCryptoAttributes() {
        ArrayList<CryptoAttribute> list = new ArrayList<CryptoAttribute>();
        for (EncryptionMode mode : this.getEncryptionModes()) {
            EncryptionMode _var0 = mode;
            if (_var0 != EncryptionMode.Default && _var0 != EncryptionMode.Aes128Weak && _var0 != EncryptionMode.NullStrong && _var0 != EncryptionMode.NullWeak) continue;
            byte[] hexBytes = BitAssistant.getHexBytes(Guid.newGuid().toString().replace("-", ""));
            byte[] salt = BitAssistant.subArray(BitAssistant.getHexBytes(Guid.newGuid().toString().replace("-", "")), 0, 14);
            String cryptoSuite = CryptoSuite.getCryptoSuite(mode);
            list.add(new CryptoAttribute(1, cryptoSuite).setKeySalt(hexBytes, salt));
        }
        this.__localCryptoAttributes = list.toArray(new CryptoAttribute[0]);
    }

    private ArrayList<Candidate> get_LocalCandidates() {
        return this.__localCandidates;
    }

    public String getCanonicalName() {
        return this._canonicalName;
    }

    CoreTransport getCoreTransportRtcp() {
        return this._coreTransportRtcp;
    }

    CoreTransport getCoreTransportRtp() {
        return this._coreTransportRtp;
    }

    public boolean getDisabled() {
        return this.__disabled;
    }

    public EncryptionMode[] getEncryptionModes() {
        return this.__encryptionModes.toArray(new EncryptionMode[0]);
    }

    public int getIndex() {
        return this._index;
    }

    Candidate[] getLocalCandidates() {
        return this.get_LocalCandidates().toArray(new Candidate[0]);
    }

    CryptoAttribute[] getLocalCryptoAttributes() {
        return this.__localCryptoAttributes;
    }

    DtlsParameters getLocalDtlsParameters() {
        return this._localDtlsParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceParameters getLocalIceParameters() {
        Object object = this.__localIceParametersLock;
        synchronized (object) {
            if (this.__localIceParameters == null) {
                String s = StringExtensions.substring(Guid.newGuid().toString().replace("-", ""), 0, 8);
                String hexString = BitAssistant.getHexString(Crypto.getMd5Hash(s));
                this.__localIceParameters = new IceParameters(s, hexString);
            }
            return this.__localIceParameters;
        }
    }

    CryptoAttribute[] getRemoteCryptoAttributes() {
        return this.__remoteCryptoAttributes;
    }

    DtlsParameters getRemoteDtlsParameters() {
        return this._remoteDtlsParameters;
    }

    public IceParameters getRemoteIceParameters() {
        return this._remoteIceParameters;
    }

    public boolean getUseDtls() {
        return this._useDtls;
    }

    protected void processCachedSettings() {
    }

    Error processSdpMediaDescription(Message sdpMessage, MediaDescription sdpMediaDescription, boolean isLocalDescription, boolean isOffer, boolean isRenegotiation) {
        CryptoAttribute[] cryptoAttributes;
        SetupAttribute setupAttribute;
        PasswordAttribute icePasswordAttribute;
        UfragAttribute iceUfragAttribute;
        FingerprintAttribute fingerprintAttribute;
        if (sdpMediaDescription.getMedia().getTransportPort() == 0 || this.getDisabled()) {
            StreamDirection sessionLevelDirection = sdpMessage.getSessionLevelDirection();
            StreamDirection streamDirection = sdpMediaDescription.getStreamDirection();
            if (this.getDisabled() || !Global.equals((Object)sessionLevelDirection, (Object)StreamDirection.Inactive) && !Global.equals((Object)streamDirection, (Object)StreamDirection.Inactive)) {
                this.setDisabled(true);
                Error error = new Error(ErrorCode.StreamDisabled);
                error.setException(new Exception(StringExtensions.format("{0} peer rejected session offer.", isLocalDescription ? "Local" : "Remote")));
                return error;
            }
        }
        if ((fingerprintAttribute = sdpMediaDescription.getFingerprintAttribute()) == null) {
            fingerprintAttribute = sdpMessage.getSessionLevelFingerprintAttribute();
        }
        if ((iceUfragAttribute = sdpMediaDescription.getIceUfragAttribute()) == null) {
            iceUfragAttribute = sdpMessage.getSessionLevelIceUfragAttribute();
        }
        if ((icePasswordAttribute = sdpMediaDescription.getIcePasswordAttribute()) == null) {
            icePasswordAttribute = sdpMessage.getSessionLevelIcePasswordAttribute();
        }
        if ((setupAttribute = sdpMediaDescription.getSetupAttribute()) == null) {
            setupAttribute = sdpMessage.getSessionLevelSetupAttribute();
        }
        if ((cryptoAttributes = sdpMediaDescription.getCryptoAttributes()) == null) {
            cryptoAttributes = sdpMessage.getSessionLevelCryptoAttributes();
        }
        if (!isRenegotiation) {
            boolean useDtls = this.getUseDtls();
            this.setUseDtls(fingerprintAttribute != null && this.getUseDtls());
            if (!Global.equals(this.getUseDtls(), useDtls) && !isOffer && isLocalDescription) {
                Error error2 = new Error(ErrorCode.LocalDescriptionError);
                error2.setException(new Exception("The endpoint in answering mode attempted to modify encryption algorithm in the local session description."));
                return error2;
            }
            if (isLocalDescription) {
                this.__localCryptoAttributes = cryptoAttributes;
                if (setupAttribute != null) {
                    if (isOffer && !Global.equals(setupAttribute.getSetup(), Setup.getActPass())) {
                        Error error3 = new Error(ErrorCode.LocalDescriptionError);
                        error3.setException(new Exception("The endpoint that is the offerer MUST use the setup attribute value of setup:actpass"));
                        return error3;
                    }
                    if (!isOffer && Global.equals(setupAttribute.getSetup(), Setup.getActPass())) {
                        Error error4 = new Error(ErrorCode.LocalDescriptionError);
                        error4.setException(new Exception("The endpoint that is the answerer MUST use either a setup attribute value of setup:active or setup:passive"));
                        return error4;
                    }
                    if (!isOffer && (Global.equals(setupAttribute.getSetup(), Setup.getPassive()) && Global.equals((Object)this.getRemoteDtlsParameters().getRole(), (Object)DtlsRole.Server) || Global.equals(setupAttribute.getSetup(), Setup.getActive()) && Global.equals((Object)this.getRemoteDtlsParameters().getRole(), (Object)DtlsRole.Client))) {
                        Error error5 = new Error(ErrorCode.LocalDescriptionError);
                        error5.setException(new Exception("The endpoint that is the answerer attempted to modify local Dtls role that has already been negotiated with the offerer"));
                        return error5;
                    }
                }
            } else {
                EncryptionMode[] encryptionModeArray;
                this.__remoteCryptoAttributes = cryptoAttributes;
                if (this.__remoteCryptoAttributes == null) {
                    this.__remoteCryptoAttributes = new CryptoAttribute[0];
                }
                if (this.__localCryptoAttributes == null) {
                    this.generateCryptoAttributes();
                }
                ArrayList<EncryptionMode> list = new ArrayList<EncryptionMode>();
                for (CryptoAttribute attribute5 : this.__remoteCryptoAttributes) {
                    if (Global.equals(attribute5.getCryptoSuite(), CryptoSuite.getAesCM128HmacSha180())) {
                        list.add(EncryptionMode.Default);
                    } else if (Global.equals(attribute5.getCryptoSuite(), CryptoSuite.getAesCm128HmacSha132())) {
                        list.add(EncryptionMode.Aes128Weak);
                    } else if (Global.equals(attribute5.getCryptoSuite(), CryptoSuite.getNullHmacSha180())) {
                        list.add(EncryptionMode.NullStrong);
                    } else if (Global.equals(attribute5.getCryptoSuite(), CryptoSuite.getNullHmacSha132())) {
                        list.add(EncryptionMode.NullWeak);
                    }
                    for (CryptoAttribute cryptoAttribute : this.__localCryptoAttributes) {
                        if (!Global.equals(attribute5, cryptoAttribute)) continue;
                        cryptoAttribute.setTag(attribute5.getTag());
                    }
                }
                DtlsRole server = DtlsRole.Server;
                if (setupAttribute != null && Global.equals(setupAttribute.getSetup(), Setup.getActive())) {
                    server = DtlsRole.Client;
                }
                this.getLocalDtlsParameters().setRole(Global.equals((Object)server, (Object)DtlsRole.Server) ? DtlsRole.Client : DtlsRole.Server);
                if (this.getUseDtls()) {
                    DtlsFingerprint[] fingerprints = new DtlsFingerprint[]{new DtlsFingerprint(fingerprintAttribute.getHashFunction(), fingerprintAttribute.getFingerprint())};
                    this.setRemoteDtlsParameters(new DtlsParameters(Global.equals((Object)this.getLocalDtlsParameters().getRole(), (Object)DtlsRole.Server) ? DtlsRole.Client : DtlsRole.Server, fingerprints));
                } else if (ArrayListExtensions.getCount(list) == 0) {
                    list.add(EncryptionMode.Null);
                }
                ArrayList<EncryptionMode> list2 = new ArrayList<EncryptionMode>();
                block2: for (EncryptionMode mode : list) {
                    for (EncryptionMode encryptionMode : this.getEncryptionModes()) {
                        if (!Global.equals((Object)mode, (Object)encryptionMode)) continue;
                        list2.add(mode);
                        continue block2;
                    }
                }
                if (ArrayListExtensions.getCount(list2) == 0) {
                    list2.add(EncryptionMode.Null);
                }
                if (this.getUseDtls()) {
                    EncryptionMode[] encryptionModeArray2 = new EncryptionMode[1];
                    encryptionModeArray = encryptionModeArray2;
                    encryptionModeArray2[0] = EncryptionMode.Default;
                } else {
                    EncryptionMode[] encryptionModeArray3 = new EncryptionMode[1];
                    encryptionModeArray = encryptionModeArray3;
                    encryptionModeArray3[0] = (EncryptionMode)((Object)ArrayListExtensions.getItem(list2).get(0));
                }
                this.setEncryptionModes(encryptionModeArray);
            }
            String usernameFragment = StringExtensions.empty;
            String password = null;
            if (iceUfragAttribute != null) {
                usernameFragment = iceUfragAttribute.getUfrag();
            }
            if (icePasswordAttribute != null) {
                password = icePasswordAttribute.getPassword();
            }
            if (isLocalDescription) {
                this.setLocalIceParameters(new IceParameters(usernameFragment, password));
            } else {
                this.setRemoteIceParameters(new IceParameters(usernameFragment, password));
            }
        }
        if (isRenegotiation && isOffer) {
            this.processCachedSettings();
        }
        return null;
    }

    void reset() {
        this.setCoreTransportRtcp(null);
        this.setCoreTransportRtp(null);
        this.setLocalIceParameters(null);
        this.setLocalDtlsParameters(null);
    }

    private void set_LocalCandidates(ArrayList<Candidate> value) {
        this.__localCandidates = value;
    }

    public void setCanonicalName(String value) {
        this._canonicalName = value;
    }

    void setCoreTransportRtcp(CoreTransport value) {
        this._coreTransportRtcp = value;
    }

    void setCoreTransportRtp(CoreTransport value) {
        this._coreTransportRtp = value;
    }

    public void setDisabled(boolean value) {
        this.__disabled = value;
    }

    public void setEncryptionModes(EncryptionMode[] value) {
        this.__encryptionModes = ArrayListExtensions.createArray(value);
    }

    void setIndex(int value) {
        this._index = value;
    }

    void setLocalDtlsParameters(DtlsParameters value) {
        this._localDtlsParameters = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalIceParameters(IceParameters value) {
        Object object = this.__localIceParametersLock;
        synchronized (object) {
            this.__localIceParameters = value;
        }
    }

    void setRemoteDtlsParameters(DtlsParameters value) {
        this._remoteDtlsParameters = value;
    }

    void setRemoteIceParameters(IceParameters value) {
        this._remoteIceParameters = value;
    }

    protected void setUseDtls(boolean value) {
        this._useDtls = value;
    }

    public Stream(StreamType type) {
        super(type);
        ArrayList<EncryptionMode> list = new ArrayList<EncryptionMode>();
        list.add(EncryptionMode.Default);
        this.__encryptionModes = list;
        this.__disabled = false;
        this.set_LocalCandidates(new ArrayList<Candidate>());
        this.setUseDtls(true);
        this.setDisabled(false);
    }
}

