/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.EncryptionMode;
import fm.icelink.Global;

class SrtpProtectionProfile {
    public static int encryptionModeToProtectionProfileCode(EncryptionMode encryptionMode) {
        if (Global.equals((Object)encryptionMode, (Object)EncryptionMode.Default)) {
            return SrtpProtectionProfile.getAes128CmHmacSha180ProtectionProfileCode();
        }
        if (Global.equals((Object)encryptionMode, (Object)EncryptionMode.Aes128Weak)) {
            return SrtpProtectionProfile.getAes128CmHmacSha132ProtectionProfileCode();
        }
        if (Global.equals((Object)encryptionMode, (Object)EncryptionMode.NullStrong)) {
            return SrtpProtectionProfile.getNullHmacSha180ProtectionProfileCode();
        }
        if (Global.equals((Object)encryptionMode, (Object)EncryptionMode.NullWeak)) {
            return SrtpProtectionProfile.getNullHmacSha132ProtectionProfileCode();
        }
        return 0;
    }

    public static int getAes128CmHmacSha132ProtectionProfileCode() {
        return 2;
    }

    public static String getAes128CmHmacSha132ProtectionProfileString() {
        return "SRTP_AES128_CM_HMAC_SHA1_32";
    }

    public static int getAes128CmHmacSha180ProtectionProfileCode() {
        return 1;
    }

    public static String getAes128CmHmacSha180ProtectionProfileString() {
        return "SRTP_AES128_CM_HMAC_SHA1_80";
    }

    public static int getNullHmacSha132ProtectionProfileCode() {
        return 6;
    }

    public static String getNullHmacSha132ProtectionProfileString() {
        return "SRTP_NULL_HMAC_SHA1_32";
    }

    public static int getNullHmacSha180ProtectionProfileCode() {
        return 5;
    }

    public static String getNullHmacSha180ProtectionProfileString() {
        return "SRTP_NULL_HMAC_SHA1_80";
    }

    public static int protectionProfileCodeFromString(String profileString) {
        if (Global.equals(profileString, SrtpProtectionProfile.getAes128CmHmacSha180ProtectionProfileString())) {
            return SrtpProtectionProfile.getAes128CmHmacSha180ProtectionProfileCode();
        }
        if (Global.equals(profileString, SrtpProtectionProfile.getAes128CmHmacSha132ProtectionProfileString())) {
            return SrtpProtectionProfile.getAes128CmHmacSha132ProtectionProfileCode();
        }
        if (Global.equals(profileString, SrtpProtectionProfile.getNullHmacSha180ProtectionProfileString())) {
            return SrtpProtectionProfile.getNullHmacSha180ProtectionProfileCode();
        }
        if (Global.equals(profileString, SrtpProtectionProfile.getNullHmacSha132ProtectionProfileString())) {
            return SrtpProtectionProfile.getNullHmacSha132ProtectionProfileCode();
        }
        return 0;
    }

    public static String protectionProfileStringFromCode(int profileCode) {
        if (profileCode == SrtpProtectionProfile.getAes128CmHmacSha180ProtectionProfileCode()) {
            return SrtpProtectionProfile.getAes128CmHmacSha180ProtectionProfileString();
        }
        if (profileCode == SrtpProtectionProfile.getAes128CmHmacSha132ProtectionProfileCode()) {
            return SrtpProtectionProfile.getAes128CmHmacSha132ProtectionProfileString();
        }
        if (profileCode == SrtpProtectionProfile.getNullHmacSha180ProtectionProfileCode()) {
            return SrtpProtectionProfile.getNullHmacSha180ProtectionProfileString();
        }
        if (profileCode == SrtpProtectionProfile.getNullHmacSha132ProtectionProfileCode()) {
            return SrtpProtectionProfile.getNullHmacSha132ProtectionProfileString();
        }
        return null;
    }
}

