/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IMediaTransport;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.LongExtensions;
import fm.icelink.MediaTransportState;
import fm.icelink.RtcpPacket;
import fm.icelink.RtpPacket;
import fm.icelink.SrtpAudioTransport;
import fm.icelink.SrtpTransport;
import fm.icelink.SrtpVideoTransport;
import fm.icelink.StringExtensions;
import fm.icelink.Transport;
import java.util.ArrayList;
import java.util.List;

class SrtpListener {
    private String __id;
    private Object __lock;
    private List<IAction1<DataBuffer>> __onReceiveRtcp = new ArrayList<IAction1<DataBuffer>>();
    private List<IAction1<DataBuffer>> __onReceiveRtp = new ArrayList<IAction1<DataBuffer>>();
    private List<IAction1<SrtpListener>> __onStateChange = new ArrayList<IAction1<SrtpListener>>();
    private Transport __rtcpTransport = null;
    private Transport __rtpTransport = null;
    private MediaTransportState __state;
    private IMediaTransport[] _mediaTransports;
    private IAction1<DataBuffer> _onReceiveRtcp = new IAction1<DataBuffer>(){

        @Override
        public void invoke(DataBuffer p0) {
            for (IAction1 action : new ArrayList(SrtpListener.this.__onReceiveRtcp)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<DataBuffer> _onReceiveRtp = new IAction1<DataBuffer>(){

        @Override
        public void invoke(DataBuffer p0) {
            for (IAction1 action : new ArrayList(SrtpListener.this.__onReceiveRtp)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<SrtpListener> _onStateChange = new IAction1<SrtpListener>(){

        @Override
        public void invoke(SrtpListener p0) {
            for (IAction1 action : new ArrayList(SrtpListener.this.__onStateChange)) {
                action.invoke(p0);
            }
        }
    };

    public void addOnReceiveRtcp(IAction1<DataBuffer> value) {
        this.__onReceiveRtcp.add(value);
    }

    public void addOnReceiveRtp(IAction1<DataBuffer> value) {
        this.__onReceiveRtp.add(value);
    }

    public void addOnStateChange(IAction1<SrtpListener> value) {
        this.__onStateChange.add(value);
    }

    private void attachTransportEvents() {
        this.__rtpTransport.addOnReceive((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

            @Override
            public String getId() {
                return "fm.icelink.SrtpListener.processReceive";
            }

            @Override
            public void invoke(DataBuffer buffer) {
                SrtpListener.this.processReceive(buffer);
            }
        });
        if (this.__rtcpTransport != null) {
            this.__rtcpTransport.addOnReceive((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

                @Override
                public String getId() {
                    return "fm.icelink.SrtpListener.processReceive";
                }

                @Override
                public void invoke(DataBuffer buffer) {
                    SrtpListener.this.processReceive(buffer);
                }
            });
        }
    }

    private void detachTransportEvents() {
        this.__rtpTransport.removeOnReceive((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

            @Override
            public String getId() {
                return "fm.icelink.SrtpListener.processReceive";
            }

            @Override
            public void invoke(DataBuffer buffer) {
                SrtpListener.this.processReceive(buffer);
            }
        });
        if (this.__rtcpTransport != null) {
            this.__rtcpTransport.removeOnReceive((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

                @Override
                public String getId() {
                    return "fm.icelink.SrtpListener.processReceive";
                }

                @Override
                public void invoke(DataBuffer buffer) {
                    SrtpListener.this.processReceive(buffer);
                }
            });
        }
    }

    public String getId() {
        return this.__id;
    }

    public IMediaTransport[] getMediaTransports() {
        return this._mediaTransports;
    }

    public Transport getRtcpTransport() {
        return this.__rtcpTransport;
    }

    public Transport getRtpTransport() {
        return this.__rtpTransport;
    }

    public MediaTransportState getState() {
        return this.__state;
    }

    private void processReceive(DataBuffer buffer) {
        if (!this.processRtp(buffer) && !this.processRtcp(buffer)) {
            throw new RuntimeException(new Exception("Could not validate packet."));
        }
    }

    private boolean processRtcp(DataBuffer buffer) {
        RtcpPacket packet = new RtcpPacket(buffer);
        if (packet != null) {
            if (packet.getBuffer().getLength() >= 8) {
                long synchronizationSource = packet.getBuffer().read32(4);
                this.raiseReceive(packet.getBuffer(), synchronizationSource);
                return true;
            }
            Log.warn("Discarding RTCP packet as it contains no SSRC or Payload.");
        }
        return false;
    }

    private boolean processRtp(DataBuffer buffer) {
        RtpPacket packet = RtpPacket.wrap(buffer);
        if (packet != null) {
            this.raiseReceive(buffer, packet.getSynchronizationSource(), packet.getPayloadType());
            return true;
        }
        return false;
    }

    private void raiseReceive(DataBuffer buffer, long synchronizationSource) {
        this.raiseReceive(buffer, synchronizationSource, -1);
    }

    private void raiseReceive(DataBuffer buffer, long synchronizationSource, int rtpPayloadType) {
        boolean flag = true;
        boolean flag2 = true;
        for (IMediaTransport transport : this.getMediaTransports()) {
            IAction1<DataBuffer> action;
            if (rtpPayloadType != -1 && !transport.hasPayloadType(rtpPayloadType)) continue;
            flag = false;
            if ((rtpPayloadType != -1 || ArrayExtensions.getLength(transport.getRemoteSynchronizationSources()) != 0) && !transport.hasRemoteSynchronizationSource(synchronizationSource)) continue;
            flag2 = false;
            IAction1<DataBuffer> iAction1 = action = rtpPayloadType >= 0 ? this._onReceiveRtp : this._onReceiveRtcp;
            if (action == null) continue;
            action.invoke(buffer);
        }
        if (flag) {
            Log.warn(StringExtensions.format("Discarding RTP packet with unrecognized payload type '{0}'.", IntegerExtensions.toString(rtpPayloadType)));
        } else if (flag2) {
            if (rtpPayloadType >= 0) {
                Log.debug(StringExtensions.format("Discarding {0} packet with unrecognized synchronization source of {1} for payload type {2}.", rtpPayloadType == -1 ? "RTCP" : "RTP", LongExtensions.toString(synchronizationSource), IntegerExtensions.toString(rtpPayloadType)));
            } else {
                Log.warn(StringExtensions.format("Discarding {0} packet with unrecognized synchronization source '{1}'.", rtpPayloadType == -1 ? "RTCP" : "RTP", LongExtensions.toString(synchronizationSource)));
            }
        }
    }

    public void removeOnReceiveRtcp(IAction1<DataBuffer> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onReceiveRtcp, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onReceiveRtcp.remove(value);
    }

    public void removeOnReceiveRtp(IAction1<DataBuffer> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onReceiveRtp, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onReceiveRtp.remove(value);
    }

    public void removeOnStateChange(IAction1<SrtpListener> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onStateChange.remove(value);
    }

    public void setMediaTransports(IMediaTransport[] value) {
        this._mediaTransports = value;
    }

    public SrtpListener(Object lockObject, Transport rtpTransport, Transport rtcpTransport, SrtpVideoTransport videoTransport) {
        this(lockObject, rtpTransport, rtcpTransport, new SrtpVideoTransport[]{videoTransport}, new SrtpAudioTransport[0]);
    }

    public SrtpListener(Object lockObject, Transport rtpTransport, Transport rtcpTransport, SrtpVideoTransport[] videoTransports, SrtpAudioTransport[] audioTransports) {
        this.__id = Guid.newGuid().toString().replace("-", "");
        this.__state = MediaTransportState.New;
        this.__lock = lockObject;
        this.setMediaTransports(new IMediaTransport[ArrayExtensions.getLength(videoTransports) + ArrayExtensions.getLength(audioTransports)]);
        int num = 0;
        for (SrtpVideoTransport srtpVideoTransport : videoTransports) {
            srtpVideoTransport.setListener(this);
            this.getMediaTransports()[num++] = srtpVideoTransport;
        }
        for (SrtpTransport srtpTransport : audioTransports) {
            this.getMediaTransports()[num++] = srtpTransport;
        }
        this.__rtpTransport = rtpTransport;
        this.__rtcpTransport = rtcpTransport;
    }

    public SrtpListener(Object lockObject, Transport rtpTransport, Transport rtcpTransport, SrtpAudioTransport audioTransport) {
        this(lockObject, rtpTransport, rtcpTransport, new SrtpVideoTransport[0], new SrtpAudioTransport[]{audioTransport});
    }

    public SrtpListener(Object lockObject, Transport rtpTransport, Transport rtcpTransport, SrtpVideoTransport videoTransport, SrtpAudioTransport audioTransport) {
        this(lockObject, rtpTransport, rtcpTransport, new SrtpVideoTransport[]{videoTransport}, new SrtpAudioTransport[]{audioTransport});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        Object object = this.__lock;
        synchronized (object) {
            if (Global.equals((Object)this.__state, (Object)MediaTransportState.Started)) {
                return false;
            }
            this.attachTransportEvents();
            this.__state = MediaTransportState.Started;
            IAction1<SrtpListener> onStateChange = this._onStateChange;
            if (onStateChange != null) {
                onStateChange.invoke(this);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        Object object = this.__lock;
        synchronized (object) {
            if (Global.equals((Object)this.__state, (Object)MediaTransportState.Stopped)) {
                return false;
            }
            this.detachTransportEvents();
            this.__state = MediaTransportState.Stopped;
            IAction1<SrtpListener> onStateChange = this._onStateChange;
            if (onStateChange != null) {
                onStateChange.invoke(this);
            }
        }
        Log.debug(StringExtensions.format("Listener {0} shut down.", this.getId()));
        this.__rtcpTransport = null;
        this.__rtpTransport = null;
        return true;
    }
}

