/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioConfig;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.AudioPipe;
import fm.icelink.DataBuffer;
import fm.icelink.IAudioSource;
import fm.icelink.IMediaSource;
import fm.icelink.IntegerExtensions;
import fm.icelink.Resampler;
import fm.icelink.SoundUtility;
import fm.icelink.StringExtensions;
import fm.icelink.pcm.Format;

public class SoundConverter
extends AudioPipe {
    private Resampler __resampler;

    @Override
    protected void doDestroy() {
    }

    @Override
    protected void doProcessFrame(AudioFrame frame, AudioBuffer inputBuffer) {
        if (!((AudioFormat)inputBuffer.getFormat()).isEquivalent(super.getOutputFormat())) {
            int clockRate = ((AudioFormat)inputBuffer.getFormat()).getClockRate();
            int channelCount = ((AudioFormat)inputBuffer.getFormat()).getChannelCount();
            int targetClockRate = ((AudioFormat)super.getOutputFormat()).getClockRate();
            int num4 = ((AudioFormat)super.getOutputFormat()).getChannelCount();
            DataBuffer dataBuffer = inputBuffer.getDataBuffer();
            AudioFormat format = (AudioFormat)inputBuffer.getFormat();
            boolean flag = false;
            if (channelCount != num4 && channelCount == 2 && num4 == 1) {
                if ((dataBuffer = SoundUtility.stereoToMono(dataBuffer)) == null) {
                    throw new RuntimeException(new Exception(StringExtensions.format("Could not convert audio buffer channel count from {0} to {1}.", IntegerExtensions.toString(channelCount), IntegerExtensions.toString(num4))));
                }
                format = format.clone();
                format.setChannelCount(num4);
                flag = true;
            }
            if (channelCount != num4 && channelCount == 1 && num4 == 2) {
                if ((dataBuffer = SoundUtility.monoToStereo(dataBuffer)) == null) {
                    throw new RuntimeException(new Exception(StringExtensions.format("Could not convert audio buffer channel count from {0} to {1}.", IntegerExtensions.toString(channelCount), IntegerExtensions.toString(num4))));
                }
                format = format.clone();
                format.setChannelCount(num4);
                flag = true;
            }
            if (clockRate != targetClockRate) {
                if (this.__resampler == null) {
                    this.__resampler = new Resampler(clockRate, targetClockRate);
                }
                if ((dataBuffer = this.__resampler.resample(dataBuffer)) == null) {
                    throw new RuntimeException(new Exception(StringExtensions.format("Could not convert audio buffer clock rate from {0} to {1}.", IntegerExtensions.toString(clockRate), IntegerExtensions.toString(targetClockRate))));
                }
                format = format.clone();
                format.setClockRate(targetClockRate);
                flag = true;
            }
            if (flag) {
                frame.addBuffer(new AudioBuffer(dataBuffer, format));
            }
        }
        this.raiseFrame(frame);
    }

    @Override
    public String getLabel() {
        return "Sound Converter";
    }

    public SoundConverter(AudioConfig outputConfig) {
        super(new Format(outputConfig));
    }

    public SoundConverter(IAudioSource source, AudioConfig outputConfig) {
        this(source.getConfig(), outputConfig);
        super.addSource(source);
    }

    public SoundConverter(AudioConfig inputConfig, AudioConfig outputConfig) {
        super(new Format(inputConfig), new Format(outputConfig));
    }

    public SoundConverter(IAudioSource[] sources, AudioConfig outputConfig) {
        this(sources[0].getConfig(), outputConfig);
        super.addSources((IMediaSource[])sources);
    }
}

