/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.CompareResult;
import fm.icelink.Global;
import fm.icelink.IFunction2;
import java.util.ArrayList;

public class Sort {
    private static <T> void doQuickSort(ArrayList<T> array, int left, int right, IFunction2<T, T, CompareResult> comparer) {
        if (left < right) {
            int pivotIndex = left + (right - left) / 2;
            int num2 = Sort.partition(array, left, right, pivotIndex, comparer);
            Sort.doQuickSort(array, left, num2 - 1, comparer);
            Sort.doQuickSort(array, num2 + 1, right, comparer);
        }
    }

    private static <T> int partition(ArrayList<T> array, int left, int right, int pivotIndex, IFunction2<T, T, CompareResult> comparer) {
        T local = ArrayListExtensions.getItem(array).get(pivotIndex);
        Sort.swap(array, pivotIndex, right);
        int num = left;
        for (int i = left; i < right; ++i) {
            if (!Global.equals((Object)comparer.invoke(ArrayListExtensions.getItem(array).get(i), local), (Object)CompareResult.Negative)) continue;
            Sort.swap(array, i, num);
            ++num;
        }
        Sort.swap(array, num, right);
        return num;
    }

    public static <T> void quickSort(ArrayList<T> array, IFunction2<T, T, CompareResult> comparer) {
        int right = ArrayListExtensions.getCount(array) - 1;
        Sort.doQuickSort(array, 0, right, comparer);
    }

    private static <T> void swap(ArrayList<T> array, int pos1, int pos2) {
        T local = ArrayListExtensions.getItem(array).get(pos1);
        ArrayListExtensions.getItem(array).set(pos1, ArrayListExtensions.getItem(array).get(pos2));
        ArrayListExtensions.getItem(array).set(pos2, local);
    }
}

