/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.Utf8;

public class SdesItem {
    private DataBuffer _dataBuffer;

    public DataBuffer getDataBuffer() {
        return this._dataBuffer;
    }

    public static int getFixedPayloadHeaderLength() {
        return 2;
    }

    public int getLength() {
        return this.getDataBuffer().read8(1);
    }

    public String getText() {
        return Utf8.decode(this.getDataBuffer().subset(2, this.getLength()).toArray());
    }

    public int getType() {
        return this.getDataBuffer().read8(0);
    }

    public SdesItem(int type, String text) {
        if (text == null) {
            throw new RuntimeException(new Exception("SDES item text cannot be null."));
        }
        byte[] data = Utf8.encode(text);
        if (ArrayExtensions.getLength(data) > 255) {
            throw new RuntimeException(new Exception("Cannot serialize an RTCP SDES chunk item with more than 255 bytes of text. Text string too long."));
        }
        int length = (SdesItem.getFixedPayloadHeaderLength() + ArrayExtensions.getLength(data)) % 4;
        this.setDataBuffer(DataBuffer.allocate(SdesItem.getFixedPayloadHeaderLength() + ArrayExtensions.getLength(data) + length));
        this.getDataBuffer().set((byte)0, SdesItem.getFixedPayloadHeaderLength() + ArrayExtensions.getLength(data), length);
        this.getDataBuffer().write(DataBuffer.wrap(data), SdesItem.getFixedPayloadHeaderLength());
        this.setType(type);
        this.setLength(ArrayExtensions.getLength(data) + length);
    }

    public SdesItem(DataBuffer buffer) {
        this.setDataBuffer(buffer);
        if (buffer.getLength() % 4 != 0) {
            throw new RuntimeException(new Exception("DataBuffer must be 32-bit aligned for SDES Items"));
        }
    }

    private void setDataBuffer(DataBuffer value) {
        this._dataBuffer = value;
    }

    private void setLength(int value) {
        if (value > 255) {
            throw new RuntimeException(new Exception("SdesItem cannot have a length longer than 255."));
        }
        this.getDataBuffer().write8(value, 1);
    }

    private void setText(String value) {
        byte[] data = Utf8.encode(value);
        if (ArrayExtensions.getLength(data) > 255) {
            throw new RuntimeException(new Exception("Cannot serialize an RTCP SDES chunk item with more than 255 bytes of text"));
        }
        this.getDataBuffer().write(DataBuffer.wrap(data), 2);
    }

    public void setType(int value) {
        this.getDataBuffer().write8(value, 0);
    }
}

