/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.MediaControlFrame;
import fm.icelink.SdesChunk;

public class SdesControlFrame
extends MediaControlFrame {
    private SdesChunk[] _chunks;

    public SdesChunk[] getChunks() {
        return this._chunks;
    }

    public static int getFixedPayloadHeaderLength() {
        return 0;
    }

    public static int getRegisteredPayloadType() {
        return 202;
    }

    public int getSourceCount() {
        return super.getByte1Last5Bits();
    }

    public SdesControlFrame(DataBuffer buffer) {
        super(buffer);
        super.setPayloadType(SdesControlFrame.getRegisteredPayloadType());
    }

    public SdesControlFrame(SdesChunk chunk) {
        SdesChunk[] sdesChunkArray;
        if (chunk == null) {
            sdesChunkArray = null;
        } else {
            SdesChunk[] sdesChunkArray2 = new SdesChunk[1];
            sdesChunkArray = sdesChunkArray2;
            sdesChunkArray2[0] = chunk;
        }
        this(sdesChunkArray);
    }

    public SdesControlFrame(SdesChunk[] chunks) {
        this.setChunks(new SdesChunk[ArrayExtensions.getLength(chunks)]);
        int fixedHeaderLength = MediaControlFrame.getFixedHeaderLength();
        for (SdesChunk chunk : chunks) {
            fixedHeaderLength += chunk.getDataBuffer().getLength();
        }
        super.setDataBuffer(DataBuffer.allocate(fixedHeaderLength));
        this.setSourceCount(ArrayExtensions.getLength(chunks));
        super.setPayloadType(SdesControlFrame.getRegisteredPayloadType());
        super.setPayloadLengthWithPadding(fixedHeaderLength - MediaControlFrame.getFixedHeaderLength());
        int offset = MediaControlFrame.getFixedHeaderLength();
        for (int i = 0; i < ArrayExtensions.getLength(chunks); ++i) {
            DataBuffer buffer = super.getDataBuffer().subset(offset, chunks[i].getDataBuffer().getLength());
            this.getChunks()[i] = new SdesChunk(buffer);
            buffer.write(chunks[i].getDataBuffer(), 0);
            offset += chunks[i].getDataBuffer().getLength();
        }
    }

    public SdesControlFrame() {
        super(DataBuffer.allocate(MediaControlFrame.getFixedHeaderLength()));
        this.setSourceCount(0);
        this.setChunks(new SdesChunk[0]);
        super.setPayloadType(SdesControlFrame.getRegisteredPayloadType());
        super.setPayloadLengthWithPadding(MediaControlFrame.getFixedHeaderLength());
    }

    private void setChunks(SdesChunk[] value) {
        this._chunks = value;
    }

    private void setSourceCount(int value) {
        super.setByte1Last5Bits(value);
    }
}

