/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpChunk;
import fm.icelink.SctpErrorCause;
import fm.icelink.StringExtensions;

class SctpUnrecognizedChunkType
extends SctpErrorCause {
    private SctpChunk _unrecognizedChunk;

    @Override
    public byte[] getBytes() {
        return SctpUnrecognizedChunkType.getBytes(this);
    }

    public static byte[] getBytes(SctpUnrecognizedChunkType cause) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(cause.getCauseCode(), false));
        try {
            byte[] buffer = cause.getUnrecognizedChunk().getBytes();
            bytes.addRange(Binary.toBytes16(ArrayExtensions.getLength(buffer) + 4, false));
            bytes.addRange(buffer);
        }
        catch (Exception exception1) {
            Log.debug("SCTP: could not process bytes of an unknown chunk");
        }
        return bytes.toArray();
    }

    public SctpChunk getUnrecognizedChunk() {
        return this._unrecognizedChunk;
    }

    public static SctpUnrecognizedChunkType parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            SctpChunk _var0 = SctpChunk.parseBytes(bytes, 4, offsetPlus);
            SctpUnrecognizedChunkType type = new SctpUnrecognizedChunkType(_var0);
            int num = type.getUnrecognizedChunk().getType();
            Log.debug(StringExtensions.format("SCTP Error: unrecognized chunk type: {0}", IntegerExtensions.toString(num)));
            offsetPlus.setValue(offsetPlus.getValue() + 4);
            return type;
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpUnrecognizedChunkType(SctpChunk unrecognizedChunk) {
        super.setCauseCode(6);
        this.setUnrecognizedChunk(unrecognizedChunk);
    }

    public void setUnrecognizedChunk(SctpChunk value) {
        this._unrecognizedChunk = value;
    }
}

