/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.ByteCollection;
import fm.icelink.ByteExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.LockedRandomizer;
import fm.icelink.Log;
import fm.icelink.LongExtensions;
import fm.icelink.LongHolder;
import fm.icelink.ManagedThread;
import fm.icelink.MathAssistant;
import fm.icelink.NullableLong;
import fm.icelink.ScheduledItem;
import fm.icelink.Scheduler;
import fm.icelink.SctpAbortChunk;
import fm.icelink.SctpChunk;
import fm.icelink.SctpChunkType;
import fm.icelink.SctpCommonHeader;
import fm.icelink.SctpControlChunk;
import fm.icelink.SctpCookieAckChunk;
import fm.icelink.SctpCookieEchoChunk;
import fm.icelink.SctpDataChunk;
import fm.icelink.SctpDataQueue;
import fm.icelink.SctpErrorCause;
import fm.icelink.SctpErrorChunk;
import fm.icelink.SctpHeartbeatAckChunk;
import fm.icelink.SctpHeartbeatChunk;
import fm.icelink.SctpInitAckChunk;
import fm.icelink.SctpInitChunk;
import fm.icelink.SctpMessage;
import fm.icelink.SctpPacket;
import fm.icelink.SctpResendArgs;
import fm.icelink.SctpSCTPGapAckBlock;
import fm.icelink.SctpSackChunk;
import fm.icelink.SctpSendControlChunkQueue;
import fm.icelink.SctpShutdownCompleteChunk;
import fm.icelink.SctpStaleCookieError;
import fm.icelink.SctpStateCookie;
import fm.icelink.SctpStateCookieChunkParameter;
import fm.icelink.SctpStream;
import fm.icelink.SctpStreams;
import fm.icelink.SctpTcbState;
import fm.icelink.SctpTlvParameter;
import fm.icelink.SctpTransmissionControlBlock;
import fm.icelink.SctpTransportState;
import fm.icelink.SctpUnrecognizedChunkType;
import fm.icelink.SctpUnrecognizedParameterChunkParameter;
import fm.icelink.SctpUnrecognizedParameters;
import fm.icelink.StringExtensions;
import fm.icelink.Transport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class SctpTransport {
    private boolean __dataRetransmission;
    private SctpErrorChunk __errorToCombineWithCookieEcho;
    private ScheduledItem __initiationControlChunkScheduledItem = null;
    private Transport __innerTransport;
    private boolean __newDATAAvailable;
    private SctpDataChunk __nextDataChunkToBeExaminedForSending;
    private int __numberOfPacketsSentSinceLastProcessorYield;
    private List<IAction1<SctpTransport>> __onStateChange = new ArrayList<IAction1<SctpTransport>>();
    private ScheduledItem __outgoingQueueScheduledItem = null;
    private SctpDataQueue __receiveDATAQueue;
    private Scheduler __scheduler;
    private SctpSendControlChunkQueue __sendControlChunkQueue;
    private SctpDataQueue __sendDATAQueue;
    private Object __stateLock;
    private SctpTransmissionControlBlock __tcb;
    private Error _error;
    private String _id;
    private IAction1<SctpMessage> _onMessage;
    private IAction1<SctpTransport> _onStateChange = new IAction1<SctpTransport>(){

        @Override
        public void invoke(SctpTransport p0) {
            for (IAction1 action : new ArrayList(SctpTransport.this.__onStateChange)) {
                action.invoke(p0);
            }
        }
    };
    private boolean _verboseLogging = false;

    public void addOnStateChange(IAction1<SctpTransport> value) {
        this.__onStateChange.add(value);
    }

    private void assembleMessage(Holder<byte[]> message, Holder<long[]> tsnArray, long currentTSN) {
        boolean flag = false;
        ArrayList<SctpDataChunk> list = new ArrayList<SctpDataChunk>();
        ArrayList<LongHolder> list2 = new ArrayList<LongHolder>();
        ByteCollection bytes = new ByteCollection();
        while (!flag) {
            list.add(this.__receiveDATAQueue.getChunk(currentTSN));
            list2.add(new LongHolder(currentTSN));
            if (this.__receiveDATAQueue.getChunk(currentTSN).getBeginning()) {
                flag = true;
                continue;
            }
            if (this.__receiveDATAQueue.chunkExists(currentTSN = SctpDataChunk.decrementTSN(currentTSN))) continue;
            Log.error("SCTP: While assembling, did not encounter the beginning of the message in the receiving queue.");
            flag = true;
        }
        for (int i = ArrayListExtensions.getCount(list) - 1; i > -1; --i) {
            bytes.addRange(((SctpDataChunk)ArrayListExtensions.getItem(list).get(i)).getUserData());
        }
        message.setValue(bytes.toArray());
        tsnArray.setValue(new long[ArrayListExtensions.getCount(list2)]);
        for (int j = 0; j < ArrayExtensions.getLength(tsnArray.getValue()); ++j) {
            tsnArray.getValue()[j] = ((LongHolder)ArrayListExtensions.getItem(list2).get(j)).getValue();
        }
    }

    private boolean buildSCTPPacket(Holder<SctpPacket> packet, boolean requestSACKImmediately) {
        boolean flag3;
        ScheduledItem resendScheduledItem = null;
        long peerVerificationTag = this.__tcb.getPeerVerificationTag();
        if (this._verboseLogging) {
            Log.debug(StringExtensions.format("Building outgoing SCTP packet. Peer verification tag is set to {0}.", LongExtensions.toString(peerVerificationTag)));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        boolean flag = true;
        boolean flag2 = false;
        boolean bl = flag3 = !this.__tcb.getRemoteLikelyInConnectedState() && this.__sendDATAQueue.getCount() > 0 && Global.equals((Object)this.getState(), (Object)SctpTransportState.Connected) && this.__tcb.getCookieAckSent();
        if (this.__sendControlChunkQueue.getCount() > 0 || flag3) {
            SctpControlChunk chunk = this.__sendControlChunkQueue.dequeue();
            if (chunk == null && flag3) {
                if (!this.__tcb.getRemoteLikelyInConnectedState() && this.__sendDATAQueue.getCount() > 0 && Global.equals((Object)this.getState(), (Object)SctpTransportState.Connected)) {
                    chunk = new SctpCookieAckChunk();
                }
            } else if (chunk.getType() == SctpChunkType.getInitiationAck()) {
                peerVerificationTag = ((SctpInitAckChunk)chunk).getStateCookieChunk().getStateCookie().getPeerVerificationTag();
                if (this._verboseLogging) {
                    Log.debug(StringExtensions.format("Updating peer verification tag to {0}.", LongExtensions.toString(peerVerificationTag)));
                }
            } else if (chunk.getType() == SctpChunkType.getCookieAck()) {
                this.__tcb.setCookieAckSent(true);
            }
            if (this._verboseLogging) {
                Log.debug(StringExtensions.format("Outgoing SCTP packet will contain control chunk of type {0}.", IntegerExtensions.toString(chunk.getType())));
            }
            flag &= chunk.getCanBundleWithDataAndSackChunks();
            list.add(chunk);
            if (resendScheduledItem == null) {
                resendScheduledItem = chunk.getResendScheduledItem();
            }
            if (chunk.getType() == SctpChunkType.getCookieEcho() && this.__errorToCombineWithCookieEcho != null && ArrayExtensions.getLength(chunk.getBytes()) + ArrayExtensions.getLength(this.__errorToCombineWithCookieEcho.getBytes()) <= 1050) {
                list.add(this.__errorToCombineWithCookieEcho);
                this.__errorToCombineWithCookieEcho = null;
            }
            if (this.__sendControlChunkQueue.getCount() > 0) {
                flag2 = true;
            }
        }
        int num2 = 0;
        if (this.__tcb.getEarliestAllowedSackSendTime() != (long)ScheduledItem.getUnset() && this.__tcb.getEarliestAllowedSackSendTime() < Scheduler.getCurrentTime() && this.__tcb.getSackCounter() > 0) {
            if (flag) {
                for (SctpChunk sctpChunk : list) {
                    num2 += ArrayExtensions.getLength(sctpChunk.getBytes());
                }
                SctpSackChunk sackOnReceivedData = this.__tcb.getSackOnReceivedData();
                if (num2 + ArrayExtensions.getLength(sackOnReceivedData.getBytes(1050)) < 1050) {
                    if (this._verboseLogging) {
                        Log.debug(StringExtensions.format("Adding a SACK to outgoing SCTP packet. Current SACK counter: {0}. Cumulative ACK: {1}. Number of blocks: {2}", IntegerExtensions.toString(this.__tcb.getSackCounter()), LongExtensions.toString(sackOnReceivedData.getCumulativeTsnAck()), IntegerExtensions.toString(sackOnReceivedData.getNumberOfGapAckBlocks())));
                    }
                    this.__tcb.setSackCounter(0);
                    list.add(sackOnReceivedData);
                    this.__tcb.setEarliestAllowedSackSendTime(ScheduledItem.getUnset());
                } else {
                    flag2 = true;
                }
            } else {
                flag2 = true;
            }
        }
        if (this.__sendDATAQueue.getCount() > 0 && this.get_CanSendDataChunksInState()) {
            if (flag) {
                for (SctpChunk sctpChunk : list) {
                    num2 += ArrayExtensions.getLength(sctpChunk.getBytes());
                }
                boolean flag4 = false;
                while (!flag4 && this.__nextDataChunkToBeExaminedForSending != null) {
                    if (!this.__nextDataChunkToBeExaminedForSending.getAcked() && (this.__nextDataChunkToBeExaminedForSending.getTransmissionTime() < 0L && this.__tcb.getCongestionWindow() <= this.__tcb.getMaximumStaticCongestionWindow() || this.__dataRetransmission && this.__nextDataChunkToBeExaminedForSending.getTransmissionTime() > 0L)) {
                        int n = num2 + ArrayExtensions.getLength(this.__nextDataChunkToBeExaminedForSending.getBytes());
                        if (num2 + ArrayExtensions.getLength(this.__nextDataChunkToBeExaminedForSending.getBytes()) < 1050) {
                            list.add(this.__nextDataChunkToBeExaminedForSending);
                            if (this.__nextDataChunkToBeExaminedForSending.getTransmissionTime() < 0L) {
                                this.__tcb.setCongestionWindow(this.__tcb.getCongestionWindow() + 1L);
                            }
                            this.__nextDataChunkToBeExaminedForSending.setTransmissionTime(Scheduler.getCurrentTime());
                            if (requestSACKImmediately) {
                                this.__nextDataChunkToBeExaminedForSending.setSackImmediately(true);
                            } else if (!this.__nextDataChunkToBeExaminedForSending.getEnding()) {
                                this.__nextDataChunkToBeExaminedForSending.setSackImmediately(false);
                            }
                            num2 = n;
                            this.__nextDataChunkToBeExaminedForSending = this.__sendDATAQueue.getNextChunk(this.__nextDataChunkToBeExaminedForSending.getTsn());
                            continue;
                        }
                        flag4 = true;
                        continue;
                    }
                    this.__nextDataChunkToBeExaminedForSending = this.__sendDATAQueue.getNextChunk(this.__nextDataChunkToBeExaminedForSending.getTsn());
                }
                if (this.__nextDataChunkToBeExaminedForSending != null) {
                    flag2 = true;
                }
            } else {
                flag2 = true;
            }
        }
        SctpCommonHeader header = new SctpCommonHeader(this.getLocalPort(), this.__tcb.getDestinationPort(), peerVerificationTag);
        if (ArrayListExtensions.getCount(list) > 0) {
            packet.setValue(new SctpPacket(header, list.toArray(new SctpChunk[0])));
            if (resendScheduledItem != null) {
                SctpResendArgs sctpResendArgs = (SctpResendArgs)resendScheduledItem.getState();
                sctpResendArgs.setPacketBytes(DataBuffer.wrap(packet.getValue().getBytes()));
                this.__scheduler.add(resendScheduledItem);
                resendScheduledItem = null;
            }
            return flag2;
        }
        packet.setValue(null);
        return flag2;
    }

    private boolean checkVerificationTag(SctpPacket packet) {
        if (ArrayExtensions.getLength(packet.getChunks()) > 0) {
            if (packet.getChunks()[0].getType() == SctpChunkType.getInitiation()) {
                return packet.getHeader().getVerificationTag() == 0L;
            }
            if (packet.getChunks()[0].getType() == SctpChunkType.getAbort()) {
                SctpAbortChunk chunk = (SctpAbortChunk)packet.getChunks()[0];
                if (chunk.getVerificationTagReflected()) {
                    return this.__tcb.getPeerVerificationTag() == packet.getHeader().getVerificationTag();
                }
                return this.__tcb.getMyVerificationTag() == packet.getHeader().getVerificationTag();
            }
            if (packet.getChunks()[0].getType() == SctpChunkType.getShutdownComplete()) {
                SctpShutdownCompleteChunk chunk2 = (SctpShutdownCompleteChunk)packet.getChunks()[0];
                if (chunk2.getVerificationTagReflected()) {
                    return this.__tcb.getPeerVerificationTag() == packet.getHeader().getVerificationTag();
                }
                return this.__tcb.getMyVerificationTag() == packet.getHeader().getVerificationTag();
            }
            if (packet.getChunks()[0].getType() == SctpChunkType.getCookieEcho()) {
                return true;
            }
            if (packet.getChunks()[0].getType() == SctpChunkType.getShutdownAck() && (Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieWait))) {
                return false;
            }
        }
        return this.__tcb.getMyVerificationTag() == packet.getHeader().getVerificationTag();
    }

    private void closeOnFailure(Exception ex) {
        Log.debug("SCTP: Failure occurred. Proceeding to Close the SCTP Association.");
        Error error = new Error(ErrorCode.SctpInternalError);
        error.setException(ex);
        this.setError(error);
        this.set_InnerState(SctpTcbState.Failing);
        this.stopAllDataChunkTransmission();
        this.stopAllControlChunkTransmission();
        this.set_InnerState(SctpTcbState.Failed);
        Log.debug("SCTP: Association shut down.");
        this.__innerTransport = null;
    }

    private void dispatch(DataBuffer buffer) {
        Transport transport = this.__innerTransport;
        if (transport != null && !transport.getIsClosed()) {
            try {
                transport.send(buffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean get_Active() {
        return Global.equals((Object)this.getState(), (Object)SctpTransportState.Closing) || Global.equals((Object)this.getState(), (Object)SctpTransportState.Connected) || Global.equals((Object)this.getState(), (Object)SctpTransportState.Connecting);
    }

    private boolean get_CanSendDataChunksInState() {
        return Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Established) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Closing) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SctpTcbState get_InnerState() {
        Object object = this.__stateLock;
        synchronized (object) {
            if (this.__tcb != null) {
                return this.__tcb.getState();
            }
            return SctpTcbState.ClosedNeverOpened;
        }
    }

    public Error getError() {
        return this._error;
    }

    public String getId() {
        return this._id;
    }

    public Transport getInnerTransport() {
        return this.__innerTransport;
    }

    public boolean getIsClosed() {
        return Global.equals((Object)this.getState(), (Object)SctpTransportState.Closed) || Global.equals((Object)this.getState(), (Object)SctpTransportState.Closing) || Global.equals((Object)this.getState(), (Object)SctpTransportState.Failed) || Global.equals((Object)this.getState(), (Object)SctpTransportState.New);
    }

    public int getLocalPort() {
        return this.__tcb == null ? SctpTransport.getUnset() : this.__tcb.getSourcePort();
    }

    private int getNewDataPacketCountTrigger() {
        return 4;
    }

    public IAction1<SctpMessage> getOnMessage() {
        return this._onMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SctpTransportState getState() {
        Object object = this.__stateLock;
        synchronized (object) {
            if (this.__tcb != null) {
                if (Global.equals((Object)this.__tcb.getState(), (Object)SctpTcbState.ClosedNeverOpened)) {
                    return SctpTransportState.New;
                }
                if (Global.equals((Object)this.__tcb.getState(), (Object)SctpTcbState.Failed)) {
                    return SctpTransportState.Failed;
                }
                if (Global.equals((Object)this.__tcb.getState(), (Object)SctpTcbState.Closed)) {
                    return SctpTransportState.Closed;
                }
                if (Global.equals((Object)this.__tcb.getState(), (Object)SctpTcbState.Closing)) {
                    return SctpTransportState.Closing;
                }
                if (Global.equals((Object)this.__tcb.getState(), (Object)SctpTcbState.Failing)) {
                    return SctpTransportState.Failing;
                }
                if (Global.equals((Object)this.__tcb.getState(), (Object)SctpTcbState.CookieEchoed)) {
                    return SctpTransportState.Connecting;
                }
                if (Global.equals((Object)this.__tcb.getState(), (Object)SctpTcbState.CookieWait)) {
                    return SctpTransportState.Connecting;
                }
                if (!Global.equals((Object)this.__tcb.getState(), (Object)SctpTcbState.Established)) {
                    throw new RuntimeException(new Exception(StringExtensions.format("SCTP: unknown TCB state {0}.", this.__tcb.getState().toString())));
                }
                return SctpTransportState.Connected;
            }
            return SctpTransportState.New;
        }
    }

    private int getT3TimerExtension() {
        return 1000;
    }

    public static int getUnset() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializationFailure(ScheduledItem item) {
        SctpResendArgs args = (SctpResendArgs)item.getState();
        SctpTcbState state = args.getState();
        Object object = this.__stateLock;
        synchronized (object) {
            if (Global.equals((Object)state, (Object)this.get_InnerState())) {
                String message = "";
                message = this._verboseLogging ? StringExtensions.format("SCTP has not received valid response to a control chunk of type {0} within expected time period at {1}.", ByteExtensions.toString(args.getType()), LongExtensions.toString(Scheduler.getCurrentTime())) : StringExtensions.format("SCTP has not received valid response to a control chunk of type {0} within expected time period.", ByteExtensions.toString(args.getType()));
                Log.debug(message);
                this.closeOnFailure(new Exception(message));
            }
        }
    }

    private void initiate() {
        if (Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Closed) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Failed) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.ClosedNeverOpened)) {
            ScheduledItem item;
            this.__tcb.setMyVerificationTag(MathAssistant.max(1L, (long)(4.294967295E9 * LockedRandomizer.nextDouble())));
            this.__tcb.setNextTsnToSend(this.__tcb.getMyVerificationTag());
            SctpInitChunk controlChunk = new SctpInitChunk(this.__tcb.getMyVerificationTag(), this.__tcb.getAdvertisedReceiverWindowCredit(), this.__tcb.getOutboundStreams().getCount(), this.__tcb.getInboundStreams().getCount(), this.__tcb.getNextTsnToSend(), this.__tcb.getPartialReliabilitySupport(), this.__tcb.getAuthenticatedChunksSupport(), this.__tcb.getDynamicAddressReconfigurationSupport(), null, null);
            this.set_InnerState(SctpTcbState.CookieWait);
            SctpResendArgs args2 = new SctpResendArgs(SctpTcbState.CookieWait);
            args2.setType(SctpChunkType.getInitiation());
            SctpResendArgs args = args2;
            ScheduledItem item2 = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                @Override
                public String getId() {
                    return "fm.icelink.SctpTransport.resendPacket";
                }

                @Override
                public void invoke(ScheduledItem item) {
                    SctpTransport.this.resendPacket(item);
                }
            }, 200, 200, 10000, ScheduledItem.getUnset());
            item2.setState(args);
            item2.setTimeoutCallback((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                @Override
                public String getId() {
                    return "fm.icelink.SctpTransport.initializationFailure";
                }

                @Override
                public void invoke(ScheduledItem item) {
                    SctpTransport.this.initializationFailure(item);
                }
            });
            this.__initiationControlChunkScheduledItem = item = item2;
            controlChunk.setResendScheduledItem(item);
            this.__sendControlChunkQueue.enqueue(controlChunk);
            if (this._verboseLogging) {
                Log.debug(StringExtensions.format("SCTP: sending INIT at {0} and moving into the COOKIE_WAIT state. My verification tag = Next TSN to send: {1}.", LongExtensions.toString(Scheduler.getCurrentTime()), LongExtensions.toString(this.__tcb.getNextTsnToSend())));
            } else {
                Log.debug("SCTP: sending INIT and moving into the COOKIE_WAIT state.");
            }
            this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processIncomingSctpPacket(DataBuffer buffer) {
        byte[] sctpBytes = buffer.toArray();
        int length = buffer.getLength();
        if (this._verboseLogging) {
            Log.debug(StringExtensions.format("SCTP Manager received an SCTP packet at {0}", LongExtensions.toString(Scheduler.getCurrentTime())));
        }
        if (!SctpPacket.verifyCRC32cChecksum(sctpBytes, 0, length)) {
            if (this._verboseLogging) {
                Log.debug(StringExtensions.format("Incoming packet dropped due to invalid CRC32c checksum at {0}", LongExtensions.toString(Scheduler.getCurrentTime())));
            }
        } else {
            SctpPacket packet;
            try {
                packet = SctpPacket.parseBytes(sctpBytes, 0, length);
            }
            catch (Exception exception1) {
                Log.error("Failed to parse SCTP packets.");
                return;
            }
            if (packet == null) {
                Log.warn("Could not parse SCTP packets.");
            } else if (!this.checkVerificationTag(packet)) {
                if (this._verboseLogging) {
                    Log.debug(StringExtensions.format("SCTP packet contains invalid verification tag. Dropping packet at {0}", LongExtensions.toString(Scheduler.getCurrentTime())));
                }
            } else {
                int sackCounter;
                int num6;
                Object[] unrecognizedChunksThatShouldBeReportedToSender;
                Object object;
                Object obj2;
                boolean flag = true;
                if (packet.getChunks() == null) {
                    flag = false;
                }
                int num3 = 0;
                int num4 = 0;
                boolean flag2 = false;
                long greatestCumulativeTsnReceived = this.__tcb.getGreatestCumulativeTsnReceived();
                boolean flag3 = false;
                for (int index = 0; index < ArrayExtensions.getLength(packet.getChunks()) && flag; ++index) {
                    SctpDataChunk chunk2;
                    Object chunk;
                    if (this._verboseLogging) {
                        chunk = packet.getChunks()[index];
                        if (((SctpChunk)chunk).getType() == SctpChunkType.getData()) {
                            chunk2 = (SctpDataChunk)chunk;
                            Log.debug(StringExtensions.format("SCTP packet received by manager contains chunk of type {1} with TSN {2}, SSN {3} on the Sctp Stream {4} at {0}.", new Object[]{LongExtensions.toString(Scheduler.getCurrentTime()), IntegerExtensions.toString(chunk2.getType()), LongExtensions.toString(chunk2.getTsn()), IntegerExtensions.toString(chunk2.getStreamSequenceNumber()), IntegerExtensions.toString(chunk2.getStreamIdentifier())}));
                        } else {
                            Log.debug(StringExtensions.format("SCTP packet received by manager contains chunk of type {1}.", LongExtensions.toString(Scheduler.getCurrentTime()), IntegerExtensions.toString(((SctpChunk)chunk).getType())));
                        }
                    }
                    if (packet.getChunks()[index].getType() == SctpChunkType.getInitiation()) {
                        chunk = obj2 = this.__stateLock;
                        synchronized (chunk) {
                            if ((Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.ClosedNeverOpened) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieWait) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed)) && index == 0) {
                                this.respondWithINIT_ACK((SctpInitChunk)packet.getChunks()[0]);
                            } else {
                                Log.debug("SCTP: Association not in CLOSED, COOKIE WAIT or COOKIE ECHOED state when INIT received or control chunk not the first in sequence. Stale packet?");
                            }
                        }
                        flag = false;
                        continue;
                    }
                    if (packet.getChunks()[index].getType() == SctpChunkType.getInitiationAck()) {
                        chunk = obj2 = this.__stateLock;
                        synchronized (chunk) {
                            if (Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieWait) && index == 0) {
                                this.respondWithCOOKIE_ECHO((SctpInitAckChunk)packet.getChunks()[0]);
                            } else {
                                Log.debug("SCTP: Association not in COOKIE_WAIT state when INIT_ACK received or control chunk not the first in sequence. Stale packet?");
                            }
                        }
                        flag = false;
                        continue;
                    }
                    if (packet.getChunks()[index].getType() == SctpChunkType.getCookieEcho()) {
                        chunk = obj2 = this.__stateLock;
                        synchronized (chunk) {
                            if ((Global.equals((Object)this.getState(), (Object)SctpTransportState.Connecting) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Established) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.ClosedNeverOpened)) && index == 0) {
                                boolean flag4 = this.respondWithCOOKIE_ACK((SctpCookieEchoChunk)packet.getChunks()[0], packet.getHeader());
                                greatestCumulativeTsnReceived = this.__tcb.getGreatestCumulativeTsnReceived();
                                if (!flag4) {
                                    flag = false;
                                }
                            } else {
                                flag = false;
                                Log.debug("SCTP: Cookie received in state other than CLOSED or control chunk not the first in sequence. Stale packet?");
                            }
                            continue;
                        }
                    }
                    if (packet.getChunks()[index].getType() == SctpChunkType.getCookieAck()) {
                        chunk = obj2 = this.__stateLock;
                        synchronized (chunk) {
                            if (Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed) && index == 0) {
                                this.set_InnerState(SctpTcbState.Established);
                                if (this.__errorToCombineWithCookieEcho != null) {
                                    this.__sendControlChunkQueue.enqueue(this.__errorToCombineWithCookieEcho);
                                    this.__errorToCombineWithCookieEcho = null;
                                    this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
                                }
                            } else if (!Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed)) {
                                flag = true;
                                Log.debug("SCTP: Cookie_ACK received in state other than SCTPStates.COOKIE_ECHOED. Ignoring the Cookie_ACK chunk. If there are other chunks in the packet, they will be examined.");
                            } else {
                                flag = true;
                                Log.debug("SCTP: Cookie_ACK control chunk not the first in packet sequence. Droping packet.");
                            }
                            continue;
                        }
                    }
                    if (packet.getChunks()[index].getType() == SctpChunkType.getData()) {
                        if (!Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Established) && !Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Closing) && !Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed)) continue;
                        this.__tcb.setRemoteLikelyInConnectedState(true);
                        ++num3;
                        chunk2 = (SctpDataChunk)packet.getChunks()[index];
                        flag3 |= chunk2.getSackImmediately();
                        if (SctpDataChunk.compareTsns(chunk2.getTsn(), this.__tcb.getGreatestReceivedTsn()) == 1) {
                            this.__tcb.setGreatestReceivedTsn(chunk2.getTsn());
                        }
                        if (SctpDataChunk.compareTsns(chunk2.getTsn(), this.__tcb.getGreatestCumulativeTsnReceived()) != 1 || this.__receiveDATAQueue.chunkExists(chunk2.getTsn())) continue;
                        ++num4;
                        this.__receiveDATAQueue.add(chunk2);
                        continue;
                    }
                    if (packet.getChunks()[index].getType() == SctpChunkType.getSack()) {
                        if (Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Established) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Closing) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed)) {
                            this.__tcb.setRemoteLikelyInConnectedState(true);
                            if (this.__tcb.getFreshestReceivedSack() != null && SctpDataChunk.compareTsns(((SctpSackChunk)packet.getChunks()[index]).getCumulativeTsnAck(), this.__tcb.getFreshestReceivedSack().getCumulativeTsnAck()) >= 2) continue;
                            if (this._verboseLogging) {
                                if (this.__tcb.getFreshestReceivedSack() != null) {
                                    Log.debug(StringExtensions.format("New SACK received with the cumulative TSN ACK of {1}, while association's cumulative ACK is {2} at {0}", LongExtensions.toString(Scheduler.getCurrentTime()), LongExtensions.toString(((SctpSackChunk)packet.getChunks()[index]).getCumulativeTsnAck()), LongExtensions.toString(this.__tcb.getFreshestReceivedSack().getCumulativeTsnAck())));
                                } else {
                                    Log.debug(StringExtensions.format("New SACK received with the cumulative TSN ACK of {1} at {0}", LongExtensions.toString(Scheduler.getCurrentTime()), LongExtensions.toString(((SctpSackChunk)packet.getChunks()[index]).getCumulativeTsnAck())));
                                }
                            }
                            this.__tcb.setFreshestReceivedSack((SctpSackChunk)packet.getChunks()[index]);
                            flag2 = true;
                            continue;
                        }
                        if (!Global.equals((Object)this.__tcb.getState(), (Object)SctpTcbState.Closed)) continue;
                        continue;
                    }
                    if (packet.getChunks()[index].getType() == SctpChunkType.getHeartbeat()) {
                        if (Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Established) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Closing) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed)) {
                            try {
                                SctpHeartbeatAckChunk controlChunk;
                                SctpHeartbeatChunk chunk3 = (SctpHeartbeatChunk)packet.getChunks()[index];
                                if (this._verboseLogging) {
                                    Log.debug(StringExtensions.format("SCTP: Received a heartbeat. Sending HEARTBEAT_ACK at {0}.", LongExtensions.toString(Scheduler.getCurrentTime())));
                                }
                                if ((controlChunk = new SctpHeartbeatAckChunk(chunk3.getHeartbeatInfo())) == null) continue;
                                object = obj2 = this.__stateLock;
                                synchronized (object) {
                                    this.__sendControlChunkQueue.enqueue(controlChunk);
                                    this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
                                }
                            }
                            catch (Exception exception2) {
                                Log.debug("Failure to process incoming SCTP Heartbeats.");
                            }
                            continue;
                        }
                        if (!this._verboseLogging) continue;
                        Log.debug(StringExtensions.format("SCTP: Received a heartbeat; discarding it because the association is in state {1} at {0}.", LongExtensions.toString(Scheduler.getCurrentTime()), this.get_InnerState().toString()));
                        continue;
                    }
                    if (packet.getChunks()[index].getType() == SctpChunkType.getHeartbeatAck()) {
                        if (!this._verboseLogging) continue;
                        Log.debug(StringExtensions.format("SCTP: Received a heartbeat ack at {0}.", LongExtensions.toString(Scheduler.getCurrentTime())));
                        continue;
                    }
                    if (packet.getChunks()[index].getType() != SctpChunkType.getAbort()) continue;
                    if (this._verboseLogging) {
                        SctpAbortChunk chunk5 = (SctpAbortChunk)packet.getChunks()[index];
                        if (chunk5.getErrorCauses() != null) {
                            int num22 = ArrayExtensions.getLength(chunk5.getErrorCauses());
                            Log.debug(StringExtensions.format("SCTP:  Received ABORT from another peer containing {1} error causes at {0}.", LongExtensions.toString(Scheduler.getCurrentTime()), IntegerExtensions.toString(num22)));
                            continue;
                        }
                        Log.debug(StringExtensions.format("SCTP:  Received ABORT from another peer containing no error causes at {0}.", LongExtensions.toString(Scheduler.getCurrentTime())));
                        continue;
                    }
                    Log.debug("SCTP: Received ABORT from another peer.");
                }
                if (packet.getUnrecognizedChunksThatShouldBeReportedToSender() != null && ArrayExtensions.getLength(unrecognizedChunksThatShouldBeReportedToSender = packet.getUnrecognizedChunksThatShouldBeReportedToSender()) > 0) {
                    if (this._verboseLogging) {
                        Log.debug(StringExtensions.format("SCTP: Reporting unrecognised chunks to the other peer at {0}.", LongExtensions.toString(Scheduler.getCurrentTime())));
                    }
                    SctpErrorCause[] errorCauses = new SctpUnrecognizedChunkType[ArrayExtensions.getLength(unrecognizedChunksThatShouldBeReportedToSender)];
                    for (num6 = 0; num6 < ArrayExtensions.getLength(unrecognizedChunksThatShouldBeReportedToSender); ++num6) {
                        errorCauses[num6] = new SctpUnrecognizedChunkType((SctpChunk)unrecognizedChunksThatShouldBeReportedToSender[num6]);
                    }
                    SctpErrorChunk chunk6 = new SctpErrorChunk(errorCauses);
                    object = obj2 = this.__stateLock;
                    synchronized (object) {
                        this.__sendControlChunkQueue.enqueue(chunk6);
                        this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
                    }
                }
                if (num3 > 0 && this.__receiveDATAQueue.getCount() > 0) {
                    SctpDataChunk chunk7;
                    long earliestTSN = this.__receiveDATAQueue.getEarliestTSN();
                    if (SctpDataChunk.compareTsns(earliestTSN, SctpDataChunk.incrementTSN(greatestCumulativeTsnReceived)) == 1) {
                        earliestTSN = SctpDataChunk.incrementTSN(greatestCumulativeTsnReceived);
                    }
                    long greatestReceivedTsn = this.__tcb.getGreatestReceivedTsn();
                    int num9 = 0;
                    boolean rollover = false;
                    if (earliestTSN <= greatestReceivedTsn) {
                        num9 = (int)(greatestReceivedTsn - earliestTSN + 1L);
                    } else {
                        long num10 = greatestReceivedTsn + 2L;
                        long num11 = 0xFFFFFFFFL - earliestTSN;
                        num9 = sackCounter = (int)(num10 + num11);
                        rollover = true;
                    }
                    boolean[] flagArray = new boolean[num9];
                    for (long num13 : this.__receiveDATAQueue.getTsns()) {
                        if (!rollover) {
                            flagArray[(int)(num13 - earliestTSN)] = true;
                            continue;
                        }
                        if (num13 > greatestReceivedTsn) {
                            flagArray[(int)(num13 - earliestTSN)] = true;
                            continue;
                        }
                        long num14 = 1L + num13;
                        long num15 = 0xFFFFFFFFL - earliestTSN;
                        int num16 = (int)(num14 + num15);
                        flagArray[num16] = true;
                    }
                    int num17 = 0;
                    boolean flag6 = flagArray[0];
                    ArrayList<SctpSCTPGapAckBlock> list = new ArrayList<SctpSCTPGapAckBlock>();
                    SctpSCTPGapAckBlock item = null;
                    boolean flag7 = false;
                    boolean flag8 = false;
                    for (num6 = 0; num6 < ArrayExtensions.getLength(flagArray); ++num6) {
                        if (flag6) {
                            if (flagArray[num6]) {
                                ++num17;
                            } else {
                                flag6 = false;
                            }
                        } else if (flag7) {
                            if (!flagArray[num6]) {
                                item.setGapAckBlockEnd(num6 - num17);
                                list.add(item);
                                item = null;
                                flag7 = false;
                            }
                        } else if (flagArray[num6]) {
                            item = new SctpSCTPGapAckBlock(num6 - num17 + 1, num6 - num17 + 1);
                            flag7 = true;
                        }
                        if (flagArray[num6]) {
                            chunk7 = this.__receiveDATAQueue.getChunk(this.translateIndextoTSN(num6, rollover, earliestTSN));
                            if (chunk7.getRaised()) continue;
                            SctpStream stream = this.__tcb.getInboundStreams().getStream(chunk7.getStreamIdentifier());
                            if (flag8) {
                                if (chunk7.getBeginning()) {
                                    throw new RuntimeException(new Exception("SCTP: Encountered an unfinished message"));
                                }
                                if (!chunk7.getEnding()) continue;
                                if (chunk7.getUnordered()) {
                                    this.raiseReceivedMessage(chunk7.getTsn());
                                } else if (chunk7.getStreamSequenceNumber() == stream.getNextSsn()) {
                                    this.raiseReceivedMessage(chunk7.getTsn());
                                    stream.setNextSsn(SctpDataChunk.incrementSSN(stream.getNextSsn()));
                                }
                                flag8 = false;
                                continue;
                            }
                            if (!chunk7.getBeginning()) continue;
                            if (chunk7.getEnding()) {
                                if (chunk7.getUnordered()) {
                                    this.raiseReceivedMessage(chunk7.getTsn());
                                    continue;
                                }
                                if (chunk7.getStreamSequenceNumber() != stream.getNextSsn()) continue;
                                this.raiseReceivedMessage(chunk7.getTsn());
                                stream.setNextSsn(SctpDataChunk.incrementSSN(stream.getNextSsn()));
                                continue;
                            }
                            flag8 = true;
                            continue;
                        }
                        flag8 = false;
                    }
                    if (flag7) {
                        item.setGapAckBlockEnd(ArrayExtensions.getLength(flagArray) - num17);
                        list.add(item);
                    }
                    boolean flag9 = true;
                    int num18 = 0;
                    while (flag9) {
                        if (flagArray[num18]) {
                            chunk7 = this.__receiveDATAQueue.getChunk(this.translateIndextoTSN(num18, rollover, earliestTSN));
                            if (chunk7.getRaised()) {
                                this.__receiveDATAQueue.remove(chunk7.getTsn());
                                if (++num18 < ArrayExtensions.getLength(flagArray)) continue;
                                flag9 = false;
                                continue;
                            }
                            flag9 = false;
                            continue;
                        }
                        flag9 = false;
                    }
                    if (earliestTSN + (long)num17 - 1L > 0xFFFFFFFFL) {
                        this.__tcb.setGreatestCumulativeTsnReceived((long)num17 + 0xFFFFFFFFL - earliestTSN - 2L);
                    } else {
                        this.__tcb.setGreatestCumulativeTsnReceived(earliestTSN + (long)num17 - 1L);
                    }
                    SctpSCTPGapAckBlock[] gapAckBlocks = null;
                    if (list != null) {
                        gapAckBlocks = list.toArray(new SctpSCTPGapAckBlock[0]);
                    }
                    this.__tcb.setSackOnReceivedData(new SctpSackChunk(this.__tcb.getGreatestCumulativeTsnReceived(), 0xFFFFFFFFL, gapAckBlocks, null));
                }
                if (flag2 || num3 > 0) {
                    boolean flag10 = false;
                    Object object2 = obj2 = this.__stateLock;
                    synchronized (object2) {
                        int newDataPacketCountTrigger = this.getNewDataPacketCountTrigger();
                        if (num3 > 0) {
                            sackCounter = this.__tcb.getSackCounter();
                            this.__tcb.setSackCounter(sackCounter + 1);
                            if ((float)(num4 / num3) < 0.4f) {
                                this.__tcb.setEarliestAllowedSackSendTime(Scheduler.getCurrentTime());
                                flag10 = true;
                                if (this._verboseLogging) {
                                    Log.debug("Latest SCTP Packet contained too many retransmitted chunks. Sending SACK immediately.");
                                }
                            }
                        }
                        if (flag2) {
                            flag10 = true;
                            this.__tcb.setProcessIncomingSack(true);
                        } else {
                            this.__tcb.setProcessIncomingSack(false);
                        }
                        if (flag3 || this.__tcb.getSackCounter() >= newDataPacketCountTrigger) {
                            if (this._verboseLogging) {
                                if (flag3) {
                                    Log.debug("One of received DATA chunks contained SACK-Immediately bit set. Will transmit SACK immediately.");
                                } else {
                                    Log.debug("SACK counter exceeded. Will transmit SACK now.");
                                }
                            }
                            this.__tcb.setEarliestAllowedSackSendTime(Scheduler.getCurrentTime());
                            flag10 = true;
                        } else if (this.__tcb.getSackCounter() < newDataPacketCountTrigger && num3 > 0) {
                            if (this.__tcb.getEarliestAllowedSackSendTime() == (long)ScheduledItem.getUnset()) {
                                this.__tcb.setEarliestAllowedSackSendTime(500L + Scheduler.getCurrentTime());
                                if (!this.__scheduler.itemIsScheduled(this.__outgoingQueueScheduledItem)) {
                                    int num20 = 500;
                                    if (this._verboseLogging) {
                                        Log.debug(StringExtensions.format("Starting countdown to sending new data. Scheduling outgoing queue processing in {0}", IntegerExtensions.toString(num20)));
                                    }
                                    this.__outgoingQueueScheduledItem.setDelay(num20);
                                    this.__scheduler.add(this.__outgoingQueueScheduledItem);
                                }
                            } else if (this.__tcb.getEarliestAllowedSackSendTime() < Scheduler.getCurrentTime()) {
                                flag10 = true;
                            }
                        }
                        if (flag10) {
                            this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOutgoingQueueLoop(ScheduledItem item) {
        block65: {
            this.__scheduler.remove(item);
            ArrayList<SctpPacket> list = new ArrayList<SctpPacket>();
            ArrayList<SctpDataChunk> list2 = new ArrayList<SctpDataChunk>();
            try {
                long currentTime;
                Object obj2;
                Object object = obj2 = this.__stateLock;
                synchronized (object) {
                    boolean flag7;
                    boolean flag2;
                    SctpDataChunk firstUnAcked;
                    currentTime = Scheduler.getCurrentTime();
                    boolean flag = false;
                    this.__tcb.setCongestionWindow(0L);
                    if (this.__tcb.getFreshestReceivedSack() != null && this.__tcb.getProcessIncomingSack()) {
                        int num3;
                        this.__tcb.setProcessIncomingSack(false);
                        flag = true;
                        SctpSackChunk freshestReceivedSack = this.__tcb.getFreshestReceivedSack();
                        long cumulativeTsnAck = freshestReceivedSack.getCumulativeTsnAck();
                        Object[] gapAckBlocks = freshestReceivedSack.getGapAckBlocks();
                        int n = num3 = gapAckBlocks == null ? 0 : ArrayExtensions.getLength(gapAckBlocks);
                        if (this.__sendDATAQueue.getCount() > 0) {
                            SctpDataChunk nextChunk;
                            long allAckedUpTo = this.__sendDATAQueue.getAllAckedUpTo();
                            if (SctpDataChunk.compareTsns(allAckedUpTo, cumulativeTsnAck) == 2) {
                                long tsn;
                                nextChunk = this.__sendDATAQueue.getNextChunk(allAckedUpTo);
                                long l = tsn = nextChunk == null ? -1L : nextChunk.getTsn();
                                while (nextChunk != null && SctpDataChunk.compareTsns(nextChunk.getTsn(), cumulativeTsnAck) != 1) {
                                    nextChunk.setAcked(true);
                                    tsn = nextChunk.getTsn();
                                    if (nextChunk.getEnding()) {
                                        list2.add(nextChunk);
                                        this.__sendDATAQueue.purge(tsn);
                                    }
                                    nextChunk = this.__sendDATAQueue.getNextChunk(tsn);
                                }
                                if (this.__sendDATAQueue.getCount() > 0) {
                                    this.__sendDATAQueue.setAllAckedUpTo(tsn);
                                }
                            } else if (SctpDataChunk.compareTsns(allAckedUpTo, cumulativeTsnAck) == 1) {
                                nextChunk = this.__sendDATAQueue.getNextChunk(cumulativeTsnAck);
                                if (nextChunk == null) {
                                    this.__sendDATAQueue.setAllAckedUpTo(-1L);
                                } else {
                                    long num6;
                                    SctpDataChunk previousChunk = this.__sendDATAQueue.getPreviousChunk(nextChunk.getTsn());
                                    long l = num6 = previousChunk == null ? -1L : previousChunk.getTsn();
                                    while (nextChunk != null && SctpDataChunk.compareTsns(nextChunk.getTsn(), allAckedUpTo) != 1) {
                                        nextChunk.setAcked(false);
                                        nextChunk = this.__sendDATAQueue.getNextChunk(nextChunk.getTsn());
                                    }
                                    this.__sendDATAQueue.setAllAckedUpTo(num6);
                                }
                            }
                            firstUnAcked = this.__sendDATAQueue.getFirstUnAcked();
                            long tsnB = this.__sendDATAQueue.getAllAckedUpTo() == -1L ? 0L : this.__sendDATAQueue.getAllAckedUpTo();
                            int num8 = 1;
                            for (int i = 0; i < num3; ++i) {
                                if (SctpDataChunk.compareTsns(((SctpSCTPGapAckBlock)gapAckBlocks[i]).getGapAckBlockStart(), num8) == 1) {
                                    flag2 = false;
                                    while (firstUnAcked != null && !flag2) {
                                        if (SctpDataChunk.compareTsns(SctpDataChunk.subtractTSN(firstUnAcked.getTsn(), tsnB), ((SctpSCTPGapAckBlock)gapAckBlocks[i]).getGapAckBlockStart()) == 2) {
                                            flag = false;
                                            firstUnAcked.setAcked(false);
                                            if (firstUnAcked.getTransmissionTime() > 0L) {
                                                this.__tcb.setCongestionWindow(this.__tcb.getCongestionWindow() + 1L);
                                            } else {
                                                this.__newDATAAvailable = true;
                                            }
                                            firstUnAcked = this.__sendDATAQueue.getNextChunk(firstUnAcked.getTsn());
                                            continue;
                                        }
                                        flag2 = true;
                                    }
                                } else {
                                    Log.error(StringExtensions.format("SCTP: incoming SACK from another party is malformed. Inappropreate GapAck block indexing.", new Object[0]));
                                }
                                boolean flag3 = false;
                                long num10 = -1L;
                                ArrayList<Long> list3 = new ArrayList<Long>();
                                if (((SctpSCTPGapAckBlock)gapAckBlocks[i]).getGapAckBlockEnd() - ((SctpSCTPGapAckBlock)gapAckBlocks[i]).getGapAckBlockStart() >= 0) {
                                    flag2 = false;
                                    while (firstUnAcked != null && !flag2) {
                                        if (SctpDataChunk.compareTsns(SctpDataChunk.subtractTSN(firstUnAcked.getTsn(), tsnB), ((SctpSCTPGapAckBlock)gapAckBlocks[i]).getGapAckBlockEnd()) != 1) {
                                            firstUnAcked.setAcked(true);
                                            if (firstUnAcked.getUnordered()) {
                                                if (firstUnAcked.getBeginning() && firstUnAcked.getEnding()) {
                                                    list2.add(firstUnAcked);
                                                    this.__sendDATAQueue.remove(firstUnAcked.getTsn());
                                                } else if (firstUnAcked.getBeginning()) {
                                                    flag3 = true;
                                                    list3.add(firstUnAcked.getTsn());
                                                    num10 = SctpDataChunk.incrementTSN(firstUnAcked.getTsn());
                                                } else if (firstUnAcked.getEnding()) {
                                                    if (flag3 && firstUnAcked.getTsn() == num10) {
                                                        list2.add(firstUnAcked);
                                                        list3.add(firstUnAcked.getTsn());
                                                        flag3 = false;
                                                        Iterator iterator = list3.iterator();
                                                        while (iterator.hasNext()) {
                                                            long num11 = (Long)iterator.next();
                                                            this.__sendDATAQueue.remove(num11);
                                                        }
                                                        list3.clear();
                                                    }
                                                } else if (flag3 && firstUnAcked.getTsn() == num10) {
                                                    num10 = SctpDataChunk.incrementTSN(firstUnAcked.getTsn());
                                                }
                                            }
                                            firstUnAcked = this.__sendDATAQueue.getNextChunk(firstUnAcked.getTsn());
                                            continue;
                                        }
                                        flag2 = true;
                                    }
                                } else {
                                    Log.error(StringExtensions.format("SCTP: incoming SACK from another party is malformed. Inappropreate GapAck block indexing.", new Object[0]));
                                }
                                num8 = ((SctpSCTPGapAckBlock)gapAckBlocks[i]).getGapAckBlockEnd() + 1;
                            }
                            if (firstUnAcked == null) {
                                this.__sendDATAQueue.setNotAckedPast(-1L);
                            } else if (SctpDataChunk.compareTsns(this.__sendDATAQueue.getNotAckedPast(), firstUnAcked.getTsn()) == 1) {
                                long notAckedPast = this.__sendDATAQueue.getNotAckedPast();
                                long num13 = firstUnAcked.getTsn();
                                this.__sendDATAQueue.setNotAckedPast(num13);
                                flag2 = false;
                                while (firstUnAcked != null && !flag2) {
                                    flag = false;
                                    firstUnAcked.setAcked(false);
                                    if (firstUnAcked.getTransmissionTime() > 0L) {
                                        this.__tcb.setCongestionWindow(this.__tcb.getCongestionWindow() + 1L);
                                    } else {
                                        this.__newDATAAvailable = true;
                                    }
                                    if ((firstUnAcked = this.__sendDATAQueue.getNextChunk(firstUnAcked.getTsn())) == null || SctpDataChunk.compareTsns(firstUnAcked.getTsn(), notAckedPast) >= 2) continue;
                                    flag2 = true;
                                }
                            } else if (SctpDataChunk.compareTsns(this.__sendDATAQueue.getNotAckedPast(), firstUnAcked.getTsn()) == 2) {
                                this.__sendDATAQueue.setNotAckedPast(firstUnAcked.getTsn());
                            }
                            boolean flag4 = false;
                            while (firstUnAcked != null && !flag4) {
                                if (firstUnAcked.getTransmissionTime() > 0L) {
                                    this.__tcb.setCongestionWindow(this.__tcb.getCongestionWindow() + 1L);
                                    firstUnAcked = this.__sendDATAQueue.getNextChunk(firstUnAcked.getTsn());
                                    continue;
                                }
                                this.__newDATAAvailable = true;
                                flag4 = true;
                            }
                        }
                    } else {
                        firstUnAcked = this.__sendDATAQueue.getFirstUnAcked();
                        flag2 = false;
                        while (firstUnAcked != null && !flag2) {
                            if (!firstUnAcked.getAcked() && firstUnAcked.getTransmissionTime() > 0L) {
                                this.__tcb.setCongestionWindow(this.__tcb.getCongestionWindow() + 1L);
                            } else if (!firstUnAcked.getAcked() && firstUnAcked.getTransmissionTime() <= 0L) {
                                this.__newDATAAvailable = true;
                                flag2 = true;
                            }
                            firstUnAcked = this.__sendDATAQueue.getNextChunk(firstUnAcked.getTsn());
                        }
                    }
                    this.__dataRetransmission = this.__tcb.getEarliestAllowedRetransmissionTime() != -1L && this.__tcb.getEarliestAllowedRetransmissionTime() < currentTime;
                    boolean flag5 = this.__newDATAAvailable && this.__tcb.getCongestionWindow() <= this.__tcb.getMaximumStaticCongestionWindow() || !flag && this.__dataRetransmission && this.__sendDATAQueue.getCount() > 0;
                    boolean requestSACKImmediately = (float)this.__tcb.getCongestionWindow() >= (float)this.__tcb.getMaximumStaticCongestionWindow() * 0.9f;
                    boolean bl = flag7 = this.__sendControlChunkQueue.getCount() > 0 || flag5 || this.__tcb.getEarliestAllowedSackSendTime() != (long)ScheduledItem.getUnset() && this.__tcb.getEarliestAllowedSackSendTime() < currentTime && this.__tcb.getSackCounter() > 0;
                    if (flag5 && this.__tcb.getEarliestAllowedRetransmissionTime() < currentTime) {
                        this.__tcb.setEarliestAllowedRetransmissionTime(currentTime + (long)this.getT3TimerExtension());
                    }
                    if (this.__sendDATAQueue.getCount() > 0) {
                        this.__nextDataChunkToBeExaminedForSending = this.__sendDATAQueue.getFirstUnAcked();
                    }
                    SctpPacket packet = null;
                    while (flag7) {
                        Holder<Object> _var0 = new Holder<Object>(packet);
                        boolean _var1 = this.buildSCTPPacket(_var0, requestSACKImmediately);
                        packet = _var0.getValue();
                        flag7 = _var1;
                        if (packet == null) continue;
                        list.add(packet);
                    }
                }
                for (SctpPacket packet : list) {
                    if (this.__numberOfPacketsSentSinceLastProcessorYield >= 0) {
                        ManagedThread.sleep(1);
                        this.__numberOfPacketsSentSinceLastProcessorYield = 0;
                    } else {
                        ++this.__numberOfPacketsSentSinceLastProcessorYield;
                    }
                    this.dispatch(DataBuffer.wrap(packet.getBytes()));
                }
                for (SctpDataChunk chunk2 : list2) {
                    SctpMessage message = chunk2.getMessage();
                    if (message == null) continue;
                    message.raiseSuccess();
                }
                list2.clear();
                list.clear();
                object = obj2 = this.__stateLock;
                synchronized (object) {
                    currentTime = Scheduler.getCurrentTime();
                    int unset = ScheduledItem.getUnset();
                    if (this.__sendDATAQueue.getCount() > 0) {
                        unset = (int)MathAssistant.max(this.__tcb.getEarliestAllowedRetransmissionTime() - currentTime, 0L);
                    }
                    if (this.__tcb.getSackCounter() > 0 && this.__tcb.getEarliestAllowedSackSendTime() != (long)ScheduledItem.getUnset()) {
                        int num15 = (int)MathAssistant.max(this.__tcb.getEarliestAllowedSackSendTime() - currentTime, 0L);
                        unset = unset > ScheduledItem.getUnset() ? MathAssistant.min(unset, num15) : num15;
                    }
                    if (unset > ScheduledItem.getUnset()) {
                        this.__outgoingQueueScheduledItem.setDelay(unset);
                        this.__scheduler.add(this.__outgoingQueueScheduledItem);
                    }
                }
            }
            catch (Exception exception) {
                if (!this.get_Active() && !Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.ClosedNeverOpened)) break block65;
                Log.error("Could not process outgoing SCTP queue.", exception);
            }
        }
    }

    private void raiseReceivedMessage(long tsn) {
        long[] tsnArray = new long[]{};
        byte[] buffer = new byte[]{};
        Holder<byte[]> _var0 = new Holder<byte[]>(buffer);
        Holder<long[]> _var1 = new Holder<long[]>(tsnArray);
        this.assembleMessage(_var0, _var1, tsn);
        buffer = _var0.getValue();
        tsnArray = _var1.getValue();
        IAction1<SctpMessage> onMessage = this.getOnMessage();
        if (onMessage != null) {
            SctpMessage p = new SctpMessage(DataBuffer.wrap(buffer), this.__receiveDATAQueue.getChunk(tsn).getStreamIdentifier());
            p.setPayloadType(this.__receiveDATAQueue.getChunk(tsn).getPayloadProtocolIdentifier());
            p.setUnordered(this.__receiveDATAQueue.getChunk(tsn).getUnordered());
            onMessage.invoke(p);
        }
        for (int i = 0; i < ArrayExtensions.getLength(tsnArray); ++i) {
            this.__receiveDATAQueue.getChunk(tsnArray[i]).setRaised(true);
        }
    }

    public void removeOnStateChange(IAction1<SctpTransport> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onStateChange.remove(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resendPacket(ScheduledItem item) {
        SctpResendArgs args = (SctpResendArgs)item.getState();
        SctpTcbState state = args.getState();
        DataBuffer packetBytes = args.getPacketBytes();
        Object object = this.__stateLock;
        synchronized (object) {
            if (Global.equals((Object)state, (Object)this.get_InnerState())) {
                if (this._verboseLogging) {
                    Log.debug(StringExtensions.format("SCTP is retransmitting a control chunk {0} at {1}.", ByteExtensions.toString(args.getType()), LongExtensions.toString(Scheduler.getCurrentTime())));
                }
                this.dispatch(packetBytes);
            } else {
                this.__scheduler.remove(item);
            }
        }
    }

    private boolean respondWithCOOKIE_ACK(SctpCookieEchoChunk incomingCOOKIEECHOChunk, SctpCommonHeader header) {
        int offsetPlus = 0;
        if (this.__tcb.getSecretKeyForCookie() == null) {
            Log.error("SCTP: missing secret key to extract cookie.");
            return false;
        }
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        SctpStateCookie _var1 = SctpStateCookie.parseBytes(incomingCOOKIEECHOChunk.getCookieBytes(), _var0, this.__tcb.getSecretKeyForCookie());
        offsetPlus = _var0.getValue();
        SctpStateCookie cookie = _var1;
        if (cookie == null) {
            Log.error("SCTP: Could not extract cookie.");
            return false;
        }
        SctpTransmissionControlBlock tcb = new SctpTransmissionControlBlock(cookie);
        if (Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.ClosedNeverOpened)) {
            if (header.getVerificationTag() == tcb.getMyVerificationTag()) {
                if (cookie.getTimestamp() + 12000L >= Scheduler.getCurrentTime()) {
                    if (this._verboseLogging) {
                        Log.debug(StringExtensions.format("SCTP: Received a valid COOKIE_ECHO at {0}.", LongExtensions.toString(Scheduler.getCurrentTime())));
                    } else {
                        Log.debug("SCTP: Received a valid COOKIE_ECHO.");
                    }
                    this.__tcb.importTcbParameters(tcb);
                    this.set_InnerState(SctpTcbState.Established);
                    if (this._verboseLogging) {
                        Log.debug(StringExtensions.format("SCTP: Sending COOKIE_ACK at {0}.", LongExtensions.toString(Scheduler.getCurrentTime())));
                    } else {
                        Log.debug("SCTP: Sending COOKIE_ACK.");
                    }
                    SctpCookieAckChunk chunk = new SctpCookieAckChunk();
                    this.__sendControlChunkQueue.enqueue(chunk);
                    this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
                    return true;
                }
                SctpStaleCookieError error = new SctpStaleCookieError(new NullableLong(cookie.getTimestamp() + 12000L - Scheduler.getCurrentTime()));
                SctpErrorChunk controlChunk = new SctpErrorChunk(new SctpErrorCause[]{error});
                this.__sendControlChunkQueue.enqueue(controlChunk);
                Log.debug("SCTP: Stale cookie at initiation stage.");
                this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
            }
            return false;
        }
        if (!Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed) && !Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Established)) {
            return false;
        }
        if (cookie.getTimestamp() + 12000L < Scheduler.getCurrentTime()) {
            return false;
        }
        if (this.__tcb.getMyVerificationTag() != tcb.getMyVerificationTag()) {
            return false;
        }
        if (Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed)) {
            if (this._verboseLogging) {
                Log.debug(StringExtensions.format("SCTP: Received a valid COOKIE_ECHO in Cookie Echoed state at {0}.", LongExtensions.toString(Scheduler.getCurrentTime())));
            } else {
                Log.debug("SCTP: Received a valid COOKIE_ECHO in Cookie Echoed state.");
            }
            this.__tcb.importTcbParameters(tcb);
            this.set_InnerState(SctpTcbState.Established);
        } else {
            if (this.__tcb.getPeerVerificationTag() != tcb.getPeerVerificationTag()) {
                this.__tcb.setPeerVerificationTag(tcb.getPeerVerificationTag());
                Log.debug("SCTP: Updating peer verification tag from incoming Cookie.");
            }
            if (this._verboseLogging) {
                Log.debug(StringExtensions.format("SCTP: Received a valid duplicate COOKIE_ECHO. Re-sending COOKIE_ACK at {0}.", LongExtensions.toString(Scheduler.getCurrentTime())));
            } else {
                Log.debug("SCTP: Received a valid duplicate COOKIE_ECHO. Re-sending COOKIE_ACK.");
            }
        }
        if (this._verboseLogging) {
            Log.debug(StringExtensions.format("SCTP: sending COOKIE_ACK at {0}.", LongExtensions.toString(Scheduler.getCurrentTime())));
        } else {
            Log.debug("SCTP: sending COOKIE_ACK.");
        }
        SctpCookieAckChunk chunk = new SctpCookieAckChunk();
        this.__sendControlChunkQueue.enqueue(chunk);
        this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
        return true;
    }

    private void respondWithCOOKIE_ECHO(SctpInitAckChunk incomingINITACKChunk) {
        byte[] stateCookieBytes = incomingINITACKChunk.getStateCookieChunk().getStateCookieBytes();
        if (stateCookieBytes == null) {
            String str = "SCTP: init ack does not contain properly reflected cookie.";
            Log.error(str);
            Exception exception = new Exception(str);
            this.closeOnFailure(exception);
        } else {
            ScheduledItem item;
            SctpCookieEchoChunk controlChunk = new SctpCookieEchoChunk(stateCookieBytes);
            SctpResendArgs args2 = new SctpResendArgs(SctpTcbState.CookieEchoed);
            args2.setType(SctpChunkType.getCookieEcho());
            SctpResendArgs args = args2;
            ScheduledItem item2 = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                @Override
                public String getId() {
                    return "fm.icelink.SctpTransport.resendPacket";
                }

                @Override
                public void invoke(ScheduledItem item) {
                    SctpTransport.this.resendPacket(item);
                }
            }, 200, 200, 10000, ScheduledItem.getUnset());
            item2.setState(args);
            item2.setTimeoutCallback((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                @Override
                public String getId() {
                    return "fm.icelink.SctpTransport.initializationFailure";
                }

                @Override
                public void invoke(ScheduledItem item) {
                    SctpTransport.this.initializationFailure(item);
                }
            });
            this.__initiationControlChunkScheduledItem = item = item2;
            controlChunk.setResendScheduledItem(item);
            if (incomingINITACKChunk.getInitiateTag() == 0L) {
                String str = "SCTP: initiate tag is 0. Aborting association establishment.";
                Log.error(str);
                Exception exception = new Exception(str);
                this.closeOnFailure(exception);
            } else {
                this.__tcb.setPeerVerificationTag(incomingINITACKChunk.getInitiateTag());
                this.__tcb.setPeerReceiverWindowCredit(incomingINITACKChunk.getAdvertisedReceiverWindowCredit());
                int numberOfInboundStreams = incomingINITACKChunk.getNumberOfInboundStreams();
                if (numberOfInboundStreams < this.__tcb.getOutboundStreams().getCount()) {
                    this.__tcb.setOutboundStreams(new SctpStreams(numberOfInboundStreams));
                }
                if (this.__tcb.getOutboundStreams().getCount() == 0) {
                    String str = "SCTP: The number of outbound streams must be a positive value.";
                    Log.error(str);
                    Exception exception = new Exception(str);
                    this.closeOnFailure(exception);
                } else {
                    if (incomingINITACKChunk.getAuthenticatedChunksParameters() != null && incomingINITACKChunk.getAuthenticatedChunksParameters().getAuthenticatedChunksSupportedByThisEndpoint()) {
                        Log.debug("Remote party supports optional SCTP authenticated chunks feature, which is not yet supported by this party. Authenticated chunks feature will be disabled in this association");
                    }
                    if (incomingINITACKChunk.getPartialReliabilityParameters() != null && incomingINITACKChunk.getPartialReliabilityParameters().getPartialReliabilitySupportedByThisEndpoint()) {
                        Log.debug("Remote party supports optional SCTP partial reliability feature, which is not yet supported by this party. Partial reliability feature will be disabled in this association");
                    }
                    if (incomingINITACKChunk.getDynamicAddressReconfigurationParameters() != null && incomingINITACKChunk.getDynamicAddressReconfigurationParameters().getDynamicAddressReconfigurationSupportedByThisEndpoint()) {
                        Log.debug("Remote party supports optional SCTP address reconfiguration feature, which is not yet supported by this party. Address reconfiguration feature will be disabled in this association");
                    }
                    this.__tcb.setGreatestReceivedTsn(SctpDataChunk.decrementTSN(incomingINITACKChunk.getInitialTsn()));
                    this.__tcb.setGreatestCumulativeTsnReceived(this.__tcb.getGreatestReceivedTsn());
                    this.__tcb.setState(SctpTcbState.CookieEchoed);
                    if (this._verboseLogging) {
                        Log.debug(StringExtensions.format("SCTP: sending COOKIE_ECHO at {0} and moving into the COOKIE_ECHOED state.", LongExtensions.toString(Scheduler.getCurrentTime())));
                    } else {
                        Log.debug("SCTP: sending COOKIE_ECHO and moving into the COOKIE_ECHOED state.");
                    }
                    this.__sendControlChunkQueue.enqueue(controlChunk);
                    Object[] unrecognizedParametersThatNeedToBeReportedBackToSender = incomingINITACKChunk.getUnrecognizedParametersThatNeedToBeReportedBackToSender();
                    if (unrecognizedParametersThatNeedToBeReportedBackToSender != null && ArrayExtensions.getLength(unrecognizedParametersThatNeedToBeReportedBackToSender) > 0) {
                        SctpErrorChunk chunk2;
                        SctpUnrecognizedParameters parameters = new SctpUnrecognizedParameters((SctpTlvParameter[])unrecognizedParametersThatNeedToBeReportedBackToSender);
                        this.__errorToCombineWithCookieEcho = chunk2 = new SctpErrorChunk(new SctpErrorCause[]{parameters});
                    }
                    this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
                }
            }
        }
    }

    private void respondWithINIT_ACK(SctpInitChunk incomingINITChunk) {
        int count;
        long myVerificationTag = 0L;
        myVerificationTag = Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.ClosedNeverOpened) ? MathAssistant.max(1L, (long)(4.294967295E9 * LockedRandomizer.nextDouble())) : this.__tcb.getMyVerificationTag();
        long initiateTag = incomingINITChunk.getInitiateTag();
        if (this._verboseLogging) {
            Log.debug(StringExtensions.format("Local inititate/verification tag is set to {0}; remote initiate/verification tag is set to {1}.", LongExtensions.toString(myVerificationTag), LongExtensions.toString(initiateTag)));
        }
        long advertisedReceiverWindowCredit = incomingINITChunk.getAdvertisedReceiverWindowCredit();
        int numberOfInboundStreams = incomingINITChunk.getNumberOfInboundStreams();
        if (numberOfInboundStreams < (count = this.__tcb.getOutboundStreams().getCount())) {
            count = numberOfInboundStreams;
        }
        if (count == 0) {
            String str = "SCTP: The number of outbound channels must be a positive value.";
            Log.error(str);
            this.closeOnFailure(new Exception("SCTP: The number of outbound channels must be a positive value."));
        } else {
            long initialTsn = incomingINITChunk.getInitialTsn();
            if (incomingINITChunk.getAuthenticatedChunksParameters() != null && incomingINITChunk.getAuthenticatedChunksParameters().getAuthenticatedChunksSupportedByThisEndpoint()) {
                Log.debug("Remote party supports optional SCTP authenticated chunks feature, which is not yet supported by this party. Authenticated chunks feature will be disabled in this association");
            }
            if (incomingINITChunk.getPartialReliabilityParameters() != null && incomingINITChunk.getPartialReliabilityParameters().getPartialReliabilitySupportedByThisEndpoint()) {
                Log.debug("Remote party supports optional SCTP partial reliability feature, which is not yet supported by this party. Partial reliability feature will be disabled in this association");
            }
            if (incomingINITChunk.getDynamicAddressReconfigurationParameters() != null && incomingINITChunk.getDynamicAddressReconfigurationParameters().getDynamicAddressReconfigurationSupportedByThisEndpoint()) {
                Log.debug("Remote party supports optional SCTP address reconfiguration feature, which is not yet supported by this party. Address reconfiguration feature will be disabled in this association");
            }
            SctpUnrecognizedParameterChunkParameter unrecognizedParameter = null;
            if (incomingINITChunk.getUnrecognizedParametersThatNeedToBeReportedBackToSender() != null && ArrayExtensions.getLength(incomingINITChunk.getUnrecognizedParametersThatNeedToBeReportedBackToSender()) > 0) {
                unrecognizedParameter = new SctpUnrecognizedParameterChunkParameter(incomingINITChunk.getUnrecognizedParametersThatNeedToBeReportedBackToSender());
            }
            SctpTransmissionControlBlock block = new SctpTransmissionControlBlock(myVerificationTag, initiateTag, advertisedReceiverWindowCredit, SctpDataChunk.decrementTSN(initialTsn), count, this.__tcb.getSecretKeyForCookie());
            block.setDestinationPort(this.__tcb.getDestinationPort());
            block.setSourcePort(this.__tcb.getSourcePort());
            SctpStateCookie newCookie = block.getNewCookie();
            if (newCookie == null) {
                String str = "SCTP: could not prepare cookie. Shutting down.";
                Log.error(str);
                this.closeOnFailure(new Exception(str));
            } else {
                SctpStateCookieChunkParameter stateCookie = new SctpStateCookieChunkParameter(newCookie);
                SctpInitAckChunk controlChunk = new SctpInitAckChunk(myVerificationTag, advertisedReceiverWindowCredit, count, this.__tcb.getInboundStreams().getCount(), myVerificationTag, stateCookie, null, unrecognizedParameter);
                this.__sendControlChunkQueue.enqueue(controlChunk);
                String str2 = "CLOSED";
                if (Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieWait)) {
                    str2 = "COOKIE_WAIT";
                } else if (Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed)) {
                    str2 = "COOKIE_ECHOED";
                }
                if (this._verboseLogging) {
                    Log.debug(StringExtensions.format("SCTP: Responding with INIT_ACK at {0}. Remaining in {1} state.", LongExtensions.toString(Scheduler.getCurrentTime()), str2));
                } else {
                    Log.debug(StringExtensions.format("SCTP: Responding with INIT_ACK. Remaining in {0} state.", str2));
                }
                this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
            }
        }
    }

    public SctpTransport(Object lockObject, Scheduler scheduler, Transport innerTransport, int requestedOutboundStreams, int maxIncomingStreams, long advertisedReceiverWindow) {
        this(lockObject, scheduler, innerTransport, requestedOutboundStreams, maxIncomingStreams, advertisedReceiverWindow, 5000, 5000);
    }

    public SctpTransport(Object lockObject, Scheduler scheduler, Transport innerTransport, int requestedOutboundStreams, int maxIncomingStreams, long advertisedReceiverWindow, int sourcePort, int destinationPort) {
        int num2;
        int interval;
        this.__sendDATAQueue = new SctpDataQueue();
        this.__sendControlChunkQueue = new SctpSendControlChunkQueue();
        this.__receiveDATAQueue = new SctpDataQueue();
        this.__stateLock = lockObject;
        this.__scheduler = scheduler;
        this.setId(Guid.newGuid().toString().replace("-", ""));
        if (innerTransport == null) {
            Log.error("Null inner transport argument.");
        }
        if ((interval = 500) > (num2 = this.getT3TimerExtension())) {
            interval = num2;
        }
        this.__outgoingQueueScheduledItem = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

            @Override
            public String getId() {
                return "fm.icelink.SctpTransport.processOutgoingQueueLoop";
            }

            @Override
            public void invoke(ScheduledItem item) {
                SctpTransport.this.processOutgoingQueueLoop(item);
            }
        }, 0, interval, ScheduledItem.getUnset(), ScheduledItem.getUnset());
        this.__innerTransport = innerTransport;
        if (maxIncomingStreams < 1) {
            throw new RuntimeException(new Exception("SCTP: Maximum supported number of inbound channels must be at least 1"));
        }
        if (requestedOutboundStreams < 1) {
            throw new RuntimeException(new Exception("SCTP: Desirable number of outbound channels must be at least 1"));
        }
        SctpTransmissionControlBlock block = new SctpTransmissionControlBlock(requestedOutboundStreams, maxIncomingStreams, advertisedReceiverWindow);
        block.setMaximumStaticCongestionWindow(350L);
        this.__tcb = block;
        this.__tcb.setSourcePort(sourcePort);
        this.__tcb.setDestinationPort(destinationPort);
        this.__sendControlChunkQueue = new SctpSendControlChunkQueue();
        this.__sendDATAQueue = new SctpDataQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Error sendData(SctpMessage message) {
        if (message == null || message.getPayload() == null || message.getPayload().getLength() == 0) {
            Error error = new Error(ErrorCode.SctpNoPayloadData);
            error.setException(new Exception("SCTP payload cannot be null or empty."));
            return error;
        }
        byte[] buffer = message.getPayload().toArray();
        boolean unordered = message.getUnordered();
        int streamId = message.getStreamId();
        long payloadType = message.getPayloadType();
        Object object = this.__stateLock;
        synchronized (object) {
            SctpStream stream;
            if (streamId > this.__tcb.getOutboundStreams().getCount() - 1) {
                Error error2 = new Error(ErrorCode.SctpUnsupportedStream);
                error2.setException(new Exception(StringExtensions.format("SCTP: Communication on an unsupported SCTP stream {0}.", IntegerExtensions.toString(streamId))));
                return error2;
            }
            if (!Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Established)) {
                Error error3 = new Error(ErrorCode.SctpInvalidState);
                error3.setException(new Exception(StringExtensions.format("SCTP: Communication is only allowed in the Established state. Sctp transport is in {0} state.", this.getState().toString())));
                return error3;
            }
            ByteCollection bytes = new ByteCollection(buffer);
            if (bytes.getCount() > 16384) {
                Log.warn("Sending messages in excess of 16 KB over connections managed by SCTP may have adverse consequences. Consider partitioning longer messages into smaller chunks and sending these chunks separately.");
            }
            boolean beginning = true;
            boolean ending = false;
            int index = 0;
            int count = MathAssistant.min(bytes.getCount(), 950);
            while (!ending) {
                if (count == bytes.getCount() - index) {
                    ending = true;
                }
                if (this._verboseLogging) {
                    Log.debug(StringExtensions.format("Adding a new DATA chunk with TSN {0} to the outgoing queue at {1}.", new String[]{LongExtensions.toString(this.__tcb.getNextTsnToSend()), LongExtensions.toString(Scheduler.getCurrentTime())}));
                }
                stream = this.__tcb.getOutboundStreams().getStream(streamId);
                SctpDataChunk dataChunk = new SctpDataChunk(unordered, beginning, ending, this.__tcb.getNextTsnToSend(), streamId, stream.getNextSsn(), payloadType, bytes.getRange(index, count), ending);
                dataChunk.setMessage(message);
                dataChunk.setAcked(false);
                beginning = false;
                this.__sendDATAQueue.add(dataChunk);
                count = MathAssistant.min(bytes.getCount() - (index += count), 950);
                this.__tcb.setNextTsnToSend(SctpDataChunk.incrementTSN(this.__tcb.getNextTsnToSend()));
            }
            if (!unordered) {
                stream = this.__tcb.getOutboundStreams().getStream(streamId);
                stream.setNextSsn(SctpDataChunk.incrementSSN(stream.getNextSsn()));
            }
            this.__newDATAAvailable = true;
            this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set_InnerState(SctpTcbState value) {
        Object object = this.__stateLock;
        synchronized (object) {
            if (this.__tcb != null && !Global.equals((Object)value, (Object)this.__tcb.getState())) {
                this.__tcb.setState(value);
                if (this._verboseLogging) {
                    Log.debug(StringExtensions.format("SCTP: Moving into the {0} state at {1}.", value.toString(), LongExtensions.toString(Scheduler.getCurrentTime())));
                } else {
                    Log.debug(StringExtensions.format("SCTP: Moving into the {0} state.", value.toString()));
                }
                IAction1<SctpTransport> onStateChange = this._onStateChange;
                if (onStateChange != null) {
                    onStateChange.invoke(this);
                }
            }
        }
    }

    private void setError(Error value) {
        this._error = value;
    }

    private void setId(String value) {
        this._id = value;
    }

    public void setOnMessage(IAction1<SctpMessage> value) {
        this._onMessage = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.__stateLock;
        synchronized (object) {
            if (!this.get_Active()) {
                this.__scheduler.add(this.__outgoingQueueScheduledItem);
                this.__innerTransport.removeOnReceive((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.SctpTransport.processIncomingSctpPacket";
                    }

                    @Override
                    public void invoke(DataBuffer buffer) {
                        SctpTransport.this.processIncomingSctpPacket(buffer);
                    }
                });
                this.__innerTransport.addOnReceive((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.SctpTransport.processIncomingSctpPacket";
                    }

                    @Override
                    public void invoke(DataBuffer buffer) {
                        SctpTransport.this.processIncomingSctpPacket(buffer);
                    }
                });
                this.initiate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.__stateLock;
        synchronized (object) {
            if (!Global.equals((Object)this.getState(), (Object)SctpTransportState.Closed) && !Global.equals((Object)this.getState(), (Object)SctpTransportState.Closing)) {
                Log.debug("SCTP: Association shutdown");
                this.__innerTransport.removeOnReceive((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.SctpTransport.processIncomingSctpPacket";
                    }

                    @Override
                    public void invoke(DataBuffer buffer) {
                        SctpTransport.this.processIncomingSctpPacket(buffer);
                    }
                });
                this.set_InnerState(SctpTcbState.Closing);
                this.stopAllDataChunkTransmission();
                this.stopAllControlChunkTransmission();
                this.set_InnerState(SctpTcbState.Closed);
                this.__innerTransport = null;
            }
        }
    }

    private void stopAllControlChunkTransmission() {
        this.__sendControlChunkQueue.removeAll();
        if (this.__scheduler != null) {
            this.__scheduler.remove(this.__initiationControlChunkScheduledItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAllDataChunkTransmission() {
        Object object = this.__stateLock;
        synchronized (object) {
            long[] tsns;
            for (long num : tsns = this.__sendDATAQueue.getTsns()) {
                SctpMessage message;
                SctpDataChunk chunk = this.__sendDATAQueue.getChunk(num);
                if (!chunk.getEnding() || (message = chunk.getMessage()) == null) continue;
                message.raiseFailure(new Exception("SCTP: message delivery not acknowledged before shutdown."));
            }
            this.__sendDATAQueue.removeAll();
            if (this.__scheduler != null) {
                this.__scheduler.remove(this.__outgoingQueueScheduledItem);
            }
        }
        this.__tcb.resetAssociationState();
    }

    private long translateIndextoTSN(int index, boolean rollover, long start) {
        if (!rollover) {
            return start + (long)index;
        }
        if (start + (long)index <= 0xFFFFFFFFL) {
            return start + (long)index;
        }
        return (long)index + start - 0xFFFFFFFFL - 1L;
    }
}

