/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpChunk;
import fm.icelink.SctpStateCookie;
import fm.icelink.SctpTlvParameter;

class SctpStateCookieChunkParameter
extends SctpTlvParameter {
    private SctpStateCookie _stateCookie;
    private byte[] _stateCookieBytes;

    public static byte[] getBytes(SctpStateCookieChunkParameter parameter) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(7, false));
        byte[] buffer = parameter.getStateCookie() != null ? parameter.getStateCookie().getBytes() : parameter.getStateCookieBytes();
        bytes.addRange(Binary.toBytes16(4 + ArrayExtensions.getLength(buffer), false));
        bytes.addRange(buffer);
        SctpChunk.addPadding(bytes);
        return bytes.toArray();
    }

    @Override
    public byte[] getBytes() {
        return SctpStateCookieChunkParameter.getBytes(this);
    }

    public SctpStateCookie getStateCookie() {
        return this._stateCookie;
    }

    public byte[] getStateCookieBytes() {
        return this._stateCookieBytes;
    }

    public static SctpStateCookieChunkParameter parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int len = Binary.fromBytes16(bytes, 2, false);
            byte[] destination = new byte[len - 4];
            BitAssistant.copy(bytes, 4, destination, 0, ArrayExtensions.getLength(destination));
            offsetPlus.setValue(len + SctpChunk.calculatePaddingBytes(len));
            return new SctpStateCookieChunkParameter(destination);
        }
        catch (Exception exception1) {
            Log.debug("Could not read StateCookieChunkParameter.");
            offsetPlus.setValue(0);
            return null;
        }
    }

    public static SctpStateCookieChunkParameter parseBytes(byte[] value, int startIndex, IntegerHolder offsetPlus) {
        try {
            byte[] destination = new byte[ArrayExtensions.getLength(value) - startIndex];
            BitAssistant.copy(value, startIndex, destination, 0, ArrayExtensions.getLength(destination));
            SctpStateCookieChunkParameter _var0 = SctpStateCookieChunkParameter.parseBytes(destination, offsetPlus);
            return _var0;
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpStateCookieChunkParameter(SctpStateCookie stateCookie) {
        super.setType(7);
        this.setStateCookie(stateCookie);
    }

    public SctpStateCookieChunkParameter(byte[] stateCookieBytes) {
        super.setType(7);
        this.setStateCookieBytes(stateCookieBytes);
    }

    public void setStateCookie(SctpStateCookie value) {
        this._stateCookie = value;
    }

    public void setStateCookieBytes(byte[] value) {
        this._stateCookieBytes = value;
    }
}

