/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpChunk;
import fm.icelink.SctpTlvParameter;

class SctpRandomChunkParameter
extends SctpTlvParameter {
    private byte[] _randomNumber;

    @Override
    public byte[] getBytes() {
        return SctpRandomChunkParameter.getBytes(this);
    }

    public static byte[] getBytes(SctpRandomChunkParameter parameter) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(parameter.getType(), false));
        int num = ArrayExtensions.getLength(parameter.getRandomNumber()) + 4;
        bytes.addRange(Binary.toBytes16(num, false));
        bytes.addRange(parameter.getRandomNumber());
        SctpChunk.addPadding(bytes);
        return bytes.toArray();
    }

    public byte[] getRandomNumber() {
        return this._randomNumber;
    }

    public static SctpRandomChunkParameter parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int len = Binary.fromBytes16(bytes, 2, false);
            byte[] destination = new byte[len - 4];
            BitAssistant.copy(bytes, 4, destination, 0, ArrayExtensions.getLength(destination));
            int num2 = SctpChunk.calculatePaddingBytes(len);
            offsetPlus.setValue(len + num2);
            return new SctpRandomChunkParameter(destination);
        }
        catch (Exception exception1) {
            Log.debug("Could not read RandomChunkParameter.");
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpRandomChunkParameter(byte[] randomNumber) {
        super.setType(32770);
        this.setRandomNumber(randomNumber);
    }

    public void setRandomNumber(byte[] value) {
        this._randomNumber = value;
    }
}

