/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.Encoding;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpErrorCause;
import fm.icelink.StringExtensions;

class SctpProtocolViolation
extends SctpErrorCause {
    private byte[] _additionalInfo;

    public byte[] getAdditionalInfo() {
        return this._additionalInfo;
    }

    @Override
    public byte[] getBytes() {
        return SctpProtocolViolation.getBytes(this);
    }

    public static byte[] getBytes(SctpProtocolViolation cause) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(cause.getCauseCode(), false));
        if (cause.getAdditionalInfo() != null) {
            bytes.addRange(cause.getAdditionalInfo());
        }
        bytes.insertRange(2, Binary.toBytes16(bytes.getCount() + 2, false));
        return bytes.toArray();
    }

    public static SctpProtocolViolation parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int num = Binary.fromBytes16(bytes, 2, false);
            byte[] destination = null;
            String str = "";
            if (num > 4) {
                destination = new byte[num - 4];
                BitAssistant.copy(bytes, 4, destination, 0, ArrayExtensions.getLength(destination));
                try {
                    str = Encoding.getUtf8().getString(destination, 0, ArrayExtensions.getLength(destination));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Log.debug(StringExtensions.format("SCTP Error: SCTP protocol violation. {0}", str));
            offsetPlus.setValue(num);
            return new SctpProtocolViolation(destination);
        }
        catch (Exception exception2) {
            Log.warn("Could not parse ProtocolViolation");
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpProtocolViolation() {
        super.setCauseCode(13);
    }

    public SctpProtocolViolation(byte[] additionalInfo) {
        super.setCauseCode(13);
        this.setAdditionalInfo(additionalInfo);
    }

    public void setAdditionalInfo(byte[] value) {
        this._additionalInfo = value;
    }
}

