/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpChunk;
import fm.icelink.SctpErrorCause;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;

class SctpMissingMandatoryParameter
extends SctpErrorCause {
    private int[] _missingParameters;

    @Override
    public byte[] getBytes() {
        return SctpMissingMandatoryParameter.getBytes(this);
    }

    public static byte[] getBytes(SctpMissingMandatoryParameter cause) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(cause.getCauseCode(), false));
        int length = ArrayExtensions.getLength(cause.getMissingParameters());
        bytes.addRange(Binary.toBytes16(8 + 2 * length, false));
        bytes.addRange(Binary.toBytes32(length, false));
        for (int i = 0; i < length; ++i) {
            bytes.addRange(Binary.toBytes16(cause.getMissingParameters()[i], false));
        }
        SctpChunk.addPadding(bytes);
        return bytes.toArray();
    }

    public int[] getMissingParameters() {
        return this._missingParameters;
    }

    public static SctpMissingMandatoryParameter parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int num = (int)Binary.fromBytes32(bytes, 4, false);
            int[] missingParameters = new int[num];
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < num; ++i) {
                missingParameters[i] = Binary.fromBytes16(bytes, 8 + i * 2, false);
                StringBuilderExtensions.append(builder, IntegerExtensions.toString(missingParameters[i]));
                if (i >= num - 1) continue;
                StringBuilderExtensions.append(builder, ", ");
            }
            Log.debug(StringExtensions.concat("SCTP Error: missing mandatory parameters ", builder.toString()));
            int len = Binary.fromBytes16(bytes, 2, false);
            offsetPlus.setValue(len + SctpChunk.calculatePaddingBytes(len));
            return new SctpMissingMandatoryParameter(missingParameters);
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpMissingMandatoryParameter(int[] missingParameters) {
        super.setCauseCode(2);
        this.setMissingParameters(missingParameters);
    }

    public void setMissingParameters(int[] value) {
        this._missingParameters = value;
    }
}

