/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.ByteExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpAuthenticatedChunksParameters;
import fm.icelink.SctpChunkListChunkParameter;
import fm.icelink.SctpChunkType;
import fm.icelink.SctpControlChunk;
import fm.icelink.SctpDynamicAddressReconfigurationSupportParameters;
import fm.icelink.SctpGenericChunkParameter;
import fm.icelink.SctpHostNameAddressChunkParameter;
import fm.icelink.SctpIPv4ChunkParameter;
import fm.icelink.SctpPartialReliabilitySupportParameters;
import fm.icelink.SctpRandomChunkParameter;
import fm.icelink.SctpRequestedHmacAlgorithmChunkParameter;
import fm.icelink.SctpStateCookieChunkParameter;
import fm.icelink.SctpSupportedExtensionsChunkParameter;
import fm.icelink.SctpTlvParameter;
import fm.icelink.SctpUnrecognizedParameterChunkParameter;
import fm.icelink.StringExtensions;
import java.util.ArrayList;

class SctpInitAckChunk
extends SctpControlChunk {
    private long _advertisedReceiverWindowCredit;
    private SctpAuthenticatedChunksParameters _authenticatedChunksParameters;
    private SctpDynamicAddressReconfigurationSupportParameters _dynamicAddressReconfigurationParameters;
    private SctpHostNameAddressChunkParameter _hostNameAddress;
    private long _initialTsn;
    private long _initiateTag;
    private SctpIPv4ChunkParameter[] _ipv4Addresses;
    private int _numberOfInboundStreams;
    private int _numberOfOutboundStreams;
    private SctpPartialReliabilitySupportParameters _partialReliabilityParameters;
    private SctpStateCookieChunkParameter _stateCookieChunk;
    private byte[] _supportedExtensionsChunks;
    private SctpUnrecognizedParameterChunkParameter _unrecognizedParameter;
    private SctpGenericChunkParameter[] _unrecognizedParametersThatNeedToBeReportedBackToSender;

    public long getAdvertisedReceiverWindowCredit() {
        return this._advertisedReceiverWindowCredit;
    }

    public SctpAuthenticatedChunksParameters getAuthenticatedChunksParameters() {
        return this._authenticatedChunksParameters;
    }

    @Override
    public byte[] getBytes() {
        return SctpInitAckChunk.getBytes(this);
    }

    public static byte[] getBytes(SctpInitAckChunk chunk) {
        ByteCollection bytes = new ByteCollection();
        bytes.add((byte)chunk.getType());
        bytes.add((byte)0);
        bytes.addRange(Binary.toBytes32(chunk.getInitiateTag(), false));
        bytes.addRange(Binary.toBytes32(chunk.getAdvertisedReceiverWindowCredit(), false));
        bytes.addRange(Binary.toBytes16(chunk.getNumberOfOutboundStreams(), false));
        bytes.addRange(Binary.toBytes16(chunk.getNumberOfInboundStreams(), false));
        bytes.addRange(Binary.toBytes32(chunk.getInitialTsn(), false));
        bytes.addRange(chunk.getStateCookieChunk().getBytes());
        if (chunk.getIPv4Addresses() != null) {
            for (int i = 0; i < ArrayExtensions.getLength(chunk.getIPv4Addresses()); ++i) {
                bytes.addRange(chunk.getIPv4Addresses()[i].getBytes());
            }
        }
        if (chunk.getHostNameAddress() != null) {
            bytes.addRange(chunk.getHostNameAddress().getBytes());
        }
        if (chunk.getUnrecognizedParameter() != null) {
            bytes.addRange(chunk.getUnrecognizedParameter().getBytes());
        }
        bytes.insertRange(2, Binary.toBytes16(bytes.getCount() + 2, false));
        return bytes.toArray();
    }

    public SctpDynamicAddressReconfigurationSupportParameters getDynamicAddressReconfigurationParameters() {
        return this._dynamicAddressReconfigurationParameters;
    }

    public SctpHostNameAddressChunkParameter getHostNameAddress() {
        return this._hostNameAddress;
    }

    public long getInitialTsn() {
        return this._initialTsn;
    }

    public long getInitiateTag() {
        return this._initiateTag;
    }

    public SctpIPv4ChunkParameter[] getIPv4Addresses() {
        return this._ipv4Addresses;
    }

    public int getNumberOfInboundStreams() {
        return this._numberOfInboundStreams;
    }

    public int getNumberOfOutboundStreams() {
        return this._numberOfOutboundStreams;
    }

    public SctpPartialReliabilitySupportParameters getPartialReliabilityParameters() {
        return this._partialReliabilityParameters;
    }

    public SctpStateCookieChunkParameter getStateCookieChunk() {
        return this._stateCookieChunk;
    }

    public byte[] getSupportedExtensionsChunks() {
        return this._supportedExtensionsChunks;
    }

    public SctpUnrecognizedParameterChunkParameter getUnrecognizedParameter() {
        return this._unrecognizedParameter;
    }

    public SctpGenericChunkParameter[] getUnrecognizedParametersThatNeedToBeReportedBackToSender() {
        return this._unrecognizedParametersThatNeedToBeReportedBackToSender;
    }

    public static SctpInitAckChunk parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int startIndex;
            Log.debug("SCTP manager received INIT_ACK chunk from the other party");
            int num = Binary.fromBytes16(bytes, 2, false);
            long initiateTag = Binary.fromBytes32(bytes, 4, false);
            long advertisedReceiverWindowCredit = Binary.fromBytes32(bytes, 8, false);
            int numberOfOutboundStreams = Binary.fromBytes16(bytes, 12, false);
            int numberOfInboundStreams = Binary.fromBytes16(bytes, 14, false);
            long initialTsn = Binary.fromBytes32(bytes, 16, false);
            boolean flag = true;
            ArrayList<SctpGenericChunkParameter> list = new ArrayList<SctpGenericChunkParameter>();
            SctpInitAckChunk chunk = new SctpInitAckChunk(initiateTag, advertisedReceiverWindowCredit, numberOfOutboundStreams, numberOfInboundStreams, initialTsn, null, null, null);
            for (startIndex = 20; startIndex < num; startIndex += offsetPlus.getValue()) {
                SctpTlvParameter _var0 = SctpTlvParameter.parseBytes(bytes, startIndex, offsetPlus);
                SctpTlvParameter parameter = _var0;
                if (parameter == null) {
                    offsetPlus.setValue(0);
                    return null;
                }
                if (parameter.getType() == 7 && flag) {
                    chunk.setStateCookieChunk((SctpStateCookieChunkParameter)parameter);
                } else if (parameter.getType() == 5 && flag) {
                    Object[] parameterArray = new SctpIPv4ChunkParameter[1];
                    offsetPlus.setValue(0);
                    if (chunk.getIPv4Addresses() != null) {
                        parameterArray = new SctpIPv4ChunkParameter[ArrayExtensions.getLength(chunk.getIPv4Addresses()) + 1];
                        for (int i = 0; i < ArrayExtensions.getLength(chunk.getIPv4Addresses()); ++i) {
                            parameterArray[i] = chunk.getIPv4Addresses()[i];
                        }
                    }
                    parameterArray[ArrayExtensions.getLength((Object[])parameterArray) - 1] = (SctpIPv4ChunkParameter)parameter;
                    chunk.setIPv4Addresses((SctpIPv4ChunkParameter[])parameterArray);
                } else if (parameter.getType() == 8 && flag) {
                    chunk.setUnrecognizedParameter((SctpUnrecognizedParameterChunkParameter)parameter);
                } else if (parameter.getType() == 11 && flag) {
                    chunk.setHostNameAddress((SctpHostNameAddressChunkParameter)parameter);
                } else if (parameter.getType() == 49152 && flag) {
                    if (chunk.getPartialReliabilityParameters() == null) {
                        chunk.setPartialReliabilityParameters(new SctpPartialReliabilitySupportParameters(true));
                    } else {
                        chunk.getPartialReliabilityParameters().setPartialReliabilitySupportedByThisEndpoint(true);
                    }
                } else if (parameter.getType() == 32776 && flag) {
                    chunk.setSupportedExtensionsChunks(((SctpSupportedExtensionsChunkParameter)parameter).getSupportedChunkExtensions());
                    chunk.updateSupportedFunctionalityFromTheListOfSupportedExtensions();
                } else if (parameter.getType() == 32770 && flag) {
                    if (chunk.getAuthenticatedChunksParameters() == null) {
                        chunk.setAuthenticatedChunksParameters(new SctpAuthenticatedChunksParameters(true, ((SctpRandomChunkParameter)parameter).getRandomNumber(), null, null));
                    } else {
                        chunk.getAuthenticatedChunksParameters().setAuthenticatedChunksSupportedByThisEndpoint(true);
                        chunk.getAuthenticatedChunksParameters().setRandom(((SctpRandomChunkParameter)parameter).getRandomNumber());
                    }
                } else if (parameter.getType() == 32772 && flag) {
                    if (chunk.getAuthenticatedChunksParameters() == null) {
                        chunk.setAuthenticatedChunksParameters(new SctpAuthenticatedChunksParameters(true, null, ((SctpRequestedHmacAlgorithmChunkParameter)parameter).getHmacIdentifiers(), null));
                    } else {
                        chunk.getAuthenticatedChunksParameters().setAuthenticatedChunksSupportedByThisEndpoint(true);
                        chunk.getAuthenticatedChunksParameters().setHmacIdentifiers(((SctpRequestedHmacAlgorithmChunkParameter)parameter).getHmacIdentifiers());
                    }
                } else if (parameter.getType() == 32771 && flag) {
                    if (ArrayExtensions.getLength(((SctpChunkListChunkParameter)parameter).getChunkList()) > 0) {
                        if (chunk.getAuthenticatedChunksParameters() == null) {
                            chunk.setAuthenticatedChunksParameters(new SctpAuthenticatedChunksParameters(true, null, null, ((SctpChunkListChunkParameter)parameter).getChunkList()));
                        } else {
                            chunk.getAuthenticatedChunksParameters().setAuthenticatedChunksSupportedByThisEndpoint(true);
                            chunk.getAuthenticatedChunksParameters().setChunksToBeAuthenticated(((SctpChunkListChunkParameter)parameter).getChunkList());
                        }
                    }
                } else {
                    if (parameter.getDoNotProcessFurtherParametersIfItIsNotRecognized()) {
                        flag = false;
                    }
                    if (parameter.getReportToSenderIfItIsNotRecognized()) {
                        list.add(SctpGenericChunkParameter.toGenericParameter(parameter));
                    }
                }
                if (!SctpTlvParameter.isInManualListOfUnrecognizedChunkParameterThatMustBeReported(parameter.getType())) continue;
                SctpGenericChunkParameter item = SctpGenericChunkParameter.toGenericParameter(parameter);
                list.add(item);
            }
            if (ArrayListExtensions.getCount(list) > 0) {
                chunk.setUnrecognizedParametersThatNeedToBeReportedBackToSender(list.toArray(new SctpGenericChunkParameter[0]));
            }
            offsetPlus.setValue(startIndex);
            return chunk;
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpInitAckChunk(long initiateTag, long advertisedReceiverWindowCredit, int numberOfOutboundStreams, int numberOfInboundStreams, long initialTsn, SctpStateCookieChunkParameter stateCookie, SctpHostNameAddressChunkParameter hostNameAddress, SctpUnrecognizedParameterChunkParameter unrecognizedParameter) {
        super.setCanBundleWithDataAndSackChunks(false);
        super.setType(SctpChunkType.getInitiationAck());
        this.setInitiateTag(initiateTag);
        this.setAdvertisedReceiverWindowCredit(advertisedReceiverWindowCredit);
        this.setNumberOfOutboundStreams(numberOfOutboundStreams);
        this.setNumberOfInboundStreams(numberOfInboundStreams);
        this.setInitialTsn(initialTsn);
        this.setStateCookieChunk(stateCookie);
        this.setHostNameAddress(hostNameAddress);
        this.setUnrecognizedParameter(unrecognizedParameter);
        super.setUnrecognized(false);
    }

    public void setAdvertisedReceiverWindowCredit(long value) {
        this._advertisedReceiverWindowCredit = value;
    }

    public void setAuthenticatedChunksParameters(SctpAuthenticatedChunksParameters value) {
        this._authenticatedChunksParameters = value;
    }

    public void setDynamicAddressReconfigurationParameters(SctpDynamicAddressReconfigurationSupportParameters value) {
        this._dynamicAddressReconfigurationParameters = value;
    }

    public void setHostNameAddress(SctpHostNameAddressChunkParameter value) {
        this._hostNameAddress = value;
    }

    public void setInitialTsn(long value) {
        this._initialTsn = value;
    }

    public void setInitiateTag(long value) {
        this._initiateTag = value;
    }

    public void setIPv4Addresses(SctpIPv4ChunkParameter[] value) {
        this._ipv4Addresses = value;
    }

    public void setNumberOfInboundStreams(int value) {
        this._numberOfInboundStreams = value;
    }

    public void setNumberOfOutboundStreams(int value) {
        this._numberOfOutboundStreams = value;
    }

    public void setPartialReliabilityParameters(SctpPartialReliabilitySupportParameters value) {
        this._partialReliabilityParameters = value;
    }

    public void setStateCookieChunk(SctpStateCookieChunkParameter value) {
        this._stateCookieChunk = value;
    }

    private void setSupportedExtensionsChunks(byte[] value) {
        this._supportedExtensionsChunks = value;
    }

    public void setUnrecognizedParameter(SctpUnrecognizedParameterChunkParameter value) {
        this._unrecognizedParameter = value;
    }

    public void setUnrecognizedParametersThatNeedToBeReportedBackToSender(SctpGenericChunkParameter[] value) {
        this._unrecognizedParametersThatNeedToBeReportedBackToSender = value;
    }

    private void updateSupportedFunctionalityFromTheListOfSupportedExtensions() {
        boolean flag = false;
        boolean flag2 = false;
        boolean flag3 = false;
        for (int i = 0; i < ArrayExtensions.getLength(this.getSupportedExtensionsChunks()); ++i) {
            if (this.getSupportedExtensionsChunks()[i] == SctpChunkType.getForwardCumulativeTSN()) {
                if (this.getPartialReliabilityParameters() == null) {
                    this.setPartialReliabilityParameters(new SctpPartialReliabilitySupportParameters(true));
                    continue;
                }
                this.getPartialReliabilityParameters().setPartialReliabilitySupportedByThisEndpoint(true);
                continue;
            }
            if (this.getSupportedExtensionsChunks()[i] == SctpChunkType.getReConfig()) {
                if (this.getDynamicAddressReconfigurationParameters() == null) {
                    this.setDynamicAddressReconfigurationParameters(new SctpDynamicAddressReconfigurationSupportParameters(true));
                    continue;
                }
                this.getDynamicAddressReconfigurationParameters().setDynamicAddressReconfigurationSupportedByThisEndpoint(true);
                continue;
            }
            if (this.getSupportedExtensionsChunks()[i] == SctpChunkType.getAsConf()) {
                flag = true;
                continue;
            }
            if (this.getSupportedExtensionsChunks()[i] == SctpChunkType.getAsConfAck()) {
                flag2 = true;
                continue;
            }
            if (this.getSupportedExtensionsChunks()[i] == SctpChunkType.getAuth()) {
                flag3 = true;
                continue;
            }
            Log.debug(StringExtensions.format("Remote party declared ability to send an unknow optional SCTP chunk: {0}", ByteExtensions.toString(this.getSupportedExtensionsChunks()[i])));
        }
        if (flag && flag2 && flag3) {
            if (this.getAuthenticatedChunksParameters() == null) {
                this.setAuthenticatedChunksParameters(new SctpAuthenticatedChunksParameters(true, null, null, null));
            } else {
                this.getAuthenticatedChunksParameters().setAuthenticatedChunksSupportedByThisEndpoint(true);
            }
        }
    }
}

