/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.LocalNetwork;
import fm.icelink.Log;
import fm.icelink.SctpTlvParameter;

class SctpIPv4ChunkParameter
extends SctpTlvParameter {
    private String _ipv4Address;

    @Override
    public byte[] getBytes() {
        return SctpIPv4ChunkParameter.getBytes(this);
    }

    public static byte[] getBytes(SctpIPv4ChunkParameter parameter) {
        ByteCollection bytes = new ByteCollection();
        try {
            bytes.addRange(Binary.toBytes16(5, false));
            bytes.addRange(Binary.toBytes16(8, false));
            bytes.addRange(LocalNetwork.getAddressBytes(parameter.getIPv4Address()));
        }
        catch (Exception exception1) {
            Log.error("SCTP: could not generate IPv4ChunkParameter");
            return null;
        }
        return bytes.toArray();
    }

    public String getIPv4Address() {
        return this._ipv4Address;
    }

    public static SctpIPv4ChunkParameter parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            offsetPlus.setValue(8);
            return new SctpIPv4ChunkParameter(LocalNetwork.getAddress(BitAssistant.subArray(bytes, 4, 4)));
        }
        catch (Exception exception1) {
            Log.debug("Could not read IPv4ChunkParameter.");
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpIPv4ChunkParameter(String ipv4Address) {
        super.setType(5);
        this.setIPv4Address(ipv4Address);
    }

    public void setIPv4Address(String value) {
        this._ipv4Address = value;
    }
}

