/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.Encoding;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpChunk;
import fm.icelink.SctpTlvParameter;

class SctpHostNameAddressChunkParameter
extends SctpTlvParameter {
    private String _hostName;

    @Override
    public byte[] getBytes() {
        return SctpHostNameAddressChunkParameter.getBytes(this);
    }

    public static byte[] getBytes(SctpHostNameAddressChunkParameter parameter) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(11, false));
        byte[] buffer = Encoding.getUtf8().getBytes(parameter.getHostName());
        bytes.addRange(Binary.toBytes16(ArrayExtensions.getLength(buffer) + 4, false));
        bytes.addRange(buffer);
        SctpChunk.addPadding(bytes);
        return bytes.toArray();
    }

    public String getHostName() {
        return this._hostName;
    }

    public static SctpHostNameAddressChunkParameter parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int num = Binary.fromBytes16(bytes, 2, false);
            offsetPlus.setValue(num);
            return new SctpHostNameAddressChunkParameter(Encoding.getUtf8().getString(bytes, 4, num - 4));
        }
        catch (Exception exception1) {
            Log.debug("Could not read HostNameAddressChunkParameter.");
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpHostNameAddressChunkParameter(String hostName) {
        super.setType(11);
        this.setHostName(hostName);
    }

    public void setHostName(String value) {
        this._hostName = value;
    }
}

