/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpChunkType;
import fm.icelink.SctpControlChunk;
import fm.icelink.SctpHeartbeatInfoChunkParameter;
import fm.icelink.SctpTlvParameter;

class SctpHeartbeatAckChunk
extends SctpControlChunk {
    private SctpTlvParameter _heartbeatInfo;

    @Override
    public byte[] getBytes() {
        return SctpHeartbeatAckChunk.getBytes(this);
    }

    public static byte[] getBytes(SctpHeartbeatAckChunk chunk) {
        ByteCollection bytes = new ByteCollection();
        bytes.add((byte)chunk.getType());
        bytes.add((byte)0);
        SctpTlvParameter heartbeatInfo = chunk.getHeartbeatInfo();
        if (heartbeatInfo == null) {
            return null;
        }
        bytes.addRange(heartbeatInfo.getBytes());
        int num = 2 + bytes.getCount();
        bytes.insertRange(2, Binary.toBytes16(num, false));
        return bytes.toArray();
    }

    public SctpTlvParameter getHeartbeatInfo() {
        return this._heartbeatInfo;
    }

    public static SctpHeartbeatAckChunk parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int num = Binary.fromBytes16(bytes, 2, false);
            int startIndex = 4;
            if (num < 4) {
                offsetPlus.setValue(startIndex);
                Log.debug("SCTP received improperly formatted Heartbeat Ack chunk");
                return null;
            }
            SctpTlvParameter _var0 = SctpTlvParameter.parseBytes(bytes, startIndex, offsetPlus);
            SctpHeartbeatInfoChunkParameter heartbeatInfo = (SctpHeartbeatInfoChunkParameter)_var0;
            offsetPlus.setValue(offsetPlus.getValue() + startIndex);
            return new SctpHeartbeatAckChunk(heartbeatInfo);
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            Log.warn("Could not process SCTP Heartbeat Ack chunk");
            return null;
        }
    }

    public SctpHeartbeatAckChunk(SctpTlvParameter heartbeatInfo) {
        super.setType(SctpChunkType.getHeartbeatAck());
        this.setHeartbeatInfo(heartbeatInfo);
        super.setCanBundleWithDataAndSackChunks(false);
        super.setUnrecognized(false);
    }

    public void setHeartbeatInfo(SctpTlvParameter value) {
        this._heartbeatInfo = value;
    }
}

