/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpChunk;

class SctpGenericChunk
extends SctpChunk {
    private byte[] _chunkBytes;

    @Override
    public byte[] getBytes() {
        return SctpGenericChunk.getBytes(this);
    }

    public static byte[] getBytes(SctpGenericChunk chunk) {
        return chunk.getChunkBytes();
    }

    public byte[] getChunkBytes() {
        return this._chunkBytes;
    }

    public static SctpGenericChunk parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int len = Binary.fromBytes16(bytes, 2, false);
            offsetPlus.setValue(len + SctpChunk.calculatePaddingBytes(len));
            byte[] destination = new byte[offsetPlus.getValue()];
            BitAssistant.copy(bytes, 0, destination, 0, len);
            return new SctpGenericChunk(destination);
        }
        catch (Exception exception1) {
            Log.warn("Could not parse an unknown SCTP chunk.");
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpGenericChunk(byte[] chunkBytes) {
        this.setChunkBytes(chunkBytes);
        super.setType(chunkBytes[0]);
        super.setUnrecognized(true);
    }

    public void setChunkBytes(byte[] value) {
        this._chunkBytes = value;
    }
}

