/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.MathAssistant;
import fm.icelink.SctpTlvParameter;

class SctpCookiePreservativeChunkParameter
extends SctpTlvParameter {
    private long _suggestedCookieLifeSpanIncrement;

    @Override
    public byte[] getBytes() {
        return SctpCookiePreservativeChunkParameter.getBytes(this);
    }

    public static byte[] getBytes(SctpCookiePreservativeChunkParameter parameter) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(9, false));
        bytes.addRange(Binary.toBytes16(8, false));
        bytes.addRange(Binary.toBytes32(parameter.getSuggestedCookieLifeSpanIncrement(), false));
        return bytes.toArray();
    }

    public long getSuggestedCookieLifeSpanIncrement() {
        return this._suggestedCookieLifeSpanIncrement;
    }

    public static SctpCookiePreservativeChunkParameter parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            offsetPlus.setValue(8);
            return new SctpCookiePreservativeChunkParameter(Binary.fromBytes32(bytes, 4, false));
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            Log.debug("Could not read CookiePreservativeChunkParameter.");
            return null;
        }
    }

    public SctpCookiePreservativeChunkParameter(long cookieIncrement) {
        cookieIncrement = MathAssistant.min(0xFFFFFFFFL, cookieIncrement);
        super.setType(9);
        this.setSuggestedCookieLifeSpanIncrement(cookieIncrement);
    }

    public void setSuggestedCookieLifeSpanIncrement(long value) {
        this._suggestedCookieLifeSpanIncrement = value;
    }
}

