/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpChunk;
import fm.icelink.SctpChunkType;
import fm.icelink.SctpControlChunk;
import fm.icelink.SctpStateCookie;

class SctpCookieEchoChunk
extends SctpControlChunk {
    private byte[] _cookieBytes;

    @Override
    public byte[] getBytes() {
        return SctpCookieEchoChunk.getBytes(this);
    }

    public static byte[] getBytes(SctpCookieEchoChunk chunk) {
        ByteCollection bytes = new ByteCollection();
        bytes.add((byte)chunk.getType());
        bytes.add((byte)0);
        bytes.addRange(chunk.getCookieBytes());
        bytes.insertRange(2, Binary.toBytes16(bytes.getCount() + 2, false));
        SctpChunk.addPadding(bytes);
        return bytes.toArray();
    }

    public byte[] getCookieBytes() {
        return this._cookieBytes;
    }

    public static SctpCookieEchoChunk parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            Log.debug("SCTP manager received COOKIE_ECHO chunk from the other party");
            int len = Binary.fromBytes16(bytes, 2, false);
            byte[] destination = new byte[len - 4];
            BitAssistant.copy(bytes, 4, destination, 0, ArrayExtensions.getLength(destination));
            offsetPlus.setValue(len + SctpChunk.calculatePaddingBytes(len));
            return new SctpCookieEchoChunk(destination);
        }
        catch (Exception exception1) {
            Log.warn("Could not parse SCTP Cookie Echo chunk");
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpCookieEchoChunk(SctpStateCookie cookie) {
        super.setCanBundleWithDataAndSackChunks(true);
        super.setType(SctpChunkType.getCookieEcho());
        this.setCookieBytes(cookie.getBytes());
    }

    public SctpCookieEchoChunk(byte[] cookieBytes) {
        super.setCanBundleWithDataAndSackChunks(true);
        super.setType(SctpChunkType.getCookieEcho());
        this.setCookieBytes(cookieBytes);
        super.setUnrecognized(false);
    }

    public void setCookieBytes(byte[] value) {
        this._cookieBytes = value;
    }
}

