/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpChunk;
import fm.icelink.SctpTlvParameter;

class SctpChunkListChunkParameter
extends SctpTlvParameter {
    private byte[] _chunkList;

    @Override
    public byte[] getBytes() {
        return SctpChunkListChunkParameter.getBytes(this);
    }

    public static byte[] getBytes(SctpChunkListChunkParameter parameter) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(parameter.getType(), false));
        int num = ArrayExtensions.getLength(parameter.getChunkList()) + 4;
        bytes.addRange(Binary.toBytes16(num, false));
        bytes.addRange(parameter.getChunkList());
        SctpChunk.addPadding(bytes);
        return bytes.toArray();
    }

    public byte[] getChunkList() {
        return this._chunkList;
    }

    public static SctpChunkListChunkParameter parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int len = Binary.fromBytes16(bytes, 2, false);
            byte[] destination = new byte[len - 4];
            BitAssistant.copy(bytes, 4, destination, 0, ArrayExtensions.getLength(destination));
            int num2 = SctpChunk.calculatePaddingBytes(len);
            offsetPlus.setValue(len + num2);
            return new SctpChunkListChunkParameter(destination);
        }
        catch (Exception exception1) {
            Log.debug("Could not read ChunkListChunkParameter.");
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpChunkListChunkParameter(byte[] chunkList) {
        super.setType(32771);
        this.setChunkList(chunkList);
    }

    public void setChunkList(byte[] value) {
        this._chunkList = value;
    }
}

