/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.ScheduledItem;
import fm.icelink.SctpAbortChunk;
import fm.icelink.SctpChunkType;
import fm.icelink.SctpCookieAckChunk;
import fm.icelink.SctpCookieEchoChunk;
import fm.icelink.SctpDataChunk;
import fm.icelink.SctpErrorChunk;
import fm.icelink.SctpGenericChunk;
import fm.icelink.SctpHeartbeatAckChunk;
import fm.icelink.SctpHeartbeatChunk;
import fm.icelink.SctpInitAckChunk;
import fm.icelink.SctpInitChunk;
import fm.icelink.SctpPadChunk;
import fm.icelink.SctpSackChunk;
import fm.icelink.SctpShutdownAckChunk;
import fm.icelink.SctpShutdownChunk;
import fm.icelink.SctpShutdownCompleteChunk;
import fm.icelink.StringExtensions;

abstract class SctpChunk {
    private ScheduledItem _resendScheduledItem;
    private int _type;
    private boolean _unrecognized;

    public static void addPadding(ByteCollection bytes) {
        int num = SctpChunk.calculatePaddingBytes(bytes.getCount());
        bytes.addRange(new byte[num]);
    }

    public static int calculatePaddingBytes(int len) {
        return len % 4 == 0 ? 0 : 4 - len % 4;
    }

    public abstract byte[] getBytes();

    public boolean getDoNotProcessFurtherChunksIfItIsNotRecognized() {
        return ((byte)this.getType() & 0x80) != 128;
    }

    public boolean getReportToSenderIfItIsNotRecognized() {
        return ((byte)this.getType() & 0x40) == 64;
    }

    public ScheduledItem getResendScheduledItem() {
        return this._resendScheduledItem;
    }

    public int getType() {
        return this._type;
    }

    public boolean getUnrecognized() {
        return this._unrecognized;
    }

    public static SctpChunk parseBytes(byte[] value, int startIndex, IntegerHolder offsetPlus) {
        byte[] buffer;
        try {
            buffer = new byte[ArrayExtensions.getLength(value) - startIndex];
            BitAssistant.copy(value, startIndex, buffer, 0, ArrayExtensions.getLength(buffer));
        }
        catch (Exception exception1) {
            Log.error("SCTP: could not read SCTP packet");
            offsetPlus.setValue(0);
            return null;
        }
        if (buffer[0] == SctpChunkType.getAbort()) {
            SctpAbortChunk _var0 = SctpAbortChunk.parseBytes(buffer, offsetPlus);
            return _var0;
        }
        if (buffer[0] == SctpChunkType.getCookieAck()) {
            SctpCookieAckChunk _var1 = SctpCookieAckChunk.parseBytes(buffer, offsetPlus);
            return _var1;
        }
        if (buffer[0] == SctpChunkType.getCookieEcho()) {
            SctpCookieEchoChunk _var2 = SctpCookieEchoChunk.parseBytes(buffer, offsetPlus);
            return _var2;
        }
        if (buffer[0] == SctpChunkType.getData()) {
            SctpDataChunk _var3 = SctpDataChunk.parseBytes(buffer, offsetPlus);
            return _var3;
        }
        if (buffer[0] == SctpChunkType.getError()) {
            SctpErrorChunk _var4 = SctpErrorChunk.parseBytes(buffer, offsetPlus);
            return _var4;
        }
        if (buffer[0] == SctpChunkType.getHeartbeat()) {
            SctpHeartbeatChunk _var5 = SctpHeartbeatChunk.parseBytes(buffer, offsetPlus);
            return _var5;
        }
        if (buffer[0] == SctpChunkType.getHeartbeatAck()) {
            SctpHeartbeatAckChunk _var6 = SctpHeartbeatAckChunk.parseBytes(buffer, offsetPlus);
            return _var6;
        }
        if (buffer[0] == SctpChunkType.getInitiation()) {
            SctpInitChunk _var7 = SctpInitChunk.parseBytes(buffer, offsetPlus);
            return _var7;
        }
        if (buffer[0] == SctpChunkType.getInitiationAck()) {
            SctpInitAckChunk _var8 = SctpInitAckChunk.parseBytes(buffer, offsetPlus);
            return _var8;
        }
        if (buffer[0] == SctpChunkType.getSack()) {
            SctpSackChunk _var9 = SctpSackChunk.parseBytes(buffer, offsetPlus);
            return _var9;
        }
        if (buffer[0] == SctpChunkType.getShutdown()) {
            SctpShutdownChunk _var10 = SctpShutdownChunk.parseBytes(buffer, offsetPlus);
            return _var10;
        }
        if (buffer[0] == SctpChunkType.getShutdownAck()) {
            SctpShutdownAckChunk _var11 = SctpShutdownAckChunk.parseBytes(buffer, offsetPlus);
            return _var11;
        }
        if (buffer[0] == SctpChunkType.getShutdownComplete()) {
            SctpShutdownCompleteChunk _var12 = SctpShutdownCompleteChunk.parseBytes(buffer, offsetPlus);
            return _var12;
        }
        if (buffer[0] == SctpChunkType.getPad()) {
            SctpPadChunk _var13 = SctpPadChunk.parseBytes(buffer, offsetPlus);
            return _var13;
        }
        byte num = buffer[0];
        Log.debug(StringExtensions.format("SCTP received unrecognized chunk type {0}", IntegerExtensions.toString(Integer.valueOf(num))));
        SctpGenericChunk _var14 = SctpGenericChunk.parseBytes(buffer, offsetPlus);
        return _var14;
    }

    protected SctpChunk() {
    }

    public void setResendScheduledItem(ScheduledItem value) {
        this._resendScheduledItem = value;
    }

    protected void setType(int value) {
        this._type = value;
    }

    protected void setUnrecognized(boolean value) {
        this._unrecognized = value;
    }
}

