/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.SctpChunkType;
import fm.icelink.SctpControlChunk;
import fm.icelink.SctpErrorCause;
import java.util.ArrayList;

class SctpAbortChunk
extends SctpControlChunk {
    private SctpErrorCause[] _errorCauses;
    private boolean _verificationTagReflected;

    @Override
    public byte[] getBytes() {
        return SctpAbortChunk.getBytes(this);
    }

    public static byte[] getBytes(SctpAbortChunk chunk) {
        ByteCollection bytes = new ByteCollection();
        bytes.add((byte)chunk.getType());
        bytes.add(chunk.getVerificationTagReflected() ? (byte)1 : 0);
        int num = 4;
        if (chunk.getErrorCauses() != null) {
            for (SctpErrorCause cause : chunk.getErrorCauses()) {
                num += ArrayExtensions.getLength(cause.getBytes());
                bytes.addRange(cause.getBytes());
            }
        }
        bytes.insertRange(2, Binary.toBytes16(num, false));
        return bytes.toArray();
    }

    public SctpErrorCause[] getErrorCauses() {
        return this._errorCauses;
    }

    public boolean getVerificationTagReflected() {
        return this._verificationTagReflected;
    }

    public static SctpAbortChunk parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int startIndex;
            int num3;
            boolean verificationTagReflected = bytes[1] == 1;
            int num = Binary.fromBytes16(bytes, 2, false);
            if (num == 4) {
                offsetPlus.setValue(4);
                return new SctpAbortChunk(verificationTagReflected);
            }
            ArrayList<SctpErrorCause> list = new ArrayList<SctpErrorCause>();
            for (startIndex = 4; startIndex < num; startIndex += num3) {
                num3 = 0;
                IntegerHolder _var0 = new IntegerHolder(num3);
                SctpErrorCause _var1 = SctpErrorCause.parseBytes(bytes, startIndex, _var0);
                num3 = _var0.getValue();
                SctpErrorCause item = _var1;
                if (item == null) {
                    offsetPlus.setValue(0);
                    return null;
                }
                list.add(item);
            }
            offsetPlus.setValue(startIndex);
            return new SctpAbortChunk(verificationTagReflected, list.toArray(new SctpErrorCause[0]));
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpAbortChunk(boolean verificationTagReflected, SctpErrorCause[] errorCauses) {
        super.setCanBundleWithDataAndSackChunks(false);
        super.setType(SctpChunkType.getAbort());
        this.setVerificationTagReflected(verificationTagReflected);
        this.setErrorCauses(errorCauses);
        super.setUnrecognized(false);
    }

    public SctpAbortChunk(boolean verificationTagReflected) {
        super.setCanBundleWithDataAndSackChunks(false);
        super.setType(SctpChunkType.getAbort());
        this.setVerificationTagReflected(verificationTagReflected);
    }

    public void setErrorCauses(SctpErrorCause[] value) {
        this._errorCauses = value;
    }

    public void setVerificationTagReflected(boolean value) {
        this._verificationTagReflected = value;
    }
}

