/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AfbControlFrame;
import fm.icelink.AppControlFrame;
import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.Binary;
import fm.icelink.ByeControlFrame;
import fm.icelink.Constants;
import fm.icelink.DataBuffer;
import fm.icelink.DateExtensions;
import fm.icelink.DoubleExtensions;
import fm.icelink.FecConfig;
import fm.icelink.FecContext;
import fm.icelink.FecProducer;
import fm.icelink.FecReceiver;
import fm.icelink.FecRedPacket;
import fm.icelink.FeedbackControlFrame;
import fm.icelink.GenericNack;
import fm.icelink.GenericNackControlFrame;
import fm.icelink.Global;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IFunction1;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.IceTransport;
import fm.icelink.IceTransportState;
import fm.icelink.IntegerExtensions;
import fm.icelink.JitterBuffer;
import fm.icelink.JitterConfig;
import fm.icelink.LinkedList;
import fm.icelink.LinkedListEnumerator;
import fm.icelink.LockedRandomizer;
import fm.icelink.Log;
import fm.icelink.LongExtensions;
import fm.icelink.LongHolder;
import fm.icelink.MathAssistant;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaControlFrame;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFormatCollection;
import fm.icelink.MediaFrame;
import fm.icelink.MediaTransport;
import fm.icelink.NackBuffer;
import fm.icelink.NackConfig;
import fm.icelink.NetworkTimeProtocol;
import fm.icelink.PliControlFrame;
import fm.icelink.RRControlFrame;
import fm.icelink.ReportBlock;
import fm.icelink.ReportControlFrame;
import fm.icelink.RpsiControlFrame;
import fm.icelink.RtpPacket;
import fm.icelink.RtpSendBuffer;
import fm.icelink.SRControlFrame;
import fm.icelink.SdesChunk;
import fm.icelink.SdesControlFrame;
import fm.icelink.SdesItem;
import fm.icelink.SdesItemType;
import fm.icelink.SliControlFrame;
import fm.icelink.SrtpTransport;
import fm.icelink.StreamDirection;
import fm.icelink.StreamType;
import fm.icelink.StringExtensions;
import java.util.ArrayList;
import java.util.Date;

abstract class RtpTransport<TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>, TFormatCollection extends MediaFormatCollection<TFormat, TFormatCollection>>
extends MediaTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> {
    private int __currentFecSequenceNumber;
    private long __currentLocalSynchronizationSource = 0L;
    private int __currentMediaSequenceNumber = 0;
    private long __currentRemoteSynchronizationSource = 0L;
    private int __currentRtpSequenceNumber;
    private StreamDirection __direction = StreamDirection.Inactive;
    private LinkedList<DataBuffer> __fecBuffer;
    private long __firstSendRtpTimestamp = -1L;
    private long __firstSendTicks = -1L;
    private long __frameCount = 0L;
    private long __lastExpectedPacketCount = 0L;
    private long __lastNackNetworkConditionReportTicks = -1L;
    private long __lastNackReportTicks = -1L;
    private long __lastPliTimestamp = 0L;
    private long __lastReceivedPacketCount = 0L;
    private long __lastReceiveTransit = 0L;
    private long __lastReportSent = -1L;
    private double __lastRoundTripTime = -1.0;
    private long __lastSenderReportNtpTimestamp = 0L;
    private long __lastSenderReportTicks = 0L;
    private int __maxPliRate = 1;
    private long __maxReceivedPacketIndex = -1L;
    private long __minReceivedPacketIndex = -1L;
    private long __minReceivedRtpTimestamp = -1L;
    private long __minReceivedTicks = -1L;
    private int __nackNetworkConditionReportingInterval = 10000;
    private int __nackReportingInterval = 1000;
    private int __nacksReceivedDuringInterval = 0;
    private int __nacksReceivedDuringIntervalCriticalNetworkWarning = 1500;
    private int __nacksReceivedDuringIntervalPoorNetworkWarning = 200;
    private int __nacksReceivedDuringNetworkConditionInterval = 0;
    private int __nacksSentDuringInterval = 0;
    private int __nacksSentDuringIntervalCriticalNetworkWarning = 1500;
    private int __nacksSentDuringIntervalPoorNetworkWarning = 200;
    private int __nacksSentDuringNetworkConditionInterval = 0;
    private int __nextNackBufferRtpSequenceNumber = -1;
    private long __nextNackBufferSequenceNumber = -1L;
    private Object __receiveCountsLock;
    private double __receiveJitter = 0.0;
    private double __receiveRtpCyclesPerTick = -1.0;
    private int __reportIntervalInTicks = Constants.getTicksPerSecond();
    private double __roundTripTime = 0.0;
    private static double __roundTripTimeAlpha = 0.75;
    private int __roundTripTimeCriticalWarning = 750;
    private int __roundTripTimePoorWarning = 300;
    private double __sendRtpCyclesPerTick = -1.0;
    private Object __sentCountsLock = new Object();
    private double __smoothedVarianceEstimator = -1.0;
    private double __smoothedVarianceEstimatorBetaValue = 0.25;
    private long __startTicks = -1L;
    private int __startTimeOffset;
    private double __varianceEstimator = -1.0;
    private boolean __videoBridgeMode = false;
    private boolean _disableAutomaticReports;
    private FecConfig _fecConfig;
    private FecProducer _fecProducer;
    private FecReceiver _fecReceiver;
    private int _inboundPacketsLostRtp;
    private JitterBuffer<TFrame, TBuffer, TBufferCollection, TFormat> _jitterBuffer;
    private JitterConfig _jitterConfig;
    private NackBuffer<TFrame, TBuffer, TBufferCollection, TFormat> _nackBuffer;
    private NackConfig _nackConfig;
    private long _octetsSentRtcp;
    private long _octetsSentRtp;
    private int _outboundPacketsLostRtp;
    private long _packetsReceivedRtp;
    private long _packetsSentRtcp;
    private long _packetsSentRtp;
    private RtpSendBuffer<TFrame, TBuffer, TBufferCollection, TFormat> _sendBuffer;
    private SrtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> _srtpTransport;
    private StreamType _type;

    private void attachTransportEvents() {
        this.getSrtpTransport().addOnReceiveFrame(new IActionDelegate1<TFrame>(){

            @Override
            public String getId() {
                return "fm.icelink.MediaTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.receiveFrame";
            }

            @Override
            public void invoke(TFrame frame) {
                RtpTransport.this.receiveFrame(frame);
            }
        });
        this.getSrtpTransport().addOnReceiveControlFrames((IAction1<MediaControlFrame[]>)new IActionDelegate1<MediaControlFrame[]>(){

            @Override
            public String getId() {
                return "fm.icelink.MediaTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.receiveControlFrames";
            }

            @Override
            public void invoke(MediaControlFrame[] controlFrames) {
                RtpTransport.this.receiveControlFrames(controlFrames);
            }
        });
    }

    public abstract TFrame[] createFormatArray(int var1);

    private void detachTransportEvents() {
        this.getSrtpTransport().removeOnReceiveFrame(new IActionDelegate1<TFrame>(){

            @Override
            public String getId() {
                return "fm.icelink.MediaTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.receiveFrame";
            }

            @Override
            public void invoke(TFrame frame) {
                RtpTransport.this.receiveFrame(frame);
            }
        });
        this.getSrtpTransport().removeOnReceiveControlFrames((IAction1<MediaControlFrame[]>)new IActionDelegate1<MediaControlFrame[]>(){

            @Override
            public String getId() {
                return "fm.icelink.MediaTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.receiveControlFrames";
            }

            @Override
            public void invoke(MediaControlFrame[] controlFrames) {
                RtpTransport.this.receiveControlFrames(controlFrames);
            }
        });
    }

    @Override
    public void doReceiveControlFrames(MediaControlFrame[] controlFrames) {
        for (MediaControlFrame frame : controlFrames) {
            if (frame instanceof ByeControlFrame) {
                if (!Log.getIsDebugEnabled()) continue;
                Log.debug(StringExtensions.format("Received RTCP goodbye for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof SRControlFrame) {
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("Received RTCP sender report for {0} stream.", this.getType().toString()));
                }
                SRControlFrame frame2 = (SRControlFrame)frame;
                this.__lastSenderReportNtpTimestamp = frame2.getNtpTimestamp();
                this.__lastSenderReportTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
                ReportBlock reportBlock = frame2.getReportBlock();
                if (reportBlock == null) continue;
                this.processReportBlock(reportBlock);
                continue;
            }
            if (frame instanceof RRControlFrame) {
                RRControlFrame frame3;
                ReportBlock block;
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("Received RTCP receiver report for {0} stream.", this.getType().toString()));
                }
                if ((block = (frame3 = (RRControlFrame)frame).getReportBlock()) == null) continue;
                this.processReportBlock(block);
                continue;
            }
            if (frame instanceof AppControlFrame) {
                if (!Log.getIsDebugEnabled()) continue;
                Log.debug(StringExtensions.format("Received RTCP application-specific message for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof SdesControlFrame) {
                if (!Log.getIsDebugEnabled()) continue;
                Log.debug(StringExtensions.format("Received RTCP source description for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof AfbControlFrame) {
                if (!Log.getIsDebugEnabled()) continue;
                Log.debug(StringExtensions.format("Received RTCP application feedback for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof PliControlFrame) {
                if (!Log.getIsDebugEnabled()) continue;
                Log.debug(StringExtensions.format("Received RTCP picture loss indication for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof SliControlFrame) {
                if (!Log.getIsDebugEnabled()) continue;
                Log.debug(StringExtensions.format("Received RTCP slice loss indication for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof RpsiControlFrame) {
                if (!Log.getIsDebugEnabled()) continue;
                Log.debug(StringExtensions.format("Received RTCP reference picture selection indication for {0} stream.", this.getType().toString()));
                continue;
            }
            if (!(frame instanceof GenericNackControlFrame)) continue;
            this.processGenericNack((GenericNackControlFrame)frame);
            if (!Log.getIsDebugEnabled()) continue;
            Log.debug(StringExtensions.format("Received Generic NACK for {0} stream.", this.getType().toString()));
            this.updateNackReceiverStatistics();
        }
        this.raiseReceiveControlFrames(controlFrames);
    }

    @Override
    public void doReceiveFrame(TFrame frame) {
        this.updateRtpReceiverStatistics(RtpPacket.wrap(((MediaBuffer)((MediaFrame)frame).getBuffer()).getDataBuffer()), ((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber(), ((MediaFormat)((MediaBuffer)((MediaFrame)frame).getBuffer()).getFormat()).getClockRate());
        if (!this.getNackConfig().getDisableBuffering()) {
            TFrame local;
            if (this.__nextNackBufferSequenceNumber == -1L) {
                this.__nextNackBufferSequenceNumber = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber();
                this.__nextNackBufferRtpSequenceNumber = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getRtpSequenceNumber();
            }
            if (((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber() - this.__nextNackBufferSequenceNumber > (long)this.getNackBuffer().getLength()) {
                long sequenceNumber = this.__nextNackBufferSequenceNumber;
                int rtpSequenceNumber = this.__nextNackBufferRtpSequenceNumber;
                while (rtpSequenceNumber < ((MediaBuffer)((MediaFrame)frame).getBuffer()).getRtpSequenceNumber()) {
                    GenericNackControlFrame frame2 = null;
                    Holder<Object> _var0 = new Holder<Object>(frame2);
                    TFrame _var1 = this.getNackBuffer().read(sequenceNumber, rtpSequenceNumber, -1L, _var0);
                    frame2 = _var0.getValue();
                    local = _var1;
                    if (local != null) {
                        this.processJitterBuffer(local);
                    }
                    ++rtpSequenceNumber;
                    ++sequenceNumber;
                }
                this.__nextNackBufferSequenceNumber = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber();
            }
            if (!this.getNackBuffer().write(frame) && Log.getIsDebugEnabled()) {
                Log.debug("NACK buffer is discarding stale/duplicate packet for video stream.");
            }
            GenericNackControlFrame genericNack = null;
            while (true) {
                Holder<Object> _var2 = new Holder<Object>(genericNack);
                TFrame _var3 = this.getNackBuffer().read(this.__nextNackBufferSequenceNumber, this.__nextNackBufferRtpSequenceNumber, ((MediaFrame)frame).getTimestamp(), _var2);
                genericNack = _var2.getValue();
                local = _var3;
                if (local == null) {
                    if (genericNack != null) {
                        super.sendControlFrames(new MediaControlFrame[]{genericNack});
                        if (Log.getIsDebugEnabled()) {
                            this.updateNackSenderStatistics();
                        }
                    }
                    return;
                }
                this.__nextNackBufferSequenceNumber = ((MediaBuffer)((MediaFrame)local).getBuffer()).getSequenceNumber() + 1L;
                this.__nextNackBufferRtpSequenceNumber = (((MediaBuffer)((MediaFrame)local).getBuffer()).getRtpSequenceNumber() + 1) % 65536;
                this.processJitterBuffer(local);
            }
        }
        this.processJitterBuffer(frame);
    }

    @Override
    public void doSendControlFrames(MediaControlFrame[] controlFrames) {
        SrtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> srtpTransport;
        long[] localSynchronizationSources;
        if (this.__currentLocalSynchronizationSource == 0L && (localSynchronizationSources = super.getLocalSynchronizationSources()) != null && ArrayExtensions.getLength(localSynchronizationSources) > 0) {
            this.__currentLocalSynchronizationSource = localSynchronizationSources[0];
        }
        if (ArrayExtensions.getLength(controlFrames) > 0) {
            SdesControlFrame sdes;
            int n;
            ArrayList<MediaControlFrame> list;
            ReportControlFrame report;
            for (MediaControlFrame frame : controlFrames) {
                int num2;
                if (!(frame instanceof PliControlFrame)) continue;
                if (this.__maxPliRate == 0) {
                    return;
                }
                long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
                if (ticks - this.__lastPliTimestamp < (long)(num2 = Constants.getMillisecondsPerSecond() / this.__maxPliRate * Constants.getTicksPerMillisecond())) {
                    return;
                }
                this.__lastPliTimestamp = ticks;
                Log.debug("Sending RTCP picture loss indication");
            }
            if ((ArrayExtensions.getLength(controlFrames) < 1 || !(controlFrames[0] instanceof SRControlFrame) && !(controlFrames[0] instanceof RRControlFrame)) && (report = this.getReport()) != null) {
                list = new ArrayList<MediaControlFrame>();
                MediaControlFrame[] mediaControlFrameArray = controlFrames;
                n = mediaControlFrameArray.length;
                for (int frame = 0; frame < n; ++frame) {
                    MediaControlFrame frame3 = mediaControlFrameArray[frame];
                    list.add(frame3);
                }
                ArrayListExtensions.insert(list, 0, report);
                controlFrames = list.toArray(new MediaControlFrame[0]);
            }
            if (!(ArrayExtensions.getLength(controlFrames) >= 2 && controlFrames[1] instanceof SdesControlFrame || (sdes = this.getSdes()) == null)) {
                list = new ArrayList();
                MediaControlFrame[] mediaControlFrameArray = controlFrames;
                n = mediaControlFrameArray.length;
                for (int frame = 0; frame < n; ++frame) {
                    MediaControlFrame frame3 = mediaControlFrameArray[frame];
                    list.add(frame3);
                }
                ArrayListExtensions.insert(list, 1, sdes);
                controlFrames = list.toArray(new MediaControlFrame[0]);
            }
            for (MediaControlFrame frame3 : controlFrames) {
                if (frame3 instanceof SRControlFrame) {
                    this.validateSRControlFrame((SRControlFrame)frame3);
                } else if (frame3 instanceof RRControlFrame) {
                    this.validateRRControlFrame((RRControlFrame)frame3);
                } else if (frame3 instanceof SdesControlFrame) {
                    this.validateSdesControlFrame((SdesControlFrame)frame3);
                } else if (frame3 instanceof FeedbackControlFrame) {
                    this.validateFeedbackControlFrame((FeedbackControlFrame)frame3);
                } else if (frame3 instanceof ByeControlFrame) {
                    this.validateByeControlFrame((ByeControlFrame)frame3);
                } else if (frame3 instanceof AppControlFrame) {
                    this.validateAppControlFrame((AppControlFrame)frame3);
                }
                this.updateRtcpSenderStatistics(frame3);
            }
        }
        if ((srtpTransport = this.getSrtpTransport()) != null) {
            srtpTransport.sendControlFrames(controlFrames);
        }
    }

    @Override
    public boolean doSendFrame(TFrame frame) {
        if (ArrayExtensions.getLength(frame.getBuffers()) == 0) {
            Log.error("Frame has no buffers to send!");
        }
        for (int i = ArrayExtensions.getLength(frame.getBuffers()) - 1; i >= 0; --i) {
            MediaBuffer buffer = frame.getBuffers()[i];
            if (!((MediaFormat)buffer.getFormat()).getIsPacketized()) continue;
            if (this.prepareBufferForSend(buffer, frame)) {
                if (!this.getNackConfig().getDisableBuffering()) {
                    this.getSendBuffer().write(frame);
                }
                this.processSendFec(frame);
            }
            return true;
        }
        Log.error("Frame has no packetized buffers to send. Are you missing a packetizer?");
        return false;
    }

    @Override
    public boolean doStart() {
        if (super.getParameters() == null) {
            Log.error("Cannot start RTP transport. Rtp.Parameters must be set.");
            return false;
        }
        if (this.getSrtpTransport() == null) {
            Log.error("Cannot start RTP transport. Srtp.Transport must be set.");
            return false;
        }
        this.attachTransportEvents();
        return true;
    }

    @Override
    public boolean doStop() {
        this.detachTransportEvents();
        return true;
    }

    public int getAverageFrameRate() {
        if (this.__frameCount == 0L) {
            return -1;
        }
        long num = DateExtensions.getTicks(DateExtensions.getUtcNow()) - this.__startTicks;
        if (num < (long)Constants.getTicksPerSecond()) {
            return -1;
        }
        return (int)(this.__frameCount * (long)Constants.getTicksPerSecond() / num);
    }

    public StreamDirection getDirection() {
        return this.__direction;
    }

    public boolean getDisableAutomaticReports() {
        return this._disableAutomaticReports;
    }

    public FecConfig getFecConfig() {
        return this._fecConfig;
    }

    public int getInboundPacketsLostRtp() {
        return this._inboundPacketsLostRtp;
    }

    public JitterBuffer<TFrame, TBuffer, TBufferCollection, TFormat> getJitterBuffer() {
        return this._jitterBuffer;
    }

    public JitterConfig getJitterConfig() {
        return this._jitterConfig;
    }

    public int getMaxPliRate() {
        return this.__maxPliRate;
    }

    public NackBuffer<TFrame, TBuffer, TBufferCollection, TFormat> getNackBuffer() {
        return this._nackBuffer;
    }

    public NackConfig getNackConfig() {
        return this._nackConfig;
    }

    private int getNextRtpSequenceNumber(LongHolder nextMediaSequenceNumber) {
        int _var0 = this.incrementRtpSequenceNumber(nextMediaSequenceNumber);
        return _var0;
    }

    private long getNextTimestamp(long frameTimestamp) {
        return (frameTimestamp + (long)this.__startTimeOffset) % 0x80000000L;
    }

    public long getOctetsSentRtcp() {
        return this._octetsSentRtcp;
    }

    public long getOctetsSentRtp() {
        return this._octetsSentRtp;
    }

    public int getOutboundPacketsLostRtp() {
        return this._outboundPacketsLostRtp;
    }

    public long getPacketsReceivedRtp() {
        return this._packetsReceivedRtp;
    }

    public long getPacketsSentRtcp() {
        return this._packetsSentRtcp;
    }

    public long getPacketsSentRtp() {
        return this._packetsSentRtp;
    }

    private ReportControlFrame getReport() {
        ReportBlock reportBlock = null;
        if (this.__maxReceivedPacketIndex > -1L) {
            reportBlock = new ReportBlock();
        }
        if (Global.equals((Object)this.getDirection(), (Object)StreamDirection.ReceiveOnly)) {
            Log.debug("Generating RTCP receiver report.");
            if (reportBlock != null) {
                return new RRControlFrame(this.__currentRemoteSynchronizationSource, reportBlock);
            }
            return new RRControlFrame();
        }
        Log.debug("Generating RTCP sender report.");
        if (reportBlock != null) {
            return new SRControlFrame(this.__currentLocalSynchronizationSource, 0L, 0L, 0L, 0L, reportBlock);
        }
        return new SRControlFrame();
    }

    public double getRoundTripTime() {
        return this.__roundTripTime;
    }

    private SdesControlFrame getSdes() {
        return new SdesControlFrame(new SdesChunk(this.__currentLocalSynchronizationSource, new SdesItem(SdesItemType.getCanonicalName(), super.getParameters().getCanonicalName())));
    }

    public RtpSendBuffer<TFrame, TBuffer, TBufferCollection, TFormat> getSendBuffer() {
        return this._sendBuffer;
    }

    public SrtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> getSrtpTransport() {
        return this._srtpTransport;
    }

    public StreamType getType() {
        return this._type;
    }

    private int incrementFecSequenceNumber() {
        int num = this.__currentFecSequenceNumber++;
        if (this.__currentFecSequenceNumber == 65536) {
            this.__currentFecSequenceNumber = 0;
        }
        return num;
    }

    private int incrementRtpSequenceNumber(LongHolder nextMediaSequenceNumber) {
        nextMediaSequenceNumber.setValue(this.__currentMediaSequenceNumber++);
        int num = this.__currentRtpSequenceNumber++;
        if (this.__currentRtpSequenceNumber == 65536) {
            this.__currentRtpSequenceNumber = 0;
        }
        return num;
    }

    private boolean prepareBufferForSend(TBuffer buffer, TFrame frame) {
        if (((MediaFrame)frame).getSynchronizationSource() == -1L) {
            Log.error("RTP Transport cannot process frame. SynchronizationSource not set.");
            return false;
        }
        ((MediaBuffer)buffer).setSequenceNumbers(new long[ArrayExtensions.getLength(((MediaBuffer)buffer).getDataBuffers())]);
        for (int i = 0; i < ArrayExtensions.getLength(((MediaBuffer)buffer).getDataBuffers()); ++i) {
            RtpPacket rtpPacket = RtpPacket.wrap(((MediaBuffer)buffer).getDataBuffers()[i]);
            if (this.__currentLocalSynchronizationSource == 0L) {
                this.__currentLocalSynchronizationSource = ((MediaFrame)frame).getSynchronizationSource();
            }
            if (!this.__videoBridgeMode) {
                long nextMediaSequenceNumber = 0L;
                LongHolder _var0 = new LongHolder(nextMediaSequenceNumber);
                int _var1 = this.getNextRtpSequenceNumber(_var0);
                nextMediaSequenceNumber = _var0.getValue();
                rtpPacket.setSequenceNumber(_var1);
                ((MediaBuffer)buffer).getSequenceNumbers()[i] = nextMediaSequenceNumber;
                rtpPacket.setTimestamp(this.getNextTimestamp(((MediaFrame)frame).getTimestamp()));
            }
            rtpPacket.setSynchronizationSource(this.__currentLocalSynchronizationSource);
            rtpPacket.setContributingSources(((MediaFrame)frame).getContributingSources());
            rtpPacket.setPayloadType(super.getPayloadType(((MediaFormat)((MediaBuffer)buffer).getFormat()).getName()));
            this.updateRtpSenderStatistics(rtpPacket);
        }
        return true;
    }

    private void processGenericNack(GenericNackControlFrame genericNack) {
        for (GenericNack nack : genericNack.getGenericNacks()) {
            this.resendRtpPacket(nack.getPacketId());
            int packetId = nack.getPacketId();
            for (int i = 1; i <= nack.getLostPacketIdPlusLength(); ++i) {
                if (!nack.getLostPacketIdPlus(i)) continue;
                this.resendRtpPacket((packetId + i) % 65536);
            }
        }
    }

    private void processJitterBuffer(TFrame frame) {
        if (this.getJitterConfig().getDisableBuffering()) {
            this.processReceiveFec(frame);
        } else {
            if (this.getJitterBuffer() == null) {
                RtpPacket packet = RtpPacket.wrap(((MediaBuffer)((MediaFrame)frame).getBuffer()).getDataBuffer());
                this.setJitterBuffer(new JitterBuffer(this.getType().toString(), ((MediaFormat)super.getFormat(packet.getPayloadType())).getClockRate(), this.getJitterConfig().getBufferLength(), this.getJitterConfig().getBufferMaxLength()));
            }
            if (!this.getJitterBuffer().push(frame) && Log.getIsDebugEnabled()) {
                Log.debug("Jitter buffer is discarding late packet for stream.");
            }
            ArrayList<TFrame> list = this.getJitterBuffer().pull();
            for (MediaFrame local : list) {
                this.processReceiveFec(local);
            }
        }
    }

    private void processReceiveFec(TFrame frame) {
        if (this.getFecConfig().getDisabled()) {
            this.raiseReceiveFrame(frame);
        } else if (Global.equals(((MediaFormat)((MediaBuffer)((MediaFrame)frame).getBuffer()).getFormat()).getName(), MediaFormat.getRedName())) {
            RtpPacket packet;
            if (this._fecReceiver == null) {
                this._fecReceiver = new FecReceiver();
            }
            if (this._fecReceiver.addReceivedRedPacket((packet = RtpPacket.wrap(((MediaBuffer)((MediaFrame)frame).getBuffer()).getDataBuffer())).getHeaderLength(), packet.getSequenceNumber(), ((MediaBuffer)((MediaFrame)frame).getLastBuffer()).getDataBuffer(), ((MediaBuffer)((MediaFrame)frame).getLastBuffer()).getDataBuffer().getLength(), super.getPayloadType(MediaFormat.getUlpFecName()))) {
                this.__fecBuffer.clear();
                if (!this._fecReceiver.processReceivedFec(this.__fecBuffer)) {
                    // empty if block
                }
                LinkedListEnumerator<DataBuffer> enumerator = this.__fecBuffer.getEnumerator();
                while (enumerator.moveNext()) {
                    RtpPacket packet2 = RtpPacket.wrap(enumerator.getCurrent());
                    Object format = super.getFormat(packet2.getPayloadType());
                    if (format == null) {
                        Log.warn(StringExtensions.format("Unknown packet type of {0} received from Fec.", IntegerExtensions.toString(packet2.getPayloadType())));
                        continue;
                    }
                    TFrame local2 = this.getSrtpTransport().generateFrame(packet2, format);
                    this.raiseReceiveFrame(local2);
                }
            }
        } else {
            this.raiseReceiveFrame(frame);
        }
    }

    private void processReportBlock(ReportBlock block) {
        if (block.getLastSenderReportTimestamp() > 0L) {
            long ticks;
            long num6;
            long num = DateExtensions.getTicks(NetworkTimeProtocol.compactNtpToDateTime(block.getLastSenderReportTimestamp())) / (long)Constants.getTicksPerMillisecond();
            long num2 = block.getDelaySinceLastSenderReport() * 1000L / 65536L;
            long num3 = DateExtensions.getTicks(NetworkTimeProtocol.compactNtpToDateTime(NetworkTimeProtocol.dateTimeToCompactNtp(DateExtensions.getUtcNow()))) / (long)Constants.getTicksPerMillisecond();
            double num4 = (double)(num3 - num - num2) / 1000.0;
            if (this.getRoundTripTime() == 0.0) {
                this.setRoundTripTime(num4);
            } else {
                this.setRoundTripTime(__roundTripTimeAlpha * this.getRoundTripTime() + (1.0 - __roundTripTimeAlpha) * num4);
            }
            if (!this.getNackConfig().getDisableBuffering()) {
                this.getNackBuffer().setRetransmissionTimeout((int)(this.getRoundTripTime() * (double)Constants.getMillisecondsPerSecond()));
            }
            if ((num6 = ((ticks = DateExtensions.getTicks(DateExtensions.getUtcNow())) - this.__lastNackNetworkConditionReportTicks) / (long)Constants.getTicksPerMillisecond()) > (long)this.__nackNetworkConditionReportingInterval) {
                if (this.getRoundTripTime() * 1000.0 > (double)this.__roundTripTimeCriticalWarning) {
                    Log.warn(StringExtensions.format("Critical network condition detected! Round trip time exceeding {0}s.", DoubleExtensions.toString(this.getRoundTripTime())));
                } else if (this.getRoundTripTime() * 1000.0 > (double)this.__roundTripTimePoorWarning) {
                    Log.warn(StringExtensions.format("Poor network condition detected! Round trip time exceeding {0}s.", DoubleExtensions.toString(this.getRoundTripTime())));
                }
                this.__lastNackNetworkConditionReportTicks = ticks;
            }
        }
        this.setOutboundPacketsLostRtp(block.getCumulativeNumberOfPacketsLost());
    }

    private void processSendFec(TFrame frame) {
        SrtpTransport<Object, TBuffer, TBufferCollection, TFormat, TFormatCollection> srtpTransport = this.getSrtpTransport();
        if (srtpTransport != null) {
            FecRedPacket packet2;
            RtpPacket packet = null;
            if (!this.getFecConfig().getDisabled()) {
                if (this._fecProducer == null) {
                    this._fecProducer = new FecProducer(new FecContext());
                }
                Object lastBuffer = ((MediaFrame)frame).getLastBuffer();
                Object local2 = ((MediaBuffer)((MediaFrame)frame).getLastBuffer()).clone();
                ((MediaBuffer)local2).setDataBuffers(new DataBuffer[ArrayExtensions.getLength(((MediaBuffer)lastBuffer).getDataBuffers())]);
                for (int i = 0; i < ArrayExtensions.getLength(((MediaBuffer)lastBuffer).getDataBuffers()); ++i) {
                    DataBuffer buffer = ((MediaBuffer)lastBuffer).getDataBuffers()[i];
                    packet = RtpPacket.wrap(buffer);
                    packet2 = this._fecProducer.buildRedPacket(buffer, buffer.getLength() - packet.getHeaderLength(), packet.getHeaderLength(), super.getPayloadType(MediaFormat.getRedName()));
                    ((MediaBuffer)local2).getDataBuffers()[i] = packet2.getData();
                    if (this._fecProducer.addRtpPacketAndGenerateFec(buffer, buffer.getLength() - packet.getHeaderLength(), packet.getHeaderLength())) continue;
                    Log.warn("Could not add RTP packet to outbound FEC context.");
                    return;
                }
                ((MediaBuffer)local2).setFormat(super.getFormat(MediaFormat.getRedName()));
                ((MediaFrame)frame).addBuffer((Object)local2);
            }
            srtpTransport.sendFrame(frame);
            while (!this.getFecConfig().getDisabled() && this._fecProducer != null && this._fecProducer.getFecAvailable()) {
                long nextMediaSequenceNumber = 0L;
                LongHolder _var0 = new LongHolder(nextMediaSequenceNumber);
                int _var1 = this.getNextRtpSequenceNumber(_var0);
                nextMediaSequenceNumber = _var0.getValue();
                packet2 = this._fecProducer.getFecPacket(super.getPayloadType(MediaFormat.getRedName()), super.getPayloadType(MediaFormat.getUlpFecName()), _var1, packet.getHeaderLength());
                Object local3 = ((MediaFrame)frame).clone();
                Object local4 = ((MediaBuffer)((MediaFrame)frame).getLastBuffer()).clone();
                ((MediaBuffer)local4).setFormat(super.getFormat(MediaFormat.getRedName()));
                ((MediaBuffer)local4).setDataBuffer(packet2.getData().subset(0, packet2.getLength()));
                ((MediaBuffer)local4).setSequenceNumber(nextMediaSequenceNumber);
                ((MediaFrame)local3).addBuffer(local4);
                srtpTransport.sendFrame(local3);
            }
        }
    }

    public void resendRtpPacket(int sequenceNumber) {
        if (!this.getNackConfig().getDisableBuffering()) {
            TFrame local = this.getSendBuffer().read(sequenceNumber);
            if (local != null) {
                for (int i = ArrayExtensions.getLength(local.getBuffers()) - 1; i > 0; --i) {
                    MediaBuffer local2 = local.getBuffers()[ArrayExtensions.getLength(local.getBuffers()) - 1];
                    if (!((MediaFormat)local2.getFormat()).getIsPacketized()) continue;
                    for (DataBuffer buffer : local2.getDataBuffers()) {
                        RtpPacket packet = RtpPacket.wrap(buffer);
                        if (packet.getSequenceNumber() != sequenceNumber) continue;
                        if (((MediaFormat)local2.getFormat()).getIsEncrypted()) {
                            IceTransport rtpTransport = (IceTransport)this.getSrtpTransport().getRtpTransport();
                            if (rtpTransport == null || Global.equals((Object)rtpTransport.getState(), (Object)IceTransportState.New) && Global.equals((Object)rtpTransport.getState(), (Object)IceTransportState.Disconnected) && Global.equals((Object)rtpTransport.getState(), (Object)IceTransportState.Closed)) continue;
                            rtpTransport.send(packet.getBuffer());
                            continue;
                        }
                        Object frame = ((MediaFrame)local).clone();
                        if (ArrayExtensions.getLength(frame.getBuffers()) > 1) {
                            ((MediaFrame)frame).setBuffer(local2.clone());
                        }
                        if (ArrayExtensions.getLength(((MediaBuffer)((MediaFrame)frame).getBuffer()).getDataBuffers()) > 1) {
                            ((MediaBuffer)((MediaFrame)frame).getBuffer()).setDataBuffer(buffer);
                        }
                        this.getSrtpTransport().sendFrame(frame);
                    }
                    break;
                }
            } else {
                Log.info("Unable to recover packet in response to Generic NACK.");
            }
        }
    }

    public RtpTransport(Object lockObject, StreamType streamType, NackConfig nackConfig, JitterConfig jitterConfig, FecConfig fecConfig, boolean disableAutomaticReports) {
        super(lockObject);
        this.__receiveCountsLock = new Object();
        this.__startTimeOffset = -LockedRandomizer.next(Constants.getSecondsPerDay() * 365);
        this.__currentRtpSequenceNumber = LockedRandomizer.next(64512) + 512;
        this.__currentFecSequenceNumber = LockedRandomizer.next(64512) + 512;
        this.__fecBuffer = new LinkedList();
        this.setType(streamType);
        this.setNackConfig(nackConfig);
        this.setJitterConfig(jitterConfig);
        this.setFecConfig(fecConfig);
        if (!nackConfig.getDisableBuffering()) {
            this.setSendBuffer(new RtpSendBuffer(this.getType().toString(), this.getNackConfig().getSendBufferLength(), (IFunction1<Integer, TFrame[]>)new IFunctionDelegate1<Integer, TFrame[]>(){

                @Override
                public String getId() {
                    return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.createFormatArray";
                }

                @Override
                public TFrame[] invoke(Integer size) {
                    return RtpTransport.this.createFormatArray(size);
                }
            }));
            this.setNackBuffer(new NackBuffer(this.getType().toString(), this.getNackConfig().getReceiveBufferLength(), (IFunction1<Integer, TFrame[]>)new IFunctionDelegate1<Integer, TFrame[]>(){

                @Override
                public String getId() {
                    return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.createFormatArray";
                }

                @Override
                public TFrame[] invoke(Integer size) {
                    return RtpTransport.this.createFormatArray(size);
                }
            }));
        }
    }

    private void sendBye(String reason) {
        super.sendControlFrames(new MediaControlFrame[]{this.getReport(), new ByeControlFrame(this.__currentLocalSynchronizationSource, reason)});
    }

    private void sendReport() {
        try {
            if (!this.getDisableAutomaticReports()) {
                super.sendControlFrames(new MediaControlFrame[]{this.getReport()});
            }
        }
        catch (Exception exception) {
            Log.debug("Could not send RTCP report.", exception);
        }
    }

    private void sendReportIfNeeded() {
        long ticks;
        if (this.__lastReportSent == -1L) {
            this.__lastReportSent = DateExtensions.getTicks(DateExtensions.getUtcNow());
        } else if (this.__currentLocalSynchronizationSource != 0L && (ticks = DateExtensions.getTicks(DateExtensions.getUtcNow())) - this.__lastReportSent > (long)this.__reportIntervalInTicks) {
            boolean flag = false;
            if (ticks - this.__lastReportSent > (long)this.__reportIntervalInTicks) {
                flag = true;
                this.__lastReportSent = ticks;
            }
            if (flag) {
                this.sendReport();
            }
        }
    }

    public void setDirection(StreamDirection value) {
        this.__direction = value;
    }

    public void setDisableAutomaticReports(boolean value) {
        this._disableAutomaticReports = value;
    }

    private void setFecConfig(FecConfig value) {
        this._fecConfig = value;
    }

    private void setInboundPacketsLostRtp(int value) {
        this._inboundPacketsLostRtp = value;
    }

    private void setJitterBuffer(JitterBuffer<TFrame, TBuffer, TBufferCollection, TFormat> value) {
        this._jitterBuffer = value;
    }

    private void setJitterConfig(JitterConfig value) {
        this._jitterConfig = value;
    }

    public void setMaxPliRate(int value) {
        this.__maxPliRate = MathAssistant.max(MathAssistant.min(value, Constants.getMillisecondsPerSecond()), 0);
    }

    private void setNackBuffer(NackBuffer<TFrame, TBuffer, TBufferCollection, TFormat> value) {
        this._nackBuffer = value;
    }

    private void setNackConfig(NackConfig value) {
        this._nackConfig = value;
    }

    private void setOctetsSentRtcp(long value) {
        this._octetsSentRtcp = value;
    }

    private void setOctetsSentRtp(long value) {
        this._octetsSentRtp = value;
    }

    private void setOutboundPacketsLostRtp(int value) {
        this._outboundPacketsLostRtp = value;
    }

    private void setPacketsReceivedRtp(long value) {
        this._packetsReceivedRtp = value;
    }

    private void setPacketsSentRtcp(long value) {
        this._packetsSentRtcp = value;
    }

    private void setPacketsSentRtp(long value) {
        this._packetsSentRtp = value;
    }

    public void setRoundTripTime(double value) {
        this.__roundTripTime = value;
    }

    private void setSendBuffer(RtpSendBuffer<TFrame, TBuffer, TBufferCollection, TFormat> value) {
        this._sendBuffer = value;
    }

    public void setSrtpTransport(SrtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> value) {
        this._srtpTransport = value;
    }

    private void setType(StreamType value) {
        this._type = value;
    }

    private void updateNackReceiverStatistics() {
        long num3;
        long ticks;
        long num2;
        ++this.__nacksReceivedDuringInterval;
        ++this.__nacksReceivedDuringNetworkConditionInterval;
        if (this.__lastNackReportTicks == -1L) {
            this.__lastNackReportTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        }
        if ((num2 = ((ticks = DateExtensions.getTicks(DateExtensions.getUtcNow())) - this.__lastNackReportTicks) / (long)Constants.getTicksPerSecond()) > (long)this.__nackReportingInterval) {
            Log.debug(StringExtensions.format("Received {0} generic NACKs in the last {1}ms.", IntegerExtensions.toString(this.__nacksReceivedDuringInterval), LongExtensions.toString(num2)));
            this.__nacksReceivedDuringInterval = 0;
            this.__lastNackReportTicks = ticks;
        }
        if ((num3 = (ticks - this.__lastNackNetworkConditionReportTicks) / (long)Constants.getTicksPerMillisecond()) > (long)this.__nackNetworkConditionReportingInterval) {
            if (this.__nacksReceivedDuringNetworkConditionInterval > this.__nacksReceivedDuringIntervalCriticalNetworkWarning) {
                Log.warn(StringExtensions.format("Critical network condition detected! NACKs sent exceeding critical threshold ({0}:{1}).", LongExtensions.toString(num3), IntegerExtensions.toString(this.__nacksReceivedDuringIntervalCriticalNetworkWarning)));
            } else if (this.__nacksReceivedDuringNetworkConditionInterval > this.__nacksReceivedDuringIntervalPoorNetworkWarning) {
                Log.warn(StringExtensions.format("Poor network condition detected! Large numbers of NACKs being sent ({0}:{1}).", LongExtensions.toString(num3), IntegerExtensions.toString(this.__nacksReceivedDuringIntervalCriticalNetworkWarning)));
            }
            this.__nacksSentDuringNetworkConditionInterval = 0;
            this.__lastNackNetworkConditionReportTicks = ticks;
        }
    }

    private void updateNackSenderStatistics() {
        ++this.__nacksSentDuringInterval;
        ++this.__nacksSentDuringNetworkConditionInterval;
        if (this.__lastNackReportTicks == -1L) {
            this.__lastNackReportTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        }
        if (this.__lastNackNetworkConditionReportTicks == -1L) {
            this.__lastNackNetworkConditionReportTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        }
        long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        long num2 = (ticks - this.__lastNackReportTicks) / (long)Constants.getTicksPerMillisecond();
        long num3 = (ticks - this.__lastNackNetworkConditionReportTicks) / (long)Constants.getTicksPerMillisecond();
        if (num2 > (long)this.__nackReportingInterval) {
            Log.debug(StringExtensions.format("Sent {0} generic NACKs in the last {1}ms.", IntegerExtensions.toString(this.__nacksSentDuringInterval), LongExtensions.toString(num2)));
            this.__nacksSentDuringInterval = 0;
            this.__lastNackReportTicks = ticks;
        }
        if (num3 > (long)this.__nackNetworkConditionReportingInterval) {
            if (this.__nacksSentDuringNetworkConditionInterval > this.__nacksSentDuringIntervalCriticalNetworkWarning) {
                Log.warn(StringExtensions.format("Critical network condition detected! NACKs sent exceeding critical threshold ({0}ms {1}).", LongExtensions.toString(num3), IntegerExtensions.toString(this.__nacksSentDuringIntervalCriticalNetworkWarning)));
            } else if (this.__nacksSentDuringNetworkConditionInterval > this.__nacksSentDuringIntervalPoorNetworkWarning) {
                Log.warn(StringExtensions.format("Poor network condition detected! Large numbers of NACKs being sent ({0}ms {1}).", LongExtensions.toString(num3), IntegerExtensions.toString(this.__nacksSentDuringIntervalPoorNetworkWarning)));
            }
            this.__nacksSentDuringNetworkConditionInterval = 0;
            this.__lastNackNetworkConditionReportTicks = ticks;
        }
    }

    private void updateRoundTripTime(double roundTripTime) {
        if (this.__smoothedVarianceEstimator == -1.0) {
            this.__smoothedVarianceEstimator = roundTripTime / 2.0;
        } else {
            this.__varianceEstimator = MathAssistant.abs(roundTripTime - this.__lastRoundTripTime);
            this.__smoothedVarianceEstimator = (1.0 - this.__smoothedVarianceEstimatorBetaValue) * this.__smoothedVarianceEstimator + this.__smoothedVarianceEstimatorBetaValue * this.__varianceEstimator;
        }
        this.getNackBuffer().setRetransmissionTimeout((int)((this.__roundTripTime + 4.0 * this.__smoothedVarianceEstimator) * 1000.0));
    }

    private void updateRtcpSenderStatistics(MediaControlFrame frame) {
        long num = this.getOctetsSentRtcp() + (long)frame.getDataBuffer().getLength();
        if (num >= 0x100000000L) {
            num -= 0x100000000L;
        }
        this.setOctetsSentRtcp(num);
        long num2 = this.getPacketsSentRtcp() + 1L;
        if (num2 >= 0x100000000L) {
            num2 -= 0x100000000L;
        }
        this.setPacketsSentRtcp(num2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRtpReceiverStatistics(RtpPacket packet, long sequenceNumber, int clockRate) {
        Object object = this.__receiveCountsLock;
        synchronized (object) {
            long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
            if (this.__currentRemoteSynchronizationSource == 0L) {
                this.__currentRemoteSynchronizationSource = packet.getSynchronizationSource();
                this.__minReceivedRtpTimestamp = packet.getTimestamp();
                this.__minReceivedTicks = ticks;
                this.__minReceivedPacketIndex = sequenceNumber;
                this.__maxReceivedPacketIndex = sequenceNumber;
                this.__receiveRtpCyclesPerTick = clockRate / Constants.getTicksPerSecond();
            }
            this.__minReceivedRtpTimestamp = MathAssistant.min(packet.getTimestamp(), this.__minReceivedRtpTimestamp);
            this.__minReceivedTicks = MathAssistant.min(ticks, this.__minReceivedTicks);
            this.__minReceivedPacketIndex = MathAssistant.min(sequenceNumber, this.__minReceivedPacketIndex);
            this.__maxReceivedPacketIndex = MathAssistant.max(sequenceNumber, this.__maxReceivedPacketIndex);
            this.setPacketsReceivedRtp(this.getPacketsReceivedRtp() + 1L);
            long num2 = (long)((double)(ticks - this.__minReceivedTicks) * this.__receiveRtpCyclesPerTick) + this.__minReceivedRtpTimestamp;
            long num3 = num2 - packet.getTimestamp();
            long num4 = num3 - this.__lastReceiveTransit;
            this.__lastReceiveTransit = num3;
            if (num4 < 0L) {
                num4 = -num4;
            }
            this.__receiveJitter += ((double)num4 - this.__receiveJitter) / 16.0;
        }
        this.sendReportIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateRtpSenderStatistics(RtpPacket rtpPacket) {
        if (rtpPacket == null) {
            Log.error("Transport cannot process RTP. Malformed RTP packet in frame.");
            return false;
        }
        if (this.__firstSendRtpTimestamp == -1L) {
            Object format = super.getFormat(rtpPacket.getPayloadType());
            this.__firstSendRtpTimestamp = rtpPacket.getTimestamp();
            this.__firstSendTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
            this.__sendRtpCyclesPerTick = (double)((MediaFormat)format).getClockRate() / 1.0E7;
        }
        int length = rtpPacket.getPayload().getLength();
        Object object = this.__sentCountsLock;
        synchronized (object) {
            long num2 = this.getPacketsSentRtp() + 1L;
            if (num2 >= 0x100000000L) {
                num2 -= 0x100000000L;
            }
            this.setPacketsSentRtp(num2);
            long num3 = this.getOctetsSentRtp() + (long)length;
            if (num3 >= 0x100000000L) {
                num3 -= 0x100000000L;
            }
            this.setOctetsSentRtp(num3);
        }
        this.sendReportIfNeeded();
        return true;
    }

    private void validateAppControlFrame(AppControlFrame frame) {
        frame.setSynchronizationSource(this.__currentLocalSynchronizationSource);
    }

    private void validateByeControlFrame(ByeControlFrame frame) {
        if (frame.getSourceCount() == 0) {
            frame = new ByeControlFrame(this.__currentLocalSynchronizationSource);
        }
    }

    private void validateFeedbackControlFrame(FeedbackControlFrame frame) {
        frame.setPacketSenderSynchronizationSource(this.__currentLocalSynchronizationSource);
        frame.setMediaSourceSynchronizationSource(this.__currentRemoteSynchronizationSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateReportControlFrame(ReportControlFrame frame) {
        if (ArrayExtensions.getLength(frame.getReportBlocks()) > 0) {
            if (this.__maxReceivedPacketIndex == -1L) {
                frame.setReportBlock(null);
            } else {
                for (ReportBlock block : frame.getReportBlocks()) {
                    long num9;
                    long num8;
                    long num7;
                    long packetsReceivedRtp;
                    long num5;
                    long num3;
                    block.setSynchronizationSource(this.__currentRemoteSynchronizationSource);
                    long num = 0L;
                    long num2 = 0L;
                    Object object = this.__receiveCountsLock;
                    synchronized (object) {
                        num = this.__lastSenderReportNtpTimestamp;
                        num2 = this.__lastSenderReportTicks;
                        num3 = this.__maxReceivedPacketIndex;
                        long num4 = this.__minReceivedPacketIndex;
                        num5 = num3 - num4 + 1L;
                        packetsReceivedRtp = this.getPacketsReceivedRtp();
                        num7 = num5 - this.__lastExpectedPacketCount;
                        this.__lastExpectedPacketCount = num5;
                        num8 = packetsReceivedRtp - this.__lastReceivedPacketCount;
                        this.__lastReceivedPacketCount = packetsReceivedRtp;
                        num9 = (long)this.__receiveJitter;
                    }
                    int num10 = (int)(num5 - packetsReceivedRtp);
                    int num11 = (int)(num7 - num8);
                    short num12 = 0;
                    if (num7 != 0L && num11 > 0) {
                        num12 = (short)((long)(num11 << 8) / num7);
                    }
                    long num13 = Binary.fromBytes32(Binary.toBytes64(num, false), 2, false);
                    long num14 = 0L;
                    if (num2 > 0L) {
                        num14 = (long)((double)(DateExtensions.getTicks(DateExtensions.getUtcNow()) - num2) * (65536.0 / (double)Constants.getTicksPerSecond()));
                    }
                    if (block.getFractionLost() == 0) {
                        block.setFractionLost(num12);
                    }
                    if (block.getCumulativeNumberOfPacketsLost() == 0) {
                        block.setCumulativeNumberOfPacketsLost(num10);
                        this.setInboundPacketsLostRtp(num10);
                    }
                    if (block.getExtendedHighestSequenceNumberReceived() == 0L) {
                        block.setExtendedHighestSequenceNumberReceived(num3);
                    }
                    if (block.getInterarrivalJitter() == 0L) {
                        block.setInterarrivalJitter(num9);
                    }
                    if (block.getLastSenderReportTimestamp() == 0L) {
                        block.setLastSenderReportTimestamp(num13);
                    }
                    if (block.getDelaySinceLastSenderReport() != 0L) continue;
                    block.setDelaySinceLastSenderReport(num14);
                }
            }
        }
    }

    private void validateRRControlFrame(RRControlFrame frame) {
        frame.setSynchronizationSource(this.__currentLocalSynchronizationSource);
        this.validateReportControlFrame(frame);
    }

    private void validateSdesControlFrame(SdesControlFrame frame) {
        if (frame.getChunks() != null) {
            for (SdesChunk chunk : frame.getChunks()) {
                chunk.setSynchronizationSource(this.__currentLocalSynchronizationSource);
                if (chunk.getSourceDescriptionItems() == null) continue;
                for (int i = 0; i < ArrayExtensions.getLength(chunk.getSourceDescriptionItems()); ++i) {
                    SdesItem item = chunk.getSourceDescriptionItems()[i];
                    if (item.getType() != SdesItemType.getCanonicalName() || Global.equals(item.getText(), super.getParameters().getCanonicalName())) continue;
                    item = new SdesItem(SdesItemType.getCanonicalName(), super.getParameters().getCanonicalName());
                }
            }
        }
    }

    private void validateSRControlFrame(SRControlFrame frame) {
        Date utcNow = DateExtensions.getUtcNow();
        long packetsSentRtp = this.getPacketsSentRtp();
        long octetsSentRtp = this.getOctetsSentRtp();
        frame.setSynchronizationSource(this.__currentLocalSynchronizationSource);
        if (frame.getNtpTimestamp() == 0L) {
            frame.setNtpTimestamp(NetworkTimeProtocol.dateTimeToNtp(utcNow));
        }
        if (frame.getRtpTimestamp() == 0L) {
            frame.setRtpTimestamp(packetsSentRtp == 0L ? 0L : (long)((double)(DateExtensions.getTicks(utcNow) - this.__firstSendTicks) * this.__sendRtpCyclesPerTick) + (long)this.__startTimeOffset);
        }
        if (frame.getPacketCount() == 0L) {
            frame.setPacketCount(packetsSentRtp);
        }
        if (frame.getOctetCount() == 0L) {
            frame.setOctetCount(octetsSentRtp);
        }
        this.validateReportControlFrame(frame);
    }
}

