/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.DataBuffer;
import fm.icelink.Log;
import fm.icelink.LongHolder;

public class RtpPacket {
    private DataBuffer _buffer;

    public DataBuffer getBuffer() {
        return this._buffer;
    }

    public int getContributingSourceCount() {
        return this.getBuffer().read4(0, 4);
    }

    public long[] getContributingSources() {
        int contributingSourcesOffset = this.getContributingSourcesOffset();
        long[] numArray = new long[this.getContributingSourceCount()];
        for (int i = 0; i < ArrayExtensions.getLength(numArray); ++i) {
            long num3 = 0L;
            LongHolder _var0 = new LongHolder(num3);
            boolean _var1 = this.getBuffer().tryRead32(contributingSourcesOffset, _var0);
            num3 = _var0.getValue();
            if (_var1) {
                contributingSourcesOffset += 4;
            } else {
                Log.error("Could not read contributing source from buffer.");
                return null;
            }
            numArray[i] = num3;
        }
        return numArray;
    }

    public int getContributingSourcesLength() {
        return this.getContributingSourceCount() * 4;
    }

    public int getContributingSourcesOffset() {
        return RtpPacket.getFixedHeaderLength();
    }

    public boolean getExtension() {
        return this.getBuffer().read1(0, 3);
    }

    public static int getFixedHeaderLength() {
        return 12;
    }

    public DataBuffer getHeader() {
        return this.getBuffer().subset(0, this.getHeaderLength());
    }

    public DataBuffer getHeaderExtension() {
        return this.getExtension() ? this.getBuffer().subset(this.getHeaderExtensionOffset() + 4, this.getHeaderExtensionLength()) : DataBuffer.getEmpty();
    }

    public int getHeaderExtensionId() {
        return this.getExtension() ? this.getBuffer().read16(this.getHeaderExtensionOffset()) : 0;
    }

    public int getHeaderExtensionLength() {
        return this.getExtension() ? this.getBuffer().read16(this.getHeaderExtensionOffset() + 1) * 4 : 0;
    }

    public int getHeaderExtensionOffset() {
        return this.getContributingSourcesOffset() + this.getContributingSourcesLength();
    }

    public int getHeaderLength() {
        return RtpPacket.getFixedHeaderLength() + this.getVariableHeaderLength();
    }

    public boolean getMarker() {
        return this.getBuffer().read1(1, 0);
    }

    public boolean getPadding() {
        return this.getBuffer().read1(0, 2);
    }

    public int getPaddingLength() {
        return this.getPadding() ? this.getBuffer().read8(this.getBuffer().getLength() - 1) : 0;
    }

    public DataBuffer getPayload() {
        return this.getPayloadLength() > 0 ? this.getBuffer().subset(this.getPayloadOffset()) : null;
    }

    public int getPayloadLength() {
        return this.getBuffer() == null || this.getBuffer().getLength() - this.getHeaderLength() > 0 ? this.getBuffer().getLength() - this.getHeaderLength() : 0;
    }

    public int getPayloadOffset() {
        return this.getHeaderLength();
    }

    public int getPayloadType() {
        return this.getBuffer().read7(1, 1);
    }

    public int getSequenceNumber() {
        return this.getBuffer().read16(2);
    }

    public static int getSequenceNumberDelta(int sequenceNumber, int lastSequenceNumber) {
        int num = sequenceNumber - lastSequenceNumber;
        if (num < Short.MIN_VALUE) {
            return num + 65536;
        }
        if (num > 32768) {
            num -= 65536;
        }
        return num;
    }

    public long getSynchronizationSource() {
        return this.getBuffer().read32(8);
    }

    public long getTimestamp() {
        return this.getBuffer().read32(4);
    }

    public int getVariableHeaderLength() {
        return this.getContributingSourcesLength() + (this.getExtension() ? 4 + this.getHeaderExtensionLength() : 0);
    }

    public int getVersion() {
        return this.getBuffer().read2(0, 0);
    }

    private void resizeForContributingSources(int newContributingSourceCount) {
        int contributingSourceCount = this.getContributingSourceCount();
        int num2 = newContributingSourceCount * 4;
        int num3 = contributingSourceCount * 4;
        this.getBuffer().resize(this.getBuffer().getLength() + num2 - num3);
        this.setContributingSourceCount(newContributingSourceCount);
    }

    private void resizeForHeaderExtension(boolean newExtension, int newHeaderExtensionLength) {
        boolean extension = this.getExtension();
        int headerExtensionLength = this.getHeaderExtensionLength();
        int num2 = newExtension ? 4 + newHeaderExtensionLength : 0;
        int num3 = extension ? 4 + headerExtensionLength : 0;
        this.getBuffer().resize(this.getBuffer().getLength() + num2 - num3);
        this.setExtension(newExtension);
        if (newExtension) {
            this.setHeaderExtensionLength(newHeaderExtensionLength);
        }
    }

    private void resizeForPayload(int newPayloadLength) {
        int payloadLength = this.getPayloadLength();
        this.getBuffer().resize(this.getPayloadOffset() + newPayloadLength - payloadLength);
    }

    public RtpPacket(DataBuffer payload) {
        this.setBuffer(DataBuffer.allocate(payload.getLength() + RtpPacket.getFixedHeaderLength(), false));
        this.getBuffer().write(payload, RtpPacket.getFixedHeaderLength());
        this.setVersion(2);
    }

    public RtpPacket() {
    }

    private void setBuffer(DataBuffer value) {
        this._buffer = value;
    }

    private void setContributingSourceCount(int value) {
        this.getBuffer().write4(value, 0, 4);
    }

    public void setContributingSources(long[] value) {
        if (value == null) {
            value = new long[]{};
        }
        this.resizeForContributingSources(ArrayExtensions.getLength(value));
        int contributingSourcesOffset = this.getContributingSourcesOffset();
        for (int i = 0; i < ArrayExtensions.getLength(value); ++i) {
            if (this.getBuffer().write32(value[i], contributingSourcesOffset)) {
                contributingSourcesOffset += 4;
                continue;
            }
            Log.error("Could not write contributing source to buffer.");
            break;
        }
    }

    private void setExtension(boolean value) {
        this.getBuffer().write1(value, 0, 3);
    }

    public void setHeaderExtension(DataBuffer value) {
        if (value == null) {
            this.resizeForHeaderExtension(false, 0);
        } else {
            this.resizeForHeaderExtension(true, value.getLength());
            this.getBuffer().write(value, this.getHeaderExtensionOffset() + 4);
        }
    }

    public void setHeaderExtensionId(int value) {
        this.resizeForHeaderExtension(true, this.getHeaderExtensionLength());
        this.getBuffer().write16(value, this.getHeaderExtensionOffset());
    }

    private void setHeaderExtensionLength(int value) {
        this.getBuffer().write16(value / 4, this.getHeaderExtensionOffset() + 1);
    }

    public void setMarker(boolean value) {
        this.getBuffer().write1(value, 1, 0);
    }

    public void setPadding(boolean value) {
        this.getBuffer().write1(value, 0, 2);
    }

    private void setPaddingLength(int value) {
        this.setPadding(value > 0);
        for (int i = 0; i < value; ++i) {
            this.getBuffer().write8(BitAssistant.castByte(i < value - 1 ? 0 : value), this.getBuffer().getLength() - value + i);
        }
    }

    public void setPayload(DataBuffer value) {
        if (value.getLength() > this.getBuffer().getLength()) {
            DataBuffer header = this.getHeader();
            this.setPayload(value);
            this.setBuffer(value.clone());
            this.getBuffer().prepend(header);
        } else if (this.getBuffer().getLength() == this.getHeaderLength()) {
            this.getBuffer().append(this.getPayload());
        } else {
            if (this.getHeaderLength() + value.getLength() > this.getBuffer().getLength()) {
                this.getBuffer().resize(this.getHeaderLength() + value.getLength());
            }
            this.getBuffer().write(value, this.getHeaderLength());
        }
    }

    public void setPayloadType(int value) {
        this.getBuffer().write7(value, 1, 1);
    }

    public void setSequenceNumber(int value) {
        this.getBuffer().write16(value, 2);
    }

    public void setSynchronizationSource(long value) {
        this.getBuffer().write32(value, 8);
    }

    public void setTimestamp(long value) {
        this.getBuffer().write32(value, 4);
    }

    public void setVersion(int value) {
        this.getBuffer().write2(value, 0, 0);
    }

    public static void test() {
    }

    public static RtpPacket wrap(DataBuffer buffer) {
        if (buffer.getLength() < RtpPacket.getFixedHeaderLength()) {
            return null;
        }
        RtpPacket packet2 = new RtpPacket();
        packet2.setBuffer(buffer);
        RtpPacket packet = packet2;
        if (packet.getVersion() != 2) {
            return null;
        }
        if (packet.getPayloadType() >= 72 && packet.getPayloadType() <= 85) {
            return null;
        }
        if (packet.getContributingSourcesLength() > buffer.getLength()) {
            return null;
        }
        if (packet.getHeaderExtensionLength() > buffer.getLength()) {
            return null;
        }
        if (packet.getHeaderLength() > buffer.getLength()) {
            return null;
        }
        return packet;
    }
}

