/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Architecture;
import fm.icelink.IPlatform;
import fm.icelink.OperatingSystem;
import fm.icelink.SourceLanguage;

public class Platform
implements IPlatform {
    private static boolean _isAndroid = false;
    private static OperatingSystem _os = OperatingSystem.Unknown;
    private static Architecture _arch = Architecture.Unknown;
    private static SourceLanguage _language = SourceLanguage.Java;
    private static IPlatform _instance = null;

    public static IPlatform getInstance() {
        return _instance;
    }

    @Override
    public boolean getIsMobile() {
        return _isAndroid;
    }

    @Override
    public boolean getIsLittleEndian() {
        return false;
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        if (_isAndroid) {
            return OperatingSystem.Android;
        }
        if (_os == OperatingSystem.Unknown) {
            String os = System.getProperty("os.name").toLowerCase();
            _os = os.indexOf("win") >= 0 ? OperatingSystem.Windows : (os.indexOf("mac") >= 0 ? OperatingSystem.MacOS : OperatingSystem.Linux);
        }
        return _os;
    }

    @Override
    public String getDirectorySeparator() {
        return this.getOperatingSystem() == OperatingSystem.Windows ? "\\" : "/";
    }

    @Override
    public SourceLanguage getSourceLanguage() {
        return _language;
    }

    @Override
    public Architecture getArchitecture() {
        if (_arch == Architecture.Unknown) {
            String arch = System.getProperty("os.arch");
            if (arch.equals("i386") || arch.equals("x86") || arch.equals("i686")) {
                _arch = Architecture.X86;
            } else if (arch.equals("x86_64") || arch.equals("amd64")) {
                _arch = Architecture.X64;
            } else if (arch.equals("armeabi-v7a") || arch.equals("armv7l")) {
                _arch = Architecture.Armv7;
            } else if (arch.equals("aarch32")) {
                _arch = Architecture.Armv8;
            } else if (arch.equals("arm64-v8a") || arch.equals("aarch64")) {
                _arch = Architecture.Arm64;
            }
        }
        return _arch;
    }

    static {
        try {
            Class.forName("java.awt.image.BufferedImage");
        }
        catch (ClassNotFoundException ex) {
            _isAndroid = true;
        }
        _instance = new Platform();
    }
}

