/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Constants;
import fm.icelink.DateExtensions;
import fm.icelink.GenericNack;
import fm.icelink.GenericNackControlFrame;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IFunction1;
import fm.icelink.LongExtensions;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFrame;
import fm.icelink.ParseAssistant;
import java.util.ArrayList;
import java.util.HashMap;

class NackBuffer<TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>> {
    private TFrame[] __frameBuffer;
    private long __highestPacketIndex = 0L;
    private HashMap<String, String> __recentNackedPacketIndexes;
    private ArrayList<String> __recentTimestampsUsedToNack;
    private int _length;
    private String _name;
    private int _retransmissionTimeout;

    private TFrame getFrame(long packetIndex) {
        int index = (int)(packetIndex % (long)ArrayExtensions.getLength(this.__frameBuffer));
        TFrame local = this.__frameBuffer[index];
        if (local != null && ((MediaBuffer)((MediaFrame)local).getBuffer()).getSequenceNumber() == packetIndex) {
            return local;
        }
        return null;
    }

    public int getLength() {
        return this._length;
    }

    public String getName() {
        return this._name;
    }

    public int getRetransmissionTimeout() {
        return this._retransmissionTimeout;
    }

    public NackBuffer(String name, int size, IFunction1<Integer, TFrame[]> createArrayCallback) {
        this.setRetransmissionTimeout(50);
        this.setName(name);
        this.setLength(size);
        this.__frameBuffer = (MediaFrame[])createArrayCallback.invoke(size);
        this.__recentTimestampsUsedToNack = new ArrayList();
        this.__recentNackedPacketIndexes = new HashMap();
    }

    public TFrame read(long sequenceNumber, int rtpSequenceNumber, long lastWrittenTimestamp, Holder<GenericNackControlFrame> genericNack) {
        long num3;
        long num2;
        if (sequenceNumber > this.__highestPacketIndex) {
            genericNack.setValue(null);
            return null;
        }
        long num = DateExtensions.getTicks(DateExtensions.getUtcNow()) / (long)Constants.getTicksPerMillisecond();
        String key = LongExtensions.toString(sequenceNumber);
        TFrame frame = this.getFrame(sequenceNumber);
        if (frame != null) {
            this.__recentTimestampsUsedToNack.remove(LongExtensions.toString(((MediaFrame)frame).getTimestamp()));
            HashMapExtensions.remove(this.__recentNackedPacketIndexes, key);
            genericNack.setValue(null);
            return frame;
        }
        if (this.__recentNackedPacketIndexes.containsKey(key) && (num2 = ParseAssistant.parseLongValue(HashMapExtensions.getItem(this.__recentNackedPacketIndexes).get(key))) > 0L && (num3 = num - num2) < (long)this.getRetransmissionTimeout()) {
            genericNack.setValue(null);
            return null;
        }
        if (lastWrittenTimestamp != -1L) {
            String item = LongExtensions.toString(lastWrittenTimestamp);
            if (this.__recentTimestampsUsedToNack.contains(item)) {
                genericNack.setValue(null);
                return null;
            }
            this.__recentTimestampsUsedToNack.add(item);
        }
        long num4 = this.__highestPacketIndex - sequenceNumber;
        GenericNack nack = new GenericNack();
        nack.setPacketId(rtpSequenceNumber);
        for (int i = 1; i <= 16; ++i) {
            if (num4 <= (long)i) continue;
            nack.setLostPacketIdPlus(i, this.getFrame(sequenceNumber + (long)i) == null);
        }
        if (!this.__recentNackedPacketIndexes.containsKey(key)) {
            HashMapExtensions.add(this.__recentNackedPacketIndexes, key, LongExtensions.toString(num));
        }
        genericNack.setValue(new GenericNackControlFrame(nack));
        return null;
    }

    private void setLength(int value) {
        this._length = value;
    }

    private void setName(String value) {
        this._name = value;
    }

    public void setRetransmissionTimeout(int value) {
        this._retransmissionTimeout = value;
    }

    public boolean write(TFrame frame) {
        if (!((MediaFormat)((MediaBuffer)((MediaFrame)frame).getBuffer()).getFormat()).getIsPacketized()) {
            throw new RuntimeException(new Exception("The first buffer of a frame stored to be stored in a Nack.Buffer must have a packetized format."));
        }
        if (ArrayExtensions.getLength(((MediaBuffer)((MediaFrame)frame).getBuffer()).getDataBuffers()) != 1) {
            throw new RuntimeException(new Exception("Nack.Buffer only supports a Frame.Buffer.DataBuffers.Length of one."));
        }
        int index = (int)(((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber() % (long)ArrayExtensions.getLength(this.__frameBuffer));
        TFrame local = this.__frameBuffer[index];
        if (local != null && ((MediaFrame)local).getTimestamp() > ((MediaFrame)frame).getTimestamp()) {
            return false;
        }
        this.__frameBuffer[index] = frame;
        this.__highestPacketIndex = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber();
        return true;
    }
}

