/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.Dynamic;
import fm.icelink.IFunction1;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaSink;
import fm.icelink.IMediaSource;
import fm.icelink.MediaBranch;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFrame;
import fm.icelink.MediaPipe;
import fm.icelink.MediaSink;
import fm.icelink.MediaSinkCollection;
import fm.icelink.MediaSource;
import fm.icelink.MediaSourceCollection;
import fm.icelink.MediaTrackBase;
import fm.icelink.Utility;
import java.util.ArrayList;

public abstract class MediaTrack<TISource extends IMediaSource<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>, TISourceCollection extends MediaSourceCollection<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat, TISourceCollection>, TISink extends IMediaSink<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>, TISinkCollection extends MediaSinkCollection<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat, TISinkCollection>, TIElement extends IMediaElement, TSource extends MediaSource<TISource, TISink, TISinkCollection, TSource, TFrame, TBuffer, TBufferCollection, TFormat>, TSink extends MediaSink<TISource, TISourceCollection, TISink, TSink, TFrame, TBuffer, TBufferCollection, TFormat>, TPipe extends MediaPipe<TISource, TISourceCollection, TISink, TISinkCollection, TPipe, TFrame, TBuffer, TBufferCollection, TFormat>, TTrack extends MediaTrack<TISource, TISourceCollection, TISink, TISinkCollection, TIElement, TSource, TSink, TPipe, TTrack, TBranch, TFrame, TBuffer, TBufferCollection, TFormat>, TBranch extends MediaBranch<TISource, TISourceCollection, TISink, TISinkCollection, TIElement, TSource, TSink, TPipe, TTrack, TBranch, TFrame, TBuffer, TBufferCollection, TFormat>, TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>>
extends MediaTrackBase {
    private ArrayList<TIElement> __elements = new ArrayList();

    private void addSinkToBranch(TBranch branch, TISink sink) {
        for (MediaTrack local : branch.getTracks()) {
            if (local == null || local.getIsTerminated() || local.getIsEmpty()) continue;
            if (local.getIsBranched()) {
                this.addSinkToBranch((MediaBranch)local.getLastElement(), sink);
                continue;
            }
            ((IMediaSource)local.getLastElement()).addSink(sink);
        }
    }

    protected abstract TIElement[] arrayFromElements(ArrayList<TIElement> var1);

    protected abstract TISink[] arrayFromSinks(ArrayList<TISink> var1);

    protected abstract TISource[] arrayFromSources(ArrayList<TISource> var1);

    protected abstract TBranch branchFromTracks(TTrack[] var1);

    public void destroy() {
        for (IMediaElement local : this.getElements()) {
            if (this.isSource(local)) {
                ((MediaSource)local).destroy();
                continue;
            }
            if (this.isPipe(local)) {
                ((MediaPipe)local).destroy();
                continue;
            }
            if (this.isSink(local)) {
                ((MediaSink)local).destroy();
                continue;
            }
            if (!this.isBranch(local)) continue;
            ((MediaBranch)local).destroy();
        }
    }

    public TIElement findElement(IFunction1<TIElement, Boolean> where, boolean recurse) {
        ArrayList<TIElement> list = this.findElements(where, recurse);
        if (ArrayListExtensions.getCount(list) == 0) {
            return null;
        }
        return (TIElement)((IMediaElement)ArrayListExtensions.getItem(list).get(0));
    }

    public TIElement findElement(IFunction1<TIElement, Boolean> where) {
        return this.findElement(where, true);
    }

    public ArrayList<TIElement> findElements(IFunction1<TIElement, Boolean> where) {
        return this.findElements(where, true);
    }

    public ArrayList<TIElement> findElements(IFunction1<TIElement, Boolean> where, boolean recurse) {
        ArrayList<IMediaElement> list = new ArrayList<IMediaElement>();
        for (IMediaElement local : this.getElements()) {
            if (where.invoke(local).booleanValue()) {
                list.add(local);
            }
            if (!recurse || !this.isBranch(local)) continue;
            MediaBranch local3 = (MediaBranch)local;
            for (MediaTrack local2 : local3.getTracks()) {
                ArrayListExtensions.addRange(list, local2.findElements(where, recurse));
            }
        }
        return list;
    }

    public TIElement[] getElements() {
        return this.arrayFromElements(this.__elements);
    }

    public TIElement getFirstElement() {
        return (TIElement)((IMediaElement)Utility.firstOrDefault(this.__elements));
    }

    public TISink getInput() {
        Object[] inputs = this.getInputs();
        if (ArrayExtensions.getLength(inputs) == 0) {
            return null;
        }
        return (TISink)inputs[0];
    }

    public TISink[] getInputs() {
        ArrayList<Dynamic> sinks = new ArrayList<Dynamic>();
        if (this.isPipe(this.getFirstElement())) {
            sinks.add((MediaPipe)this.getFirstElement());
        } else if (this.isSink(this.getFirstElement())) {
            sinks.add((MediaSink)this.getFirstElement());
        } else if (this.isBranch(this.getFirstElement())) {
            MediaBranch firstElement = (MediaBranch)this.getFirstElement();
            for (MediaTrack local2 : firstElement.getTracks()) {
                if (local2 == null) continue;
                ArrayListExtensions.addRange(sinks, local2.getInputs());
            }
        }
        return this.arrayFromSinks(sinks);
    }

    public boolean getIsBranched() {
        return !this.getIsEmpty() && this.isBranch(this.getLastElement());
    }

    public boolean getIsEmpty() {
        return this.getFirstElement() == null;
    }

    public boolean getIsTerminated() {
        return !this.getIsEmpty() && this.isSink(this.getLastElement());
    }

    public TIElement getLastElement() {
        return (TIElement)((IMediaElement)Utility.lastOrDefault(this.__elements));
    }

    @Override
    public boolean getMuted() {
        for (IMediaElement local : this.getElements()) {
            MediaBranch local5;
            MediaSink local4;
            MediaPipe local3;
            MediaSource local2;
            if (!(this.isSource(local) ? (local2 = (MediaSource)local).getMuted() : (this.isPipe(local) ? (local3 = (MediaPipe)local).getMuted() : (this.isSink(local) ? (local4 = (MediaSink)local).getMuted() : this.isBranch(local) && (local5 = (MediaBranch)local).getMuted())))) continue;
            return true;
        }
        return false;
    }

    public TISource getOutput() {
        Object[] outputs = this.getOutputs();
        if (ArrayExtensions.getLength(outputs) == 0) {
            return null;
        }
        return (TISource)outputs[0];
    }

    public TISource[] getOutputs() {
        ArrayList<Dynamic> sources = new ArrayList<Dynamic>();
        if (this.isPipe(this.getLastElement())) {
            sources.add((MediaPipe)this.getLastElement());
        } else if (this.isSource(this.getLastElement())) {
            sources.add((MediaSource)this.getLastElement());
        } else if (this.isBranch(this.getLastElement())) {
            MediaBranch lastElement = (MediaBranch)this.getLastElement();
            for (MediaTrack local2 : lastElement.getTracks()) {
                if (local2 == null) continue;
                ArrayListExtensions.addRange(sources, local2.getOutputs());
            }
        }
        return this.arrayFromSources(sources);
    }

    public TSink getSink() {
        if (this.isSink(this.getLastElement()) || this.isPipe(this.getLastElement())) {
            return (TSink)((MediaSink)this.getLastElement());
        }
        return null;
    }

    public TSource getSource() {
        if (this.isSource(this.getFirstElement()) || this.isPipe(this.getFirstElement())) {
            return (TSource)((MediaSource)this.getFirstElement());
        }
        return null;
    }

    protected abstract boolean isBranch(TIElement var1);

    protected abstract boolean isPipe(TIElement var1);

    protected abstract boolean isSink(TIElement var1);

    protected abstract boolean isSource(TIElement var1);

    protected abstract boolean isStream(TIElement var1);

    public MediaTrack(TIElement element) {
        if (element != null) {
            this.__elements.add(element);
        }
    }

    public TTrack next(TISink next) {
        if (next != null) {
            if (this.isStream(next)) {
                throw new RuntimeException(new Exception("A stream cannot belong to a media track."));
            }
            if (this.getIsTerminated()) {
                throw new RuntimeException(new Exception("Cannot add to a terminated track."));
            }
            if (!this.getIsEmpty()) {
                if (this.getIsBranched()) {
                    this.addSinkToBranch((MediaBranch)this.getLastElement(), next);
                } else {
                    ((IMediaSource)this.getLastElement()).addSink(next);
                }
            }
            this.__elements.add(next);
        }
        return (TTrack)this;
    }

    public TTrack next(TBranch branch) {
        if (branch != null) {
            if (this.getIsBranched()) {
                throw new RuntimeException(new Exception("Cannot branch a branched track. Try merging first."));
            }
            if (this.getIsTerminated()) {
                throw new RuntimeException(new Exception("Cannot branch a terminated track."));
            }
            if (!this.getIsEmpty()) {
                for (MediaTrack local : branch.getTracks()) {
                    if (local == null || local.getIsEmpty()) continue;
                    ((IMediaSource)this.getLastElement()).addSink((IMediaSink)local.getFirstElement());
                }
            }
            this.__elements.add(branch);
        }
        return (TTrack)this;
    }

    public TTrack next(TTrack[] tracks) {
        return this.next((TBranch)this.branchFromTracks((MediaTrack[])tracks));
    }

    @Override
    public void setMuted(boolean value) {
        for (IMediaElement local : this.getElements()) {
            if (this.isSource(local)) {
                MediaSource local2 = (MediaSource)local;
                local2.setMuted(value);
                continue;
            }
            if (this.isPipe(local)) {
                MediaPipe local3 = (MediaPipe)local;
                local3.setMuted(value);
                continue;
            }
            if (this.isSink(local)) {
                MediaSink local4 = (MediaSink)local;
                local4.setMuted(value);
                continue;
            }
            if (!this.isBranch(local)) continue;
            MediaBranch local5 = (MediaBranch)local;
            local5.setMuted(value);
        }
    }
}

