/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Global;
import fm.icelink.Stream;
import fm.icelink.StreamDirection;
import fm.icelink.StreamType;

public abstract class MediaStreamBase
extends Stream {
    private StreamDirection __pendingLocalDirection;
    private StreamDirection _localDirection;
    private StreamDirection _remoteDirection;
    private Object _renegotiationLock = new Object();
    private boolean _renegotiationPending;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Error changeDirection(StreamDirection newDirection) {
        String message = "An attempt has been made to modify exisiting media stream direction; however, existing stream capabilities do not support a new setting.";
        if (Global.equals((Object)this.getDirectionCapabilities(), (Object)StreamDirection.Inactive) ? !Global.equals((Object)newDirection, (Object)StreamDirection.Inactive) : (Global.equals((Object)this.getDirectionCapabilities(), (Object)StreamDirection.SendOnly) ? !Global.equals((Object)newDirection, (Object)StreamDirection.Inactive) && !Global.equals((Object)newDirection, (Object)StreamDirection.SendOnly) : Global.equals((Object)this.getDirectionCapabilities(), (Object)StreamDirection.ReceiveOnly) && !Global.equals((Object)newDirection, (Object)StreamDirection.Inactive) && !Global.equals((Object)newDirection, (Object)StreamDirection.ReceiveOnly))) {
            return new Error(ErrorCode.InvalidStreamDirectionChange, new Exception(message));
        }
        Object object = this._renegotiationLock;
        synchronized (object) {
            this.setPendingLocalDirection(newDirection);
            this.setRenegotiationPending(true);
        }
        return null;
    }

    @Override
    public StreamDirection getDirection() {
        if (Global.equals((Object)this.getLocalDirection(), (Object)StreamDirection.SendReceive)) {
            if (Global.equals((Object)this.getRemoteDirection(), (Object)StreamDirection.ReceiveOnly)) {
                return StreamDirection.SendOnly;
            }
            if (Global.equals((Object)this.getRemoteDirection(), (Object)StreamDirection.SendOnly)) {
                return StreamDirection.ReceiveOnly;
            }
            return this.getRemoteDirection();
        }
        if (Global.equals((Object)this.getLocalDirection(), (Object)StreamDirection.SendOnly)) {
            if (Global.equals((Object)this.getRemoteDirection(), (Object)StreamDirection.Inactive) || Global.equals((Object)this.getRemoteDirection(), (Object)StreamDirection.SendOnly)) {
                return StreamDirection.Inactive;
            }
            return this.getLocalDirection();
        }
        if (Global.equals((Object)this.getLocalDirection(), (Object)StreamDirection.ReceiveOnly)) {
            if (Global.equals((Object)this.getRemoteDirection(), (Object)StreamDirection.Inactive) || Global.equals((Object)this.getRemoteDirection(), (Object)StreamDirection.ReceiveOnly)) {
                return StreamDirection.Inactive;
            }
            return this.getLocalDirection();
        }
        return StreamDirection.Inactive;
    }

    @Override
    public String getLabel() {
        StreamType _var0 = super.getType();
        if (_var0 == StreamType.Audio) {
            return "Audio Stream";
        }
        if (_var0 == StreamType.Video) {
            return "Video Stream";
        }
        if (_var0 == StreamType.Application) {
            return "Application Stream";
        }
        if (_var0 == StreamType.Message) {
            return "Message Stream";
        }
        if (_var0 == StreamType.Text) {
            return "Text Stream";
        }
        return "Unknown Stream";
    }

    @Override
    public StreamDirection getLocalDirection() {
        return this._localDirection;
    }

    protected StreamDirection getPendingLocalDirection() {
        return this.__pendingLocalDirection;
    }

    @Override
    protected StreamDirection getRemoteDirection() {
        return this._remoteDirection;
    }

    protected boolean getRenegotiationPending() {
        return this._renegotiationPending;
    }

    public MediaStreamBase(StreamType type) {
        super(type);
        this.__pendingLocalDirection = StreamDirection.Inactive;
        this.setLocalDirection(StreamDirection.Unset);
        this.setRemoteDirection(StreamDirection.Unset);
    }

    @Override
    public void setLocalDirection(StreamDirection value) {
        this._localDirection = value;
    }

    protected void setPendingLocalDirection(StreamDirection value) {
        this.__pendingLocalDirection = value;
    }

    @Override
    protected void setRemoteDirection(StreamDirection value) {
        this._remoteDirection = value;
    }

    protected void setRenegotiationPending(boolean value) {
        this._renegotiationPending = value;
    }
}

