/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum MediaSourceState {
    New(1),
    Starting(2),
    Started(3),
    Stopping(4),
    Stopped(5),
    Destroying(6),
    Destroyed(7);

    private final int value;
    private static final Map<Integer, MediaSourceState> lookup;

    private MediaSourceState(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static MediaSourceState getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, MediaSourceState>();
        for (MediaSourceState s : EnumSet.allOf(MediaSourceState.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

