/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Collection;
import fm.icelink.Dynamic;
import fm.icelink.Error;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IElement;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaSink;
import fm.icelink.IMediaSource;
import fm.icelink.ISink;
import fm.icelink.ISource;
import fm.icelink.JsonSerializer;
import fm.icelink.License;
import fm.icelink.Log;
import fm.icelink.ManagedThread;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaControlFrame;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFrame;
import fm.icelink.MediaPipeState;
import fm.icelink.MediaSinkCollection;
import fm.icelink.MediaSourceCollection;
import fm.icelink.Stream;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.MediaDescription;
import java.util.ArrayList;
import java.util.List;

public abstract class MediaPipe<TISource extends IMediaSource<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>, TISourceCollection extends MediaSourceCollection<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat, TISourceCollection>, TISink extends IMediaSink<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>, TISinkCollection extends MediaSinkCollection<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat, TISinkCollection>, TPipe extends MediaPipe<TISource, TISourceCollection, TISink, TISinkCollection, TPipe, TFrame, TBuffer, TBufferCollection, TFormat>, TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>>
extends Dynamic
implements IMediaSource<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>,
ISource<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>,
IMediaSink<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>,
ISink<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>,
IMediaElement,
IElement {
    private boolean __disabled = true;
    private List<IAction1<TPipe>> __onDisabledChange = new ArrayList<IAction1<TPipe>>();
    private List<IAction1<MediaControlFrame[]>> __onProcessControlFrames = new ArrayList<IAction1<MediaControlFrame[]>>();
    private List<IAction1<TFrame>> __onProcessFrame = new ArrayList<IAction1<TFrame>>();
    private List<IAction1<MediaControlFrame[]>> __onRaiseControlFrames = new ArrayList<IAction1<MediaControlFrame[]>>();
    private List<IAction1<TFrame>> __onRaiseFrame = new ArrayList<IAction1<TFrame>>();
    private List<IAction1<TPipe>> __onStateChange = new ArrayList<IAction1<TPipe>>();
    private volatile boolean __processingControlFrames = false;
    private volatile boolean __processingFrame = false;
    private volatile boolean __raisingControlFrames = false;
    private volatile boolean __raisingFrame = false;
    private TISinkCollection __sinks;
    private TISourceCollection __sources;
    private MediaPipeState __state;
    private Object __stateLock;
    private String _id;
    private TFormat _inputFormat;
    private boolean _muted;
    private IAction1<TPipe> _onDisabledChange = new IAction1<TPipe>(){

        @Override
        public void invoke(TPipe p0) {
            for (IAction1 action : new ArrayList(MediaPipe.this.__onDisabledChange)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<MediaControlFrame[]> _onProcessControlFrames = new IAction1<MediaControlFrame[]>(){

        @Override
        public void invoke(MediaControlFrame[] p0) {
            for (IAction1 action : new ArrayList(MediaPipe.this.__onProcessControlFrames)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<TFrame> _onProcessFrame = new IAction1<TFrame>(){

        @Override
        public void invoke(TFrame p0) {
            for (IAction1 action : new ArrayList(MediaPipe.this.__onProcessFrame)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<MediaControlFrame[]> _onRaiseControlFrames = new IAction1<MediaControlFrame[]>(){

        @Override
        public void invoke(MediaControlFrame[] p0) {
            for (IAction1 action : new ArrayList(MediaPipe.this.__onRaiseControlFrames)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<TFrame> _onRaiseFrame = new IAction1<TFrame>(){

        @Override
        public void invoke(TFrame p0) {
            for (IAction1 action : new ArrayList(MediaPipe.this.__onRaiseFrame)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<TPipe> _onStateChange = new IAction1<TPipe>(){

        @Override
        public void invoke(TPipe p0) {
            for (IAction1 action : new ArrayList(MediaPipe.this.__onStateChange)) {
                action.invoke(p0);
            }
        }
    };
    private TFormat _outputFormat;
    private String _tag;

    public void addOnDisabledChange(IAction1<TPipe> value) {
        this.__onDisabledChange.add(value);
    }

    @Override
    public void addOnProcessControlFrames(IAction1<MediaControlFrame[]> value) {
        this.__onProcessControlFrames.add(value);
    }

    @Override
    public void addOnProcessFrame(IAction1<TFrame> value) {
        this.__onProcessFrame.add(value);
    }

    public void addOnRaiseControlFrames(IAction1<MediaControlFrame[]> value) {
        this.__onRaiseControlFrames.add(value);
    }

    public void addOnRaiseFrame(IAction1<TFrame> value) {
        this.__onRaiseFrame.add(value);
    }

    public void addOnStateChange(IAction1<TPipe> value) {
        this.__onStateChange.add(value);
    }

    @Override
    public void addSink(TISink sink) {
        this.validateSink(sink);
        ((Collection)this.__sinks).add(sink);
    }

    @Override
    public void addSinks(TISink[] sinks) {
        for (TISink local : sinks) {
            this.validateSink(local);
        }
        ((Collection)this.__sinks).addMany(sinks);
    }

    @Override
    public void addSource(TISource source) {
        if (source != null) {
            this.validateSource(source);
            ((Collection)this.__sources).add(source);
        }
    }

    @Override
    public void addSources(TISource[] sources) {
        for (TISource local : sources) {
            this.validateSource(local);
        }
        ((Collection)this.__sources).addMany(sources);
    }

    protected abstract TISinkCollection createSinkCollection(TISource var1);

    protected abstract TISourceCollection createSourceCollection(TISink var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroy() {
        MediaPipeState state;
        Object obj2;
        Object object = obj2 = this.__stateLock;
        synchronized (object) {
            MediaPipeState _var0 = this.getState();
            if (_var0 == MediaPipeState.Destroying) {
                throw new RuntimeException(new Exception("A media pipe cannot be destroyed while it is being destroyed on a different thread."));
            }
            if (_var0 == MediaPipeState.Destroyed) {
                return true;
            }
            state = this.getState();
            this.setState(MediaPipeState.Destroying);
        }
        Log.debug(StringExtensions.format("Media pipe ({0}) is being destroyed.", this.getLabel()));
        while (this.__processingFrame || this.__processingControlFrames || this.__raisingFrame || this.__raisingControlFrames) {
            ManagedThread.sleep(10);
        }
        try {
            this.doDestroy();
            object = obj2 = this.__stateLock;
            synchronized (object) {
                this.setState(MediaPipeState.Destroyed);
            }
            ((MediaSourceCollection)this.__sources).destroy();
            ((MediaSinkCollection)this.__sinks).destroy();
            return true;
        }
        catch (Exception obj1) {
            Object object2 = obj2 = this.__stateLock;
            synchronized (object2) {
                this.setState(state);
            }
            return false;
        }
    }

    protected abstract void doDestroy();

    protected void doProcessControlFrames(MediaControlFrame[] controlFrames) {
    }

    protected abstract void doProcessFrame(TFrame var1, TBuffer var2);

    protected Error doProcessSdpMediaDescription(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        return null;
    }

    @Override
    public boolean getDisabled() {
        boolean flag = true;
        for (IMediaSink local : this.getSinks()) {
            TFormat inputFormat = local.getInputFormat();
            if (local.getDisabled() || inputFormat == null || !((MediaFormat)inputFormat).isEquivalent(this.getOutputFormat())) continue;
            flag = false;
            break;
        }
        if (!Global.equals(this.__disabled, flag)) {
            this.__disabled = flag;
            IAction1<TPipe> onDisabledChange = this._onDisabledChange;
            if (onDisabledChange != null) {
                onDisabledChange.invoke(this);
            }
        }
        return flag;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public TFormat getInputFormat() {
        return this._inputFormat;
    }

    @Override
    public abstract String getLabel();

    public boolean getMuted() {
        return this._muted;
    }

    @Override
    public TFormat getOutputFormat() {
        return this._outputFormat;
    }

    @Override
    public String getPipelineJson() {
        return StringExtensions.concat(new String[]{"{ ", this.getPipelineJsonBase(), ", ", this.getPipelineJsonSources(), ", ", this.getPipelineJsonSinks(), " }"});
    }

    protected String getPipelineJsonBase() {
        return StringExtensions.concat(new String[]{this.getPipelineJsonId(), ", ", this.getPipelineJsonLabel(), ", ", this.getPipelineJsonTag(), ", ", this.getPipelineJsonDisabled(), ", ", this.getPipelineJsonInput(), ", ", this.getPipelineJsonOutput()});
    }

    private String getPipelineJsonDisabled() {
        return StringExtensions.concat("\"disabled\": ", this.getDisabled() ? "true" : "false");
    }

    @Override
    public String getPipelineJsonFromSink() {
        return StringExtensions.concat(new String[]{"{ ", this.getPipelineJsonBase(), ", ", this.getPipelineJsonSources(), " }"});
    }

    @Override
    public String getPipelineJsonFromSource() {
        return StringExtensions.concat(new String[]{"{ ", this.getPipelineJsonBase(), ", ", this.getPipelineJsonSinks(), " }"});
    }

    private String getPipelineJsonId() {
        return StringExtensions.concat("\"id\": ", JsonSerializer.serializeString(this.getId()));
    }

    private String getPipelineJsonInput() {
        return StringExtensions.concat("\"input\": ", this.getInputFormat() == null ? "null" : JsonSerializer.serializeString(((MediaFormat)this.getInputFormat()).toString()));
    }

    private String getPipelineJsonLabel() {
        return StringExtensions.concat("\"label\": ", JsonSerializer.serializeString(this.getLabel()));
    }

    private String getPipelineJsonOutput() {
        return StringExtensions.concat("\"output\": ", this.getOutputFormat() == null ? "null" : JsonSerializer.serializeString(((MediaFormat)this.getOutputFormat()).toString()));
    }

    private String getPipelineJsonSinks() {
        ArrayList<String> list = new ArrayList<String>();
        for (IMediaSink local : this.getSinks()) {
            list.add(local.getPipelineJsonFromSource());
        }
        return StringExtensions.concat("\"sinks\": [", StringExtensions.join(", ", list.toArray(new String[0])), "]");
    }

    private String getPipelineJsonSources() {
        ArrayList<String> list = new ArrayList<String>();
        for (IMediaSource local : this.getSources()) {
            list.add(local.getPipelineJsonFromSink());
        }
        return StringExtensions.concat("\"sources\": [", StringExtensions.join(", ", list.toArray(new String[0])), "]");
    }

    private String getPipelineJsonTag() {
        return StringExtensions.concat("\"tag\": ", JsonSerializer.serializeString(this.getTag()));
    }

    @Override
    public TISink getSink() {
        return (TISink)((IMediaSink)((Collection)this.__sinks).getValue());
    }

    @Override
    public TISink[] getSinks() {
        return (IMediaSink[])((Collection)this.__sinks).getValues();
    }

    @Override
    public TISource getSource() {
        return (TISource)((IMediaSource)((Collection)this.__sources).getValue());
    }

    @Override
    public TISource[] getSources() {
        return (IMediaSource[])((Collection)this.__sources).getValues();
    }

    public MediaPipeState getState() {
        return this.__state;
    }

    public String getTag() {
        return this._tag;
    }

    public boolean hasSink(TISink sink) {
        for (IMediaSink local : this.getSinks()) {
            if (local != sink) continue;
            return true;
        }
        return false;
    }

    public boolean hasSource(TISource source) {
        for (IMediaSource local : this.getSources()) {
            if (local != source) continue;
            return true;
        }
        return false;
    }

    public MediaPipe(TFormat inputFormat, TFormat outputFormat) {
        this.__state = MediaPipeState.Initialized;
        this.__stateLock = new Object();
        License.checkKey();
        this.setId(Guid.newGuid().toString().replace("-", ""));
        this.setInputFormat(inputFormat);
        this.setOutputFormat(outputFormat);
        this.__sinks = this.createSinkCollection(this);
        this.__sources = this.createSourceCollection(this);
    }

    public MediaPipe(TFormat outputFormat) {
        this(null, outputFormat);
    }

    @Override
    public void processControlFrames(MediaControlFrame[] controlFrames) {
        if (Global.equals((Object)this.__state, (Object)MediaPipeState.Initialized)) {
            this.__processingControlFrames = true;
            try {
                if (Global.equals((Object)this.__state, (Object)MediaPipeState.Initialized)) {
                    IAction1<MediaControlFrame[]> onProcessControlFrames = this._onProcessControlFrames;
                    if (onProcessControlFrames != null) {
                        onProcessControlFrames.invoke(controlFrames);
                    }
                    this.doProcessControlFrames(controlFrames);
                }
            }
            catch (Exception exception) {
                Log.error(StringExtensions.format("Media pipe ({0}) could not process control frames.", this.getLabel()), exception);
            }
            finally {
                this.__processingControlFrames = false;
            }
        }
        this.raiseControlFrames(controlFrames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processFrame(TFrame frame) {
        if (Global.equals((Object)this.__state, (Object)MediaPipeState.Initialized)) {
            this.__processingFrame = true;
            try {
                Object buffer22;
                if (Global.equals((Object)this.__state, (Object)MediaPipeState.Initialized) && (buffer22 = ((MediaFrame)frame).getBuffer(this.getInputFormat())) != null) {
                    IAction1<TFrame> onProcessFrame;
                    if (StringExtensions.isNullOrEmpty(((MediaBuffer)buffer22).getSourceId())) {
                        ((MediaBuffer)buffer22).setSourceId(this.getId());
                    }
                    if (this.getMuted()) {
                        ((MediaBuffer)buffer22).mute();
                    }
                    if ((onProcessFrame = this._onProcessFrame) != null) {
                        onProcessFrame.invoke(frame);
                    }
                    this.doProcessFrame(frame, buffer22);
                }
                boolean buffer22 = true;
                return buffer22;
            }
            catch (Exception exception) {
                Log.error(StringExtensions.format("Media pipe ({0}) could not process frame.", this.getLabel()), exception);
            }
            finally {
                this.__processingFrame = false;
            }
        }
        return false;
    }

    @Override
    public Error processSdpMediaDescriptionFromSink(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        Error error = this.doProcessSdpMediaDescription(mediaDescription, isOffer, isLocalDescription);
        for (IMediaSource local : this.getSources()) {
            if (error != null) {
                return error;
            }
            error = local.processSdpMediaDescriptionFromSink(mediaDescription, isOffer, isLocalDescription);
        }
        return null;
    }

    @Override
    public Error processSdpMediaDescriptionFromSource(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        Error error = this.doProcessSdpMediaDescription(mediaDescription, isOffer, isLocalDescription);
        for (IMediaSink local : this.getSinks()) {
            if (error != null) {
                return error;
            }
            error = local.processSdpMediaDescriptionFromSource(mediaDescription, isOffer, isLocalDescription);
        }
        return null;
    }

    protected void raiseControlFrame(MediaControlFrame controlFrame) {
        this.raiseControlFrames(new MediaControlFrame[]{controlFrame});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void raiseControlFrames(MediaControlFrame[] controlFrames) {
        if (Global.equals((Object)this.__state, (Object)MediaPipeState.Initialized)) {
            this.__raisingControlFrames = true;
            try {
                if (Global.equals((Object)this.__state, (Object)MediaPipeState.Initialized)) {
                    IAction1<MediaControlFrame[]> onRaiseControlFrames = this._onRaiseControlFrames;
                    if (onRaiseControlFrames != null) {
                        onRaiseControlFrames.invoke(controlFrames);
                    }
                    for (IMediaSource local : this.getSources()) {
                        local.processControlFrames(controlFrames);
                    }
                }
            }
            catch (Exception exception) {
                Log.error(StringExtensions.format("Media pipe ({0}) could not raise control frames.", this.getLabel()), exception);
            }
            finally {
                this.__raisingControlFrames = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void raiseFrame(TFrame frame) {
        if (Global.equals((Object)this.__state, (Object)MediaPipeState.Initialized)) {
            this.__raisingFrame = true;
            try {
                if (Global.equals((Object)this.__state, (Object)MediaPipeState.Initialized)) {
                    Object[] sinks;
                    for (MediaBuffer local : frame.getBuffers()) {
                        if (StringExtensions.isNullOrEmpty(local.getSourceId())) {
                            local.setSourceId(this.getId());
                        }
                        if (!this.getMuted()) continue;
                        local.mute();
                    }
                    IAction1<TFrame> onRaiseFrame = this._onRaiseFrame;
                    if (onRaiseFrame != null) {
                        onRaiseFrame.invoke(frame);
                    }
                    if (ArrayExtensions.getLength(sinks = this.getSinks()) > 0) {
                        for (Object local2 : sinks) {
                            if (local2.getDisabled()) continue;
                            local2.processFrame(frame);
                        }
                    }
                }
            }
            catch (Exception exception) {
                Log.error(StringExtensions.format("Media pipe ({0}) could not raise frame.", this.getLabel()), exception);
            }
            finally {
                this.__raisingFrame = false;
            }
        }
    }

    public void removeOnDisabledChange(IAction1<TPipe> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onDisabledChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onDisabledChange.remove(value);
    }

    @Override
    public void removeOnProcessControlFrames(IAction1<MediaControlFrame[]> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onProcessControlFrames, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onProcessControlFrames.remove(value);
    }

    @Override
    public void removeOnProcessFrame(IAction1<TFrame> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onProcessFrame, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onProcessFrame.remove(value);
    }

    public void removeOnRaiseControlFrames(IAction1<MediaControlFrame[]> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onRaiseControlFrames, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onRaiseControlFrames.remove(value);
    }

    public void removeOnRaiseFrame(IAction1<TFrame> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onRaiseFrame, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onRaiseFrame.remove(value);
    }

    public void removeOnStateChange(IAction1<TPipe> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onStateChange.remove(value);
    }

    @Override
    public boolean removeSink(TISink sink) {
        return ((Collection)this.__sinks).remove(sink);
    }

    @Override
    public boolean removeSinks(TISink[] sinks) {
        return ((Collection)this.__sinks).removeMany(sinks);
    }

    @Override
    public void removeSinks() {
        ((Collection)this.__sinks).removeAll();
    }

    @Override
    public boolean removeSource(TISource source) {
        return ((Collection)this.__sources).remove(source);
    }

    @Override
    public void removeSources() {
        ((Collection)this.__sources).removeAll();
    }

    @Override
    public boolean removeSources(TISource[] sources) {
        return ((Collection)this.__sources).removeMany(sources);
    }

    @Override
    public void setId(String value) {
        this._id = value;
    }

    private void setInputFormat(TFormat value) {
        this._inputFormat = value;
    }

    public void setMuted(boolean value) {
        this._muted = value;
    }

    private void setOutputFormat(TFormat value) {
        this._outputFormat = value;
    }

    public void setSink(TISink value) {
        this.removeSinks();
        this.addSink(value);
    }

    public void setSinks(TISink[] value) {
        this.removeSinks();
        this.addSinks((IMediaSink[])value);
    }

    public void setSource(TISource value) {
        this.removeSources();
        this.addSource(value);
    }

    public void setSources(TISource[] value) {
        this.removeSources();
        this.addSources((IMediaSource[])value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(MediaPipeState value) {
        Object object = this.__stateLock;
        synchronized (object) {
            if (!Global.equals((Object)this.__state, (Object)value)) {
                this.__state = value;
                IAction1<TPipe> onStateChange = this._onStateChange;
                if (onStateChange != null) {
                    onStateChange.invoke(this);
                }
            }
        }
    }

    public void setTag(String value) {
        this._tag = value;
    }

    public String toString() {
        return this.getLabel();
    }

    private void validateSink(TISink sink) {
        if (!(sink instanceof Stream) && sink.getInputFormat() != null && !((MediaFormat)sink.getInputFormat()).isEquivalent(this.getOutputFormat())) {
            throw new RuntimeException(new Exception(StringExtensions.concat(new String[]{"Input format [", ((MediaFormat)sink.getInputFormat()).toString(), "] of sink (", sink.getLabel(), ") does not match output format [", ((MediaFormat)this.getOutputFormat()).toString(), "] of source (", this.getLabel(), ")."})));
        }
    }

    private void validateSource(TISource source) {
        if (!(source instanceof Stream)) {
            if (this.getInputFormat() == null) {
                this.setInputFormat(((MediaFormat)source.getOutputFormat()).clone());
            }
            if (!((MediaFormat)source.getOutputFormat()).isEquivalent(this.getInputFormat())) {
                throw new RuntimeException(new Exception(StringExtensions.concat(new String[]{"Output format [", ((MediaFormat)source.getOutputFormat()).toString(), "] of source (", source.getLabel(), ") does not match input format [", ((MediaFormat)this.getInputFormat()).toString(), "] of sink (", this.getLabel(), ")."})));
            }
        }
    }
}

