/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.Guid;
import fm.icelink.IElement;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaSink;
import fm.icelink.IMediaSource;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFrame;
import fm.icelink.MediaPipe;
import fm.icelink.MediaSink;
import fm.icelink.MediaSinkCollection;
import fm.icelink.MediaSource;
import fm.icelink.MediaSourceCollection;
import fm.icelink.MediaTrack;
import fm.icelink.StringExtensions;
import java.util.ArrayList;

public abstract class MediaBranch<TISource extends IMediaSource<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>, TISourceCollection extends MediaSourceCollection<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat, TISourceCollection>, TISink extends IMediaSink<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>, TISinkCollection extends MediaSinkCollection<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat, TISinkCollection>, TIElement extends IMediaElement, TSource extends MediaSource<TISource, TISink, TISinkCollection, TSource, TFrame, TBuffer, TBufferCollection, TFormat>, TSink extends MediaSink<TISource, TISourceCollection, TISink, TSink, TFrame, TBuffer, TBufferCollection, TFormat>, TPipe extends MediaPipe<TISource, TISourceCollection, TISink, TISinkCollection, TPipe, TFrame, TBuffer, TBufferCollection, TFormat>, TTrack extends MediaTrack<TISource, TISourceCollection, TISink, TISinkCollection, TIElement, TSource, TSink, TPipe, TTrack, TBranch, TFrame, TBuffer, TBufferCollection, TFormat>, TBranch extends MediaBranch<TISource, TISourceCollection, TISink, TISinkCollection, TIElement, TSource, TSink, TPipe, TTrack, TBranch, TFrame, TBuffer, TBufferCollection, TFormat>, TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>>
implements IMediaElement,
IElement {
    private ArrayList<TTrack> __tracks = new ArrayList();
    private boolean _destroyed = false;
    private Object _destroyLock = new Object();
    private String _id;

    protected abstract TTrack[] arrayFromTracks(ArrayList<TTrack> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroy() {
        MediaTrack[] mediaTrackArray = this._destroyLock;
        synchronized (this._destroyLock) {
            if (this._destroyed) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            this._destroyed = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (MediaTrack local : this.getTracks()) {
                if (local == null) continue;
                local.destroy();
            }
            return true;
        }
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public abstract String getLabel();

    public boolean getMuted() {
        for (MediaTrack local : this.getTracks()) {
            if (!local.getMuted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getPipelineJson() {
        ArrayList<String> list = new ArrayList<String>();
        for (MediaTrack local : this.getTracks()) {
            Object firstElement = local.getFirstElement();
            if (firstElement == null) continue;
            list.add(firstElement.getPipelineJson());
        }
        return StringExtensions.concat("[", StringExtensions.join(", ", list.toArray(new String[0])), "]");
    }

    public TTrack[] getTracks() {
        return this.arrayFromTracks(this.__tracks);
    }

    public MediaBranch(TTrack[] tracks) {
        this.setId(Guid.newGuid().toString().replace("-", ""));
        ArrayListExtensions.addRange(this.__tracks, tracks);
    }

    @Override
    public void setId(String value) {
        this._id = value;
    }

    public void setMuted(boolean value) {
        for (MediaTrack local : this.getTracks()) {
            local.setMuted(value);
        }
    }

    public String toString() {
        return this.getLabel();
    }
}

