/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioTrack;
import fm.icelink.Dynamic;
import fm.icelink.Guid;
import fm.icelink.MediaTrack;
import fm.icelink.Utility;
import fm.icelink.VideoTrack;

public abstract class MediaBase
extends Dynamic {
    private String __id = Guid.newGuid().toString().replace("-", "");
    private boolean _isRecordingAudio;
    private boolean _isRecordingVideo;

    public boolean getAudioMuted() {
        for (AudioTrack track : this.getAudioTracks()) {
            if (!track.getMuted()) continue;
            return true;
        }
        return false;
    }

    public AudioTrack getAudioTrack() {
        return Utility.firstOrDefault(this.getAudioTracks());
    }

    public abstract AudioTrack[] getAudioTracks();

    public String getId() {
        return this.__id;
    }

    public boolean getIsRecordingAudio() {
        return this._isRecordingAudio;
    }

    public boolean getIsRecordingVideo() {
        return this._isRecordingVideo;
    }

    public boolean getMuted() {
        for (AudioTrack audioTrack : this.getAudioTracks()) {
            if (!audioTrack.getMuted()) continue;
            return true;
        }
        for (MediaTrack mediaTrack : this.getVideoTracks()) {
            if (!mediaTrack.getMuted()) continue;
            return true;
        }
        return false;
    }

    public boolean getVideoMuted() {
        for (VideoTrack track : this.getVideoTracks()) {
            if (!track.getMuted()) continue;
            return true;
        }
        return false;
    }

    public VideoTrack getVideoTrack() {
        return Utility.firstOrDefault(this.getVideoTracks());
    }

    public abstract VideoTrack[] getVideoTracks();

    protected MediaBase() {
    }

    public void setAudioMuted(boolean value) {
        for (AudioTrack track : this.getAudioTracks()) {
            track.setMuted(value);
        }
    }

    protected void setIsRecordingAudio(boolean value) {
        this._isRecordingAudio = value;
    }

    protected void setIsRecordingVideo(boolean value) {
        this._isRecordingVideo = value;
    }

    public void setMuted(boolean value) {
        for (AudioTrack audioTrack : this.getAudioTracks()) {
            audioTrack.setMuted(value);
        }
        for (MediaTrack mediaTrack : this.getVideoTracks()) {
            mediaTrack.setMuted(value);
        }
    }

    public void setVideoMuted(boolean value) {
        for (VideoTrack track : this.getVideoTracks()) {
            track.setMuted(value);
        }
    }
}

