/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.HashMapExtensions;
import fm.icelink.LogLevel;
import fm.icelink.LogProvider;
import java.util.ArrayList;
import java.util.HashMap;

class LogConfiguration {
    private static LogLevel _defaultLogLevel;
    private static ArrayList<LogProvider> _logProviders;
    private static HashMap<String, LogLevel> _tagOverrides;

    public static LogLevel getDefaultLogLevel() {
        return _defaultLogLevel;
    }

    public static ArrayList<LogProvider> getLogProviders() {
        return _logProviders;
    }

    public static LogLevel getTagLogLevel(String tag) {
        LogLevel defaultLogLevel = LogConfiguration.getDefaultLogLevel();
        if (LogConfiguration.getTagOverrides().containsKey(tag)) {
            defaultLogLevel = HashMapExtensions.getItem(LogConfiguration.getTagOverrides()).get(tag);
        }
        return defaultLogLevel;
    }

    public static HashMap<String, LogLevel> getTagOverrides() {
        return _tagOverrides;
    }

    public static void setDefaultLogLevel(LogLevel value) {
        _defaultLogLevel = value;
    }

    private static void setLogProviders(ArrayList<LogProvider> value) {
        _logProviders = value;
    }

    private static void setTagOverrides(HashMap<String, LogLevel> value) {
        _tagOverrides = value;
    }

    static {
        LogConfiguration.setDefaultLogLevel(LogLevel.Info);
        LogConfiguration.setLogProviders(new ArrayList<LogProvider>());
        LogConfiguration.setTagOverrides(new HashMap<String, LogLevel>());
    }
}

