/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.Dynamic;
import fm.icelink.Global;
import fm.icelink.IntegerHolder;
import fm.icelink.Layout;
import fm.icelink.LayoutAlignment;
import fm.icelink.LayoutDirection;
import fm.icelink.LayoutFrame;
import fm.icelink.LayoutMode;
import fm.icelink.LayoutOrigin;
import fm.icelink.LayoutTable;
import fm.icelink.MathAssistant;
import fm.icelink.Platform;
import java.util.ArrayList;

public class LayoutPreset
extends Dynamic {
    private int __blockHeight = 0;
    private double __blockHeightPercent = 0.0;
    private int __blockMarginX = 0;
    private double __blockMarginXPercent = 0.0;
    private int __blockMarginY = 0;
    private double __blockMarginYPercent = 0.0;
    private int __blockWidth = 0;
    private double __blockWidthPercent = 0.0;
    private int __floatHeight = 0;
    private double __floatHeightPercent = 0.0;
    private int __floatMarginX = 0;
    private double __floatMarginXPercent = 0.0;
    private int __floatMarginY = 0;
    private double __floatMarginYPercent = 0.0;
    private int __floatWidth = 0;
    private double __floatWidthPercent = 0.0;
    private LayoutAlignment _alignment;
    private LayoutDirection _direction;
    private int _inlineMargin;
    private LayoutMode _mode;

    public void applyPreset(LayoutPreset preset) {
        this.setMode(preset.getMode());
        this.setDirection(preset.getDirection());
        this.setAlignment(preset.getAlignment());
        this.setFloatWidth(0);
        this.setFloatHeight(0);
        this.setFloatMarginX(0);
        this.setFloatMarginY(0);
        this.setFloatWidthPercent(0.0);
        this.setFloatHeightPercent(0.0);
        this.setFloatMarginXPercent(0.0);
        this.setFloatMarginYPercent(0.0);
        this.setBlockWidth(0);
        this.setBlockHeight(0);
        this.setBlockMarginX(0);
        this.setBlockMarginY(0);
        this.setBlockWidthPercent(0.0);
        this.setBlockHeightPercent(0.0);
        this.setBlockMarginXPercent(0.0);
        this.setBlockMarginYPercent(0.0);
        this.setInlineMargin(0);
        if (preset.getFloatWidth() > 0) {
            this.setFloatWidth(preset.getFloatWidth());
        }
        if (preset.getFloatHeight() > 0) {
            this.setFloatHeight(preset.getFloatHeight());
        }
        if (preset.getFloatMarginX() > 0) {
            this.setFloatMarginX(preset.getFloatMarginX());
        }
        if (preset.getFloatMarginY() > 0) {
            this.setFloatMarginY(preset.getFloatMarginY());
        }
        if (preset.getFloatWidthPercent() > 0.0) {
            this.setFloatWidthPercent(preset.getFloatWidthPercent());
        }
        if (preset.getFloatHeightPercent() > 0.0) {
            this.setFloatHeightPercent(preset.getFloatHeightPercent());
        }
        if (preset.getFloatMarginXPercent() > 0.0) {
            this.setFloatMarginXPercent(preset.getFloatMarginXPercent());
        }
        if (preset.getFloatMarginYPercent() > 0.0) {
            this.setFloatMarginYPercent(preset.getFloatMarginYPercent());
        }
        if (preset.getBlockWidth() > 0) {
            this.setBlockWidth(preset.getBlockWidth());
        }
        if (preset.getBlockHeight() > 0) {
            this.setBlockHeight(preset.getBlockHeight());
        }
        if (preset.getBlockMarginX() > 0) {
            this.setBlockMarginX(preset.getBlockMarginX());
        }
        if (preset.getBlockMarginY() > 0) {
            this.setBlockMarginY(preset.getBlockMarginY());
        }
        if (preset.getBlockWidthPercent() > 0.0) {
            this.setBlockWidthPercent(preset.getBlockWidthPercent());
        }
        if (preset.getBlockHeightPercent() > 0.0) {
            this.setBlockHeightPercent(preset.getBlockHeightPercent());
        }
        if (preset.getBlockMarginXPercent() > 0.0) {
            this.setBlockMarginXPercent(preset.getBlockMarginXPercent());
        }
        if (preset.getBlockMarginYPercent() > 0.0) {
            this.setBlockMarginYPercent(preset.getBlockMarginYPercent());
        }
        if (preset.getInlineMargin() > 0) {
            this.setInlineMargin(preset.getInlineMargin());
        }
    }

    private LayoutFrame calculateBlockFrame(int layoutWidth, int layoutHeight, IntegerHolder marginX, IntegerHolder marginY) {
        if (this.getBlockWidth() == 0 && this.getBlockWidthPercent() == 0.0) {
            this.setBlockWidthPercent(0.25);
        }
        if (this.getBlockHeight() == 0 && this.getBlockHeightPercent() == 0.0) {
            this.setBlockHeightPercent(0.25);
        }
        int width = this.getBlockWidth() > 0 ? this.getBlockWidth() : (int)((double)layoutWidth * this.getBlockWidthPercent());
        int height = this.getBlockHeight() > 0 ? this.getBlockHeight() : (int)((double)layoutHeight * this.getBlockHeightPercent());
        marginX.setValue(this.getBlockMarginX() > 0 ? this.getBlockMarginX() : (int)((double)layoutWidth * this.getBlockMarginXPercent()));
        marginY.setValue(this.getBlockMarginY() > 0 ? this.getBlockMarginY() : (int)((double)layoutHeight * this.getBlockMarginYPercent()));
        int x = 0;
        LayoutAlignment _var0 = this.getAlignment();
        x = _var0 == LayoutAlignment.Top || _var0 == LayoutAlignment.Center || _var0 == LayoutAlignment.Bottom ? LayoutPreset.divideByTwo(layoutWidth - width) : (_var0 == LayoutAlignment.TopRight || _var0 == LayoutAlignment.Right || _var0 == LayoutAlignment.BottomRight ? layoutWidth - width : 0);
        int y = 0;
        LayoutAlignment _var1 = this.getAlignment();
        y = _var1 == LayoutAlignment.Left || _var1 == LayoutAlignment.Center || _var1 == LayoutAlignment.Right ? LayoutPreset.divideByTwo(layoutHeight - height) : (_var1 == LayoutAlignment.BottomLeft || _var1 == LayoutAlignment.Bottom || _var1 == LayoutAlignment.BottomRight ? layoutHeight - height : 0);
        return new LayoutFrame(x, y, width, height);
    }

    private LayoutFrame calculateFillFrame(int layoutWidth, int layoutHeight) {
        return new LayoutFrame(0, 0, layoutWidth, layoutHeight);
    }

    private LayoutFrame calculateFloatFrame(int layoutWidth, int layoutHeight) {
        return this.calculateFloatFrames(layoutWidth, layoutHeight, 1)[0];
    }

    private LayoutFrame[] calculateFloatFrames(int layoutWidth, int layoutHeight, int count) {
        LayoutAlignment _var1;
        int num4;
        if (this.getFloatWidth() == 0 && this.getFloatWidthPercent() == 0.0) {
            this.setFloatWidthPercent(0.25);
        }
        if (this.getFloatHeight() == 0 && this.getFloatHeightPercent() == 0.0) {
            this.setFloatHeightPercent(0.25);
        }
        int num = this.getFloatWidth() > 0 ? this.getFloatWidth() : (int)((double)layoutWidth * this.getFloatWidthPercent());
        int num2 = this.getFloatHeight() > 0 ? this.getFloatHeight() : (int)((double)layoutHeight * this.getFloatHeightPercent());
        int num3 = this.getFloatMarginX() > 0 ? this.getFloatMarginX() : (int)((double)layoutWidth * this.getFloatMarginXPercent());
        int n = num4 = this.getFloatMarginY() > 0 ? this.getFloatMarginY() : (int)((double)layoutHeight * this.getFloatMarginYPercent());
        if (Global.equals((Object)this.getDirection(), (Object)LayoutDirection.Horizontal)) {
            num = MathAssistant.min(layoutWidth, num * count);
        } else {
            num2 = MathAssistant.min(layoutHeight, num2 * count);
        }
        LayoutFrame[] frameArray = this.calculateInlineFrames(num, num2, count, 0, 0);
        LayoutAlignment _var0 = this.getAlignment();
        if (_var0 == LayoutAlignment.TopLeft || _var0 == LayoutAlignment.Top || _var0 == LayoutAlignment.TopRight) {
            for (LayoutFrame frame : frameArray) {
                frame.setY(frame.getY() + num4);
            }
        } else if (_var0 == LayoutAlignment.Left || _var0 == LayoutAlignment.Center || _var0 == LayoutAlignment.Right) {
            for (LayoutFrame frame : frameArray) {
                frame.setY(frame.getY() + LayoutPreset.divideByTwo(layoutHeight - num2));
            }
        } else if (_var0 == LayoutAlignment.BottomLeft || _var0 == LayoutAlignment.Bottom || _var0 == LayoutAlignment.BottomRight) {
            for (LayoutFrame frame : frameArray) {
                frame.setY(frame.getY() + (layoutHeight - num2 - num4));
            }
        }
        if ((_var1 = this.getAlignment()) == LayoutAlignment.TopLeft || _var1 == LayoutAlignment.Left || _var1 == LayoutAlignment.BottomLeft) {
            for (LayoutFrame frame : frameArray) {
                frame.setX(frame.getX() + num3);
            }
            return frameArray;
        }
        if (_var1 == LayoutAlignment.Top || _var1 == LayoutAlignment.Center || _var1 == LayoutAlignment.Bottom) {
            for (LayoutFrame frame : frameArray) {
                frame.setX(frame.getX() + LayoutPreset.divideByTwo(layoutWidth - num));
            }
            return frameArray;
        }
        if (_var1 == LayoutAlignment.TopRight || _var1 == LayoutAlignment.Right || _var1 == LayoutAlignment.BottomRight) {
            for (LayoutFrame frame : frameArray) {
                frame.setX(frame.getX() + (layoutWidth - num - num3));
            }
            return frameArray;
        }
        return frameArray;
    }

    private LayoutFrame calculateInlineFrame(int cellX, int cellY, int cellWidth, int cellHeight) {
        int num = LayoutPreset.divideByTwo(this.getInlineMargin());
        int x = cellX - num;
        int y = cellY - num;
        int width = cellWidth - this.getInlineMargin();
        return new LayoutFrame(x, y, width, cellHeight - this.getInlineMargin());
    }

    private LayoutFrame[] calculateInlineFrames(int layoutWidth, int layoutHeight, int count, int baseX, int baseY) {
        ArrayList<LayoutFrame> list = new ArrayList<LayoutFrame>();
        LayoutTable table = LayoutPreset.calculateTable(layoutWidth + this.getInlineMargin(), layoutHeight + this.getInlineMargin(), count);
        int columnCount = table.getColumnCount();
        int rowCount = table.getRowCount();
        int cellWidth = table.getCellWidth();
        int cellHeight = table.getCellHeight();
        int num5 = LayoutPreset.divideByTwo(this.getInlineMargin());
        if (Global.equals((Object)this.getDirection(), (Object)LayoutDirection.Horizontal)) {
            int num6 = 0;
            int num7 = baseY + num5;
            int num8 = layoutHeight - rowCount * cellHeight + this.getInlineMargin();
            for (int num9 = 0; num9 < rowCount; ++num9) {
                int num10 = num9 < num8 ? 1 : 0;
                int num11 = columnCount;
                if (num9 == rowCount - 1) {
                    num11 = count - num6;
                }
                int num12 = baseX + num5;
                if (num9 == rowCount - 1 && rowCount > 1) {
                    int num13 = num12 - num5;
                    int num14 = num7 - num5;
                    ArrayListExtensions.addRange(list, this.calculateInlineFrames(baseX + layoutWidth, baseY + layoutHeight - num14, num11, num13, num14));
                } else {
                    int num15 = layoutWidth - num11 * cellWidth + this.getInlineMargin();
                    int num16 = 0;
                    while (num16 < num11) {
                        int num17 = num16 < num15 ? 1 : 0;
                        LayoutFrame frame = this.calculateInlineFrame(num12, num7, cellWidth + num17, cellHeight + num10);
                        list.add(frame);
                        num12 += cellWidth + num17;
                        ++num16;
                        ++num6;
                    }
                }
                num7 += cellHeight + num10;
            }
        } else {
            int num6 = 0;
            int num12 = baseX + num5;
            int num15 = layoutWidth - columnCount * cellWidth + this.getInlineMargin();
            for (int num16 = 0; num16 < columnCount; ++num16) {
                int num17 = num16 < num15 ? 1 : 0;
                int num18 = rowCount;
                if (num16 == columnCount - 1) {
                    num18 = count - num6;
                }
                int num7 = baseY + num5;
                if (num16 == columnCount - 1 && columnCount > 1) {
                    int num13 = num12 - num5;
                    int num14 = num7 - num5;
                    ArrayListExtensions.addRange(list, this.calculateInlineFrames(baseX + layoutWidth - num13, baseY + layoutHeight, num18, num13, num14));
                } else {
                    int num8 = layoutHeight - num18 * cellHeight + this.getInlineMargin();
                    int num9 = 0;
                    while (num9 < num18) {
                        int num10 = num9 < num8 ? 1 : 0;
                        LayoutFrame frame = this.calculateInlineFrame(num12, num7, cellWidth + num17, cellHeight + num10);
                        list.add(frame);
                        num7 += cellHeight + num10;
                        ++num9;
                        ++num6;
                    }
                }
                num12 += cellWidth + num17;
            }
        }
        return list.toArray(new LayoutFrame[0]);
    }

    public Layout calculateLayout(int layoutWidth, int layoutHeight, int remoteCount, LayoutOrigin origin) {
        if (layoutWidth < 0) {
            layoutWidth = 0;
        }
        if (layoutHeight < 0) {
            layoutHeight = 0;
        }
        Layout singleLayout = null;
        singleLayout = remoteCount == 0 ? LayoutPreset.getSingleLayout(layoutWidth, layoutHeight) : (Global.equals((Object)this.getMode(), (Object)LayoutMode.FloatLocal) ? this.getFloatLocalLayout(layoutWidth, layoutHeight, remoteCount) : (Global.equals((Object)this.getMode(), (Object)LayoutMode.FloatRemote) ? this.getFloatRemoteLayout(layoutWidth, layoutHeight, remoteCount) : (Global.equals((Object)this.getMode(), (Object)LayoutMode.Block) ? this.getBlockLayout(layoutWidth, layoutHeight, remoteCount) : this.getInlineLayout(layoutWidth, layoutHeight, remoteCount))));
        LayoutPreset.transformFrame(singleLayout.getLocalFrame(), origin, layoutWidth, layoutHeight);
        for (LayoutFrame frame : singleLayout.getRemoteFrames()) {
            LayoutPreset.transformFrame(frame, origin, layoutWidth, layoutHeight);
        }
        singleLayout.setWidth(layoutWidth);
        singleLayout.setHeight(layoutHeight);
        singleLayout.setOrigin(origin);
        return singleLayout;
    }

    private static LayoutTable calculateTable(int tableWidth, int tableHeight, int count) {
        double num = 0.0;
        double num2 = 1.0;
        double num3 = 1.0;
        for (double i = (double)count; i >= 1.0; i -= 1.0) {
            double num8;
            double num6 = (double)tableWidth / i;
            double num5 = MathAssistant.ceil((double)count / i);
            double num7 = (double)tableHeight / num5;
            double d = num8 = num6 < num7 ? num6 : num7;
            if (!(num8 >= num)) continue;
            num = num8;
            num2 = i;
            num3 = num5;
        }
        int cellWidth = (int)MathAssistant.floor((double)tableWidth / num2);
        return new LayoutTable((int)num2, (int)num3, cellWidth, (int)MathAssistant.floor((double)tableHeight / num3));
    }

    public void copyToPreset(LayoutPreset preset) {
        preset.setMode(this.getMode());
        preset.setDirection(this.getDirection());
        preset.setAlignment(this.getAlignment());
        preset.setFloatWidth(0);
        preset.setFloatHeight(0);
        preset.setFloatMarginX(0);
        preset.setFloatMarginY(0);
        preset.setFloatWidthPercent(0.0);
        preset.setFloatHeightPercent(0.0);
        preset.setFloatMarginXPercent(0.0);
        preset.setFloatMarginYPercent(0.0);
        preset.setBlockWidth(0);
        preset.setBlockHeight(0);
        preset.setBlockMarginX(0);
        preset.setBlockMarginY(0);
        preset.setBlockWidthPercent(0.0);
        preset.setBlockHeightPercent(0.0);
        preset.setBlockMarginXPercent(0.0);
        preset.setBlockMarginYPercent(0.0);
        preset.setInlineMargin(0);
        if (this.getFloatWidth() > 0) {
            preset.setFloatWidth(this.getFloatWidth());
        }
        if (this.getFloatHeight() > 0) {
            preset.setFloatHeight(this.getFloatHeight());
        }
        if (this.getFloatMarginX() > 0) {
            preset.setFloatMarginX(this.getFloatMarginX());
        }
        if (this.getFloatMarginY() > 0) {
            preset.setFloatMarginY(this.getFloatMarginY());
        }
        if (this.getFloatWidthPercent() > 0.0) {
            preset.setFloatWidthPercent(this.getFloatWidthPercent());
        }
        if (this.getFloatHeightPercent() > 0.0) {
            preset.setFloatHeightPercent(this.getFloatHeightPercent());
        }
        if (this.getFloatMarginXPercent() > 0.0) {
            preset.setFloatMarginXPercent(this.getFloatMarginXPercent());
        }
        if (this.getFloatMarginYPercent() > 0.0) {
            preset.setFloatMarginYPercent(this.getFloatMarginYPercent());
        }
        if (this.getBlockWidth() > 0) {
            preset.setBlockWidth(this.getBlockWidth());
        }
        if (this.getBlockHeight() > 0) {
            preset.setBlockHeight(this.getBlockHeight());
        }
        if (this.getBlockMarginX() > 0) {
            preset.setBlockMarginX(this.getBlockMarginX());
        }
        if (this.getBlockMarginY() > 0) {
            preset.setBlockMarginY(this.getBlockMarginY());
        }
        if (this.getBlockWidthPercent() > 0.0) {
            preset.setBlockWidthPercent(this.getBlockWidthPercent());
        }
        if (this.getBlockHeightPercent() > 0.0) {
            preset.setBlockHeightPercent(this.getBlockHeightPercent());
        }
        if (this.getBlockMarginXPercent() > 0.0) {
            preset.setBlockMarginXPercent(this.getBlockMarginXPercent());
        }
        if (this.getBlockMarginYPercent() > 0.0) {
            preset.setBlockMarginYPercent(this.getBlockMarginYPercent());
        }
        if (this.getInlineMargin() > 0) {
            preset.setInlineMargin(this.getInlineMargin());
        }
    }

    private static int divideByTwo(int value) {
        return (int)MathAssistant.floor((double)value / 2.0);
    }

    public LayoutAlignment getAlignment() {
        return this._alignment;
    }

    public int getBlockHeight() {
        return this.__blockHeight;
    }

    public double getBlockHeightPercent() {
        return this.__blockHeightPercent;
    }

    private Layout getBlockLayout(int layoutWidth, int layoutHeight, int remoteCount) {
        int marginX = 0;
        int marginY = 0;
        IntegerHolder _var0 = new IntegerHolder(marginX);
        IntegerHolder _var1 = new IntegerHolder(marginY);
        LayoutFrame _var2 = this.calculateBlockFrame(layoutWidth, layoutHeight, _var0, _var1);
        marginX = _var0.getValue();
        marginY = _var1.getValue();
        LayoutFrame frame = _var2;
        ArrayList list = new ArrayList();
        if (Global.equals((Object)this.getAlignment(), (Object)LayoutAlignment.Center)) {
            int count = LayoutPreset.divideByTwo(remoteCount);
            int num4 = remoteCount - count;
            int baseX = 0;
            int baseY = 0;
            if (Global.equals((Object)this.getDirection(), (Object)LayoutDirection.Vertical)) {
                int num7 = frame.getWidth() + marginX + marginX;
                layoutWidth = LayoutPreset.divideByTwo(layoutWidth - num7);
                baseX = layoutWidth + num7;
            } else {
                int num8 = frame.getHeight() + marginY + marginY;
                layoutHeight = LayoutPreset.divideByTwo(layoutHeight - num8);
                baseY = layoutHeight + num8;
            }
            if (count > 0) {
                ArrayListExtensions.addRange(list, this.calculateInlineFrames(layoutWidth, layoutHeight, count, 0, 0));
            }
            if (num4 > 0) {
                ArrayListExtensions.addRange(list, this.calculateInlineFrames(layoutWidth, layoutHeight, num4, baseX, baseY));
            }
        } else {
            int num9 = 0;
            int num10 = 0;
            int num7 = frame.getWidth() + marginX;
            int num8 = frame.getHeight() + marginY;
            if (Global.equals((Object)this.getAlignment(), (Object)LayoutAlignment.Top)) {
                num10 = num8;
                layoutHeight -= num8;
            } else if (Global.equals((Object)this.getAlignment(), (Object)LayoutAlignment.Bottom)) {
                layoutHeight -= num8;
            } else if (Global.equals((Object)this.getAlignment(), (Object)LayoutAlignment.Left)) {
                num9 = num7;
                layoutWidth -= num7;
            } else if (Global.equals((Object)this.getAlignment(), (Object)LayoutAlignment.Right)) {
                layoutWidth -= num7;
            } else if (Global.equals((Object)this.getDirection(), (Object)LayoutDirection.Vertical)) {
                if (Global.equals((Object)this.getAlignment(), (Object)LayoutAlignment.TopLeft) || Global.equals((Object)this.getAlignment(), (Object)LayoutAlignment.BottomLeft)) {
                    num9 = num7;
                }
                layoutWidth -= num7;
            } else {
                if (Global.equals((Object)this.getAlignment(), (Object)LayoutAlignment.TopLeft) || Global.equals((Object)this.getAlignment(), (Object)LayoutAlignment.TopRight)) {
                    num10 = num8;
                }
                layoutHeight -= num8;
            }
            ArrayListExtensions.addRange(list, this.calculateInlineFrames(layoutWidth, layoutHeight, remoteCount, num9, num10));
        }
        Layout layout = new Layout();
        layout.setLocalFrame(frame);
        layout.setRemoteFrames(list.toArray(new LayoutFrame[0]));
        return layout;
    }

    public int getBlockMarginX() {
        return this.__blockMarginX;
    }

    public double getBlockMarginXPercent() {
        return this.__blockMarginXPercent;
    }

    public int getBlockMarginY() {
        return this.__blockMarginY;
    }

    public double getBlockMarginYPercent() {
        return this.__blockMarginYPercent;
    }

    public int getBlockWidth() {
        return this.__blockWidth;
    }

    public double getBlockWidthPercent() {
        return this.__blockWidthPercent;
    }

    private int[] getBottomRowIndexes(LayoutFrame[] frames) {
        int num3;
        int yMax = LayoutPreset.getYMax(frames);
        int num2 = 0;
        for (num3 = 0; num3 < ArrayExtensions.getLength(frames); ++num3) {
            if (frames[num3].getY() != yMax) continue;
            ++num2;
        }
        int num4 = 0;
        int[] numArray = new int[num2];
        for (num3 = 0; num3 < ArrayExtensions.getLength(frames); ++num3) {
            if (frames[num3].getY() != yMax) continue;
            numArray[num4++] = num3;
        }
        return numArray;
    }

    private int[] getCenterColumnIndexes(LayoutFrame[] frames) {
        int num3;
        int xMid = LayoutPreset.getXMid(frames);
        int num2 = 0;
        for (num3 = 0; num3 < ArrayExtensions.getLength(frames); ++num3) {
            if (frames[num3].getX() != xMid) continue;
            ++num2;
        }
        int num4 = 0;
        int[] numArray = new int[num2];
        for (num3 = 0; num3 < ArrayExtensions.getLength(frames); ++num3) {
            if (frames[num3].getX() != xMid) continue;
            numArray[num4++] = num3;
        }
        return numArray;
    }

    private int[] getCenterRowIndexes(LayoutFrame[] frames) {
        int num3;
        int yMid = LayoutPreset.getYMid(frames);
        int num2 = 0;
        for (num3 = 0; num3 < ArrayExtensions.getLength(frames); ++num3) {
            if (frames[num3].getY() != yMid) continue;
            ++num2;
        }
        int num4 = 0;
        int[] numArray = new int[num2];
        for (num3 = 0; num3 < ArrayExtensions.getLength(frames); ++num3) {
            if (frames[num3].getY() != yMid) continue;
            numArray[num4++] = num3;
        }
        return numArray;
    }

    public LayoutDirection getDirection() {
        return this._direction;
    }

    public static LayoutPreset getFacetime() {
        LayoutPreset preset = new LayoutPreset();
        preset.setMode(LayoutMode.FloatLocal);
        preset.setAlignment(LayoutAlignment.BottomRight);
        preset.setFloatMarginX(10);
        preset.setFloatMarginY(10);
        preset.setFloatWidthPercent(0.25);
        preset.setFloatHeightPercent(0.25);
        preset.setInlineMargin(0);
        return preset;
    }

    public int getFloatHeight() {
        return this.__floatHeight;
    }

    public double getFloatHeightPercent() {
        return this.__floatHeightPercent;
    }

    private Layout getFloatLocalLayout(int layoutWidth, int layoutHeight, int remoteCount) {
        Layout layout = new Layout();
        layout.setLocalFrame(this.calculateFloatFrame(layoutWidth, layoutHeight));
        layout.setRemoteFrames(this.calculateInlineFrames(layoutWidth, layoutHeight, remoteCount, 0, 0));
        return layout;
    }

    public int getFloatMarginX() {
        return this.__floatMarginX;
    }

    public double getFloatMarginXPercent() {
        return this.__floatMarginXPercent;
    }

    public int getFloatMarginY() {
        return this.__floatMarginY;
    }

    public double getFloatMarginYPercent() {
        return this.__floatMarginYPercent;
    }

    private Layout getFloatRemoteLayout(int layoutWidth, int layoutHeight, int remoteCount) {
        Layout layout = new Layout();
        layout.setLocalFrame(this.calculateFillFrame(layoutWidth, layoutHeight));
        layout.setRemoteFrames(this.calculateFloatFrames(layoutWidth, layoutHeight, remoteCount));
        return layout;
    }

    public int getFloatWidth() {
        return this.__floatWidth;
    }

    public double getFloatWidthPercent() {
        return this.__floatWidthPercent;
    }

    public static LayoutPreset getGoogleHangouts() {
        if (Platform.getInstance().getIsMobile()) {
            LayoutPreset preset = new LayoutPreset();
            preset.setMode(LayoutMode.FloatRemote);
            preset.setAlignment(LayoutAlignment.BottomRight);
            preset.setFloatMarginX(0);
            preset.setFloatMarginY(10);
            preset.setFloatWidthPercent(0.25);
            preset.setFloatHeightPercent(0.25);
            preset.setInlineMargin(5);
            return preset;
        }
        LayoutPreset preset2 = new LayoutPreset();
        preset2.setMode(LayoutMode.Block);
        preset2.setAlignment(LayoutAlignment.Top);
        preset2.setBlockWidthPercent(0.666666666666667);
        preset2.setBlockHeightPercent(0.666666666666667);
        preset2.setInlineMargin(0);
        return preset2;
    }

    private Layout getInlineLayout(int layoutWidth, int layoutHeight, int remoteCount) {
        int[] centerRowIndexes;
        Object[] frames = this.calculateInlineFrames(layoutWidth, layoutHeight, remoteCount + 1, 0, 0);
        int index = 0;
        if (Global.equals((Object)this.getAlignment(), (Object)LayoutAlignment.TopLeft)) {
            index = 0;
        } else if (Global.equals((Object)this.getAlignment(), (Object)LayoutAlignment.Top)) {
            int[] topRowIndexes = this.getTopRowIndexes((LayoutFrame[])frames);
            index = topRowIndexes[LayoutPreset.divideByTwo(ArrayExtensions.getLength(topRowIndexes))];
        } else if (Global.equals((Object)this.getAlignment(), (Object)LayoutAlignment.TopRight)) {
            if (Global.equals((Object)this.getDirection(), (Object)LayoutDirection.Horizontal)) {
                centerRowIndexes = this.getTopRowIndexes((LayoutFrame[])frames);
                index = centerRowIndexes[ArrayExtensions.getLength(centerRowIndexes) - 1];
            } else {
                index = this.getRightColumnIndexes((LayoutFrame[])frames)[0];
            }
        } else if (Global.equals((Object)this.getAlignment(), (Object)LayoutAlignment.Left)) {
            int[] leftColumnIndexes = this.getLeftColumnIndexes((LayoutFrame[])frames);
            index = leftColumnIndexes[LayoutPreset.divideByTwo(ArrayExtensions.getLength(leftColumnIndexes))];
        } else if (Global.equals((Object)this.getAlignment(), (Object)LayoutAlignment.Center)) {
            if (Global.equals((Object)this.getDirection(), (Object)LayoutDirection.Horizontal)) {
                centerRowIndexes = this.getCenterRowIndexes((LayoutFrame[])frames);
                index = centerRowIndexes[LayoutPreset.divideByTwo(ArrayExtensions.getLength(centerRowIndexes))];
            } else {
                int[] leftColumnIndexes = this.getCenterColumnIndexes((LayoutFrame[])frames);
                index = leftColumnIndexes[LayoutPreset.divideByTwo(ArrayExtensions.getLength(leftColumnIndexes))];
            }
        } else if (Global.equals((Object)this.getAlignment(), (Object)LayoutAlignment.Right)) {
            int[] leftColumnIndexes = this.getRightColumnIndexes((LayoutFrame[])frames);
            index = leftColumnIndexes[LayoutPreset.divideByTwo(ArrayExtensions.getLength(leftColumnIndexes))];
        } else if (Global.equals((Object)this.getAlignment(), (Object)LayoutAlignment.BottomLeft)) {
            if (Global.equals((Object)this.getDirection(), (Object)LayoutDirection.Horizontal)) {
                index = this.getBottomRowIndexes((LayoutFrame[])frames)[0];
            } else {
                int[] leftColumnIndexes = this.getLeftColumnIndexes((LayoutFrame[])frames);
                index = leftColumnIndexes[ArrayExtensions.getLength(leftColumnIndexes) - 1];
            }
        } else if (Global.equals((Object)this.getAlignment(), (Object)LayoutAlignment.Bottom)) {
            centerRowIndexes = this.getBottomRowIndexes((LayoutFrame[])frames);
            index = centerRowIndexes[LayoutPreset.divideByTwo(ArrayExtensions.getLength(centerRowIndexes))];
        } else if (Global.equals((Object)this.getAlignment(), (Object)LayoutAlignment.BottomRight)) {
            index = ArrayExtensions.getLength(frames) - 1;
        }
        Layout layout = new Layout();
        layout.setLocalFrame(frames[index]);
        layout.setRemoteFrames(LayoutPreset.spliceLayoutFrame((LayoutFrame[])frames, index));
        return layout;
    }

    public int getInlineMargin() {
        return this._inlineMargin;
    }

    private int[] getLeftColumnIndexes(LayoutFrame[] frames) {
        int num3;
        int xMin = LayoutPreset.getXMin(frames);
        int num2 = 0;
        for (num3 = 0; num3 < ArrayExtensions.getLength(frames); ++num3) {
            if (frames[num3].getX() != xMin) continue;
            ++num2;
        }
        int num4 = 0;
        int[] numArray = new int[num2];
        for (num3 = 0; num3 < ArrayExtensions.getLength(frames); ++num3) {
            if (frames[num3].getX() != xMin) continue;
            numArray[num4++] = num3;
        }
        return numArray;
    }

    public LayoutMode getMode() {
        return this._mode;
    }

    private int[] getRightColumnIndexes(LayoutFrame[] frames) {
        int num3;
        int xMax = LayoutPreset.getXMax(frames);
        int num2 = 0;
        for (num3 = 0; num3 < ArrayExtensions.getLength(frames); ++num3) {
            if (frames[num3].getX() != xMax) continue;
            ++num2;
        }
        int num4 = 0;
        int[] numArray = new int[num2];
        for (num3 = 0; num3 < ArrayExtensions.getLength(frames); ++num3) {
            if (frames[num3].getX() != xMax) continue;
            numArray[num4++] = num3;
        }
        return numArray;
    }

    private static Layout getSingleLayout(int layoutWidth, int layoutHeight) {
        Layout layout = new Layout();
        layout.setLocalFrame(new LayoutFrame(0, 0, layoutWidth, layoutHeight));
        return layout;
    }

    public static LayoutPreset getSkype() {
        if (Platform.getInstance().getIsMobile()) {
            return LayoutPreset.getFacetime();
        }
        LayoutPreset preset = new LayoutPreset();
        preset.setMode(LayoutMode.Block);
        preset.setDirection(LayoutDirection.Horizontal);
        preset.setAlignment(LayoutAlignment.Bottom);
        preset.setBlockMarginX(10);
        preset.setBlockMarginY(10);
        preset.setBlockWidthPercent(0.333333333333333);
        preset.setBlockHeightPercent(0.333333333333333);
        preset.setInlineMargin(10);
        return preset;
    }

    private int[] getTopRowIndexes(LayoutFrame[] frames) {
        int num3;
        int yMin = LayoutPreset.getYMin(frames);
        int num2 = 0;
        for (num3 = 0; num3 < ArrayExtensions.getLength(frames); ++num3) {
            if (frames[num3].getY() != yMin) continue;
            ++num2;
        }
        int num4 = 0;
        int[] numArray = new int[num2];
        for (num3 = 0; num3 < ArrayExtensions.getLength(frames); ++num3) {
            if (frames[num3].getY() != yMin) continue;
            numArray[num4++] = num3;
        }
        return numArray;
    }

    private static int getXMax(LayoutFrame[] frames) {
        if (ArrayExtensions.getLength(frames) == 0) {
            return frames[0].getX();
        }
        int x = frames[0].getX();
        for (int i = 1; i < ArrayExtensions.getLength(frames); ++i) {
            LayoutFrame frame = frames[i];
            if (frame.getX() <= x) continue;
            x = frame.getX();
        }
        return x;
    }

    private static int getXMid(LayoutFrame[] frames) {
        int xMax;
        int xMin = LayoutPreset.getXMin(frames);
        if (xMin == (xMax = LayoutPreset.getXMax(frames))) {
            return xMin;
        }
        int num3 = LayoutPreset.divideByTwo(xMin + xMax);
        int x = frames[0].getX();
        int num5 = MathAssistant.abs(num3 - x);
        for (int i = 1; i < ArrayExtensions.getLength(frames); ++i) {
            LayoutFrame frame = frames[i];
            int num7 = MathAssistant.abs(num3 - frame.getX());
            if (num7 >= num5) continue;
            x = frame.getX();
            num5 = num7;
        }
        return x;
    }

    private static int getXMin(LayoutFrame[] frames) {
        if (ArrayExtensions.getLength(frames) == 0) {
            return frames[0].getX();
        }
        int x = frames[0].getX();
        for (int i = 1; i < ArrayExtensions.getLength(frames); ++i) {
            LayoutFrame frame = frames[i];
            if (frame.getX() >= x) continue;
            x = frame.getX();
        }
        return x;
    }

    private static int getYMax(LayoutFrame[] frames) {
        if (ArrayExtensions.getLength(frames) == 0) {
            return frames[0].getY();
        }
        int y = frames[0].getY();
        for (int i = 1; i < ArrayExtensions.getLength(frames); ++i) {
            LayoutFrame frame = frames[i];
            if (frame.getY() <= y) continue;
            y = frame.getY();
        }
        return y;
    }

    private static int getYMid(LayoutFrame[] frames) {
        int yMax;
        int yMin = LayoutPreset.getYMin(frames);
        if (yMin == (yMax = LayoutPreset.getYMax(frames))) {
            return yMin;
        }
        int num3 = LayoutPreset.divideByTwo(yMin + yMax);
        int y = frames[0].getY();
        int num5 = MathAssistant.abs(num3 - y);
        for (int i = 1; i < ArrayExtensions.getLength(frames); ++i) {
            LayoutFrame frame = frames[i];
            int num7 = MathAssistant.abs(num3 - frame.getY());
            if (num7 >= num5) continue;
            y = frame.getY();
            num5 = num7;
        }
        return y;
    }

    private static int getYMin(LayoutFrame[] frames) {
        if (ArrayExtensions.getLength(frames) == 0) {
            return frames[0].getY();
        }
        int y = frames[0].getY();
        for (int i = 1; i < ArrayExtensions.getLength(frames); ++i) {
            LayoutFrame frame = frames[i];
            if (frame.getY() >= y) continue;
            y = frame.getY();
        }
        return y;
    }

    public LayoutPreset() {
        this.setMode(LayoutMode.FloatLocal);
        this.setDirection(LayoutDirection.Horizontal);
        this.setAlignment(LayoutAlignment.BottomRight);
    }

    private static LayoutFrame[] mergeLayoutFrames(LayoutFrame[] firstFrames, LayoutFrame[] lastFrames) {
        int num3;
        int length = ArrayExtensions.getLength(firstFrames);
        int num2 = ArrayExtensions.getLength(lastFrames);
        LayoutFrame[] frameArray = new LayoutFrame[length + num2];
        for (num3 = 0; num3 < length; ++num3) {
            frameArray[num3] = firstFrames[num3];
        }
        for (num3 = 0; num3 < num2; ++num3) {
            frameArray[num3 + length] = lastFrames[num3];
        }
        return frameArray;
    }

    public void setAlignment(LayoutAlignment value) {
        this._alignment = value;
    }

    public void setBlockHeight(int value) {
        this.__blockHeight = value;
        this.__blockHeightPercent = 0.0;
    }

    public void setBlockHeightPercent(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        this.__blockHeightPercent = value;
        this.__blockHeight = 0;
    }

    public void setBlockMarginX(int value) {
        this.__blockMarginX = value;
        this.__blockMarginXPercent = 0.0;
    }

    public void setBlockMarginXPercent(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        this.__blockMarginXPercent = value;
        this.__blockMarginX = 0;
    }

    public void setBlockMarginY(int value) {
        this.__blockMarginY = value;
        this.__blockMarginYPercent = 0.0;
    }

    public void setBlockMarginYPercent(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        this.__blockMarginYPercent = value;
        this.__blockMarginY = 0;
    }

    public void setBlockWidth(int value) {
        this.__blockWidth = value;
        this.__blockWidthPercent = 0.0;
    }

    public void setBlockWidthPercent(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        this.__blockWidthPercent = value;
        this.__blockWidth = 0;
    }

    public void setDirection(LayoutDirection value) {
        this._direction = value;
    }

    public void setFloatHeight(int value) {
        this.__floatHeight = value;
        this.__floatHeightPercent = 0.0;
    }

    public void setFloatHeightPercent(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        this.__floatHeightPercent = value;
        this.__floatHeight = 0;
    }

    public void setFloatMarginX(int value) {
        this.__floatMarginX = value;
        this.__floatMarginXPercent = 0.0;
    }

    public void setFloatMarginXPercent(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        this.__floatMarginXPercent = value;
        this.__floatMarginX = 0;
    }

    public void setFloatMarginY(int value) {
        this.__floatMarginY = value;
        this.__floatMarginYPercent = 0.0;
    }

    public void setFloatMarginYPercent(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        this.__floatMarginYPercent = value;
        this.__floatMarginY = 0;
    }

    public void setFloatWidth(int value) {
        this.__floatWidth = value;
        this.__floatWidthPercent = 0.0;
    }

    public void setFloatWidthPercent(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        this.__floatWidthPercent = value;
        this.__floatWidth = 0;
    }

    public void setInlineMargin(int value) {
        this._inlineMargin = value;
    }

    public void setMode(LayoutMode value) {
        this._mode = value;
    }

    private static LayoutFrame[] spliceLayoutFrame(LayoutFrame[] frames, int index) {
        int start = index + 1;
        return LayoutPreset.mergeLayoutFrames(LayoutPreset.takeLayoutFrames(frames, 0, index), LayoutPreset.takeLayoutFrames(frames, start, ArrayExtensions.getLength(frames) - start));
    }

    private static LayoutFrame[] takeLayoutFrames(LayoutFrame[] frames, int start, int length) {
        Object[] frameArray = new LayoutFrame[length];
        for (int i = 0; i < ArrayExtensions.getLength(frameArray); ++i) {
            frameArray[i] = frames[start + i];
        }
        return frameArray;
    }

    private static void transformFrame(LayoutFrame frame, LayoutOrigin origin, int layoutWidth, int layoutHeight) {
        boolean flag = false;
        boolean flag2 = false;
        LayoutOrigin _var0 = origin;
        if (_var0 == LayoutOrigin.TopRight) {
            flag = true;
        } else if (_var0 == LayoutOrigin.BottomRight) {
            flag = true;
            flag2 = true;
        } else if (_var0 == LayoutOrigin.BottomLeft) {
            flag2 = true;
        }
        if (flag) {
            frame.setX(layoutWidth - frame.getX() - frame.getWidth());
        }
        if (flag2) {
            frame.setY(layoutHeight - frame.getY() - frame.getHeight());
        }
    }
}

