/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

enum IceTransportState {
    New(1),
    Checking(2),
    Connected(3),
    Disconnected(4),
    Closed(5),
    Failed(6);

    private final int value;
    private static final Map<Integer, IceTransportState> lookup;

    private IceTransportState(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static IceTransportState getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, IceTransportState>();
        for (IceTransportState s : EnumSet.allOf(IceTransportState.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

