/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.Base64;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IceSendMessageArgs;
import fm.icelink.IceSendRequestSuccessArgs;
import fm.icelink.IntegerExtensions;
import fm.icelink.ScheduledItem;
import fm.icelink.Scheduler;
import fm.icelink.stun.Message;
import java.util.ArrayList;
import java.util.HashMap;

class IceTransactionManager {
    private Object __lock;
    private Scheduler __scheduler;
    private HashMap<String, ArrayList<ScheduledItem>> __transactionsByCallerHash;
    private HashMap<String, ScheduledItem> __transactionsByTransactionKey = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTransaction(ScheduledItem item, Object caller) {
        String str = Base64.encode(((IceSendMessageArgs)item.getState()).getMessage().getTransactionId());
        ArrayList list = null;
        Object object = this.__lock;
        synchronized (object) {
            String key = IntegerExtensions.toString(caller.hashCode());
            Holder<Object> _var0 = new Holder<Object>(list);
            boolean _var1 = HashMapExtensions.tryGetValue(this.__transactionsByCallerHash, key, _var0);
            list = _var0.getValue();
            if (_var1) {
                list.add(item);
            } else {
                ArrayList<ScheduledItem> list2 = new ArrayList<ScheduledItem>();
                list2.add(item);
                HashMapExtensions.set(HashMapExtensions.getItem(this.__transactionsByCallerHash), key, list2);
            }
            HashMapExtensions.set(HashMapExtensions.getItem(this.__transactionsByTransactionKey), str, item);
        }
        this.__scheduler.add(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveTransactions(Object caller) {
        Object object = this.__lock;
        synchronized (object) {
            String key = IntegerExtensions.toString(caller.hashCode());
            if (this.__transactionsByCallerHash.containsKey(key)) {
                ArrayList list = null;
                Holder<Object> _var0 = new Holder<Object>(list);
                boolean _var1 = HashMapExtensions.tryGetValue(this.__transactionsByCallerHash, key, _var0);
                list = _var0.getValue();
                if (_var1 && ArrayListExtensions.getCount(list) > 0) {
                    return true;
                }
            }
            return false;
        }
    }

    public IceTransactionManager(Object lockObject, Scheduler scheduler) {
        this.__transactionsByCallerHash = new HashMap();
        this.__lock = lockObject;
        this.__scheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object caller) {
        ArrayList list = null;
        Object object = this.__lock;
        synchronized (object) {
            String key = IntegerExtensions.toString(caller.hashCode());
            Holder<Object> _var0 = new Holder<Object>(list);
            boolean _var1 = HashMapExtensions.tryGetValue(this.__transactionsByCallerHash, key, _var0);
            list = _var0.getValue();
            if (_var1) {
                if (list != null) {
                    for (ScheduledItem item : list) {
                        this.__scheduler.remove(item);
                        IceSendMessageArgs state = (IceSendMessageArgs)item.getState();
                        String str2 = Base64.encode(state.getMessage().getTransactionId());
                        HashMapExtensions.remove(this.__transactionsByTransactionKey, str2);
                    }
                }
                list.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ScheduledItem item, Object caller) {
        if (item != null && caller != null) {
            byte[] b;
            IceSendMessageArgs state = (IceSendMessageArgs)item.getState();
            Message message = state == null ? null : state.getMessage();
            byte[] byArray = b = message == null ? null : message.getTransactionId();
            if (b != null) {
                String key = Base64.encode(b);
                Object object = this.__lock;
                synchronized (object) {
                    ArrayList list = null;
                    String str2 = IntegerExtensions.toString(caller.hashCode());
                    Holder<Object> _var0 = new Holder<Object>(list);
                    boolean _var1 = HashMapExtensions.tryGetValue(this.__transactionsByCallerHash, str2, _var0);
                    list = _var0.getValue();
                    if (_var1 && list != null) {
                        list.remove(item);
                    }
                    HashMapExtensions.remove(this.__transactionsByTransactionKey, key);
                }
                this.__scheduler.remove(item);
            }
        }
    }

    public void start() {
        this.__scheduler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledItem[] transactionsForCaller(Object caller) {
        Object object = this.__lock;
        synchronized (object) {
            String str = IntegerExtensions.toString(caller.hashCode());
            ArrayList<ScheduledItem> list = HashMapExtensions.getItem(this.__transactionsByCallerHash).get(str);
            if (list != null && ArrayListExtensions.getCount(list) > 0) {
                return list.toArray(new ScheduledItem[0]);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryTriggerOnResponse(String key, IceSendRequestSuccessArgs successArgs) {
        boolean flag;
        ScheduledItem item = null;
        Object object = this.__lock;
        synchronized (object) {
            Holder<Object> _var0 = new Holder<Object>(item);
            boolean _var1 = HashMapExtensions.tryGetValue(this.__transactionsByTransactionKey, key, _var0);
            item = _var0.getValue();
            flag = _var1;
        }
        ScheduledItem item2 = item;
        if (item2 != null) {
            IceSendMessageArgs state = (IceSendMessageArgs)item2.getState();
            IceSendMessageArgs args2 = state;
            if (args2 == null) {
                return flag;
            }
            IAction1<IceSendRequestSuccessArgs> onResponse = args2.getOnResponse();
            if (onResponse != null) {
                successArgs.setItem(item2);
                onResponse.invoke(successArgs);
            }
        }
        return flag;
    }
}

