/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum IceGatheringState {
    New(1),
    Gathering(2),
    Complete(3),
    Closing(4),
    Closed(5),
    Failed(6);

    private final int value;
    private static final Map<Integer, IceGatheringState> lookup;

    private IceGatheringState(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static IceGatheringState getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, IceGatheringState>();
        for (IceGatheringState s : EnumSet.allOf(IceGatheringState.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

