/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

enum IceComponent {
    Rtp(1),
    Rtcp(2);

    private final int value;
    private static final Map<Integer, IceComponent> lookup;

    private IceComponent(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static IceComponent getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, IceComponent>();
        for (IceComponent s : EnumSet.allOf(IceComponent.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

