/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BitAssistant;
import fm.icelink.Candidate;
import fm.icelink.Crypto;
import fm.icelink.DataBuffer;
import fm.icelink.Error;
import fm.icelink.Global;
import fm.icelink.IAction1;
import fm.icelink.IAction3;
import fm.icelink.IActionDelegate1;
import fm.icelink.IceCandidateType;
import fm.icelink.IceComponent;
import fm.icelink.IceLocalCandidateState;
import fm.icelink.IceLocalRelayedCandidate;
import fm.icelink.IceLocalRelayedCandidateState;
import fm.icelink.IceSendMessageArgs;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.ProtocolType;
import fm.icelink.ScheduledItem;
import fm.icelink.StringExtensions;
import fm.icelink.TransportAddress;
import fm.icelink.sdp.ice.CandidateAttribute;
import fm.icelink.sdp.ice.CandidateType;
import fm.icelink.sdp.ice.TransportProtocol;
import java.util.ArrayList;
import java.util.List;

class IceCandidate {
    private Object __lock;
    private List<IAction1<IceCandidate>> __onStateChange = new ArrayList<IAction1<IceCandidate>>();
    private ProtocolType __operatingProtocol;
    private IceLocalCandidateState __state;
    private long _adapterSpeed;
    private IceCandidate _base;
    private ProtocolType _discoverProtocol;
    private IAction3<DataBuffer, IceCandidate, TransportAddress> _dispatchApplicationData;
    private IAction1<IceSendMessageArgs> _dispatchStunMessage;
    private Error _error;
    private String _foundation;
    private static byte _hostTypePreference = (byte)126;
    private String _ipAddress;
    private IAction1<IceCandidate> _onStateChange = new IAction1<IceCandidate>(){

        @Override
        public void invoke(IceCandidate p0) {
            for (IAction1 action : new ArrayList(IceCandidate.this.__onStateChange)) {
                action.invoke(p0);
            }
        }
    };
    private String _password;
    private static byte _peerReflexivePreference = (byte)110;
    private int _port;
    private long _priority;
    private String _relatedIPAddress;
    private int _relatedPort;
    private static byte _relayPreference;
    private static byte _serverReflexivePreference;
    private IceCandidateType _type;
    private String _username;

    void addOnStateChange(IAction1<IceCandidate> value) {
        this.__onStateChange.add(value);
    }

    public static int calculateLocalPreference(IceCandidateType type, long priority, IceComponent component) {
        byte hostTypePreference = 0;
        int num2 = 0;
        IceCandidateType _var0 = type;
        if (_var0 == IceCandidateType.Host) {
            hostTypePreference = _hostTypePreference;
        } else if (_var0 == IceCandidateType.ServerReflexive) {
            hostTypePreference = _serverReflexivePreference;
        } else if (_var0 == IceCandidateType.PeerReflexive) {
            hostTypePreference = _peerReflexivePreference;
        } else if (_var0 == IceCandidateType.Relayed) {
            hostTypePreference = _relayPreference;
        }
        IceComponent _var1 = component;
        if (_var1 == IceComponent.Rtp) {
            num2 = 1;
        } else if (_var1 == IceComponent.Rtcp) {
            num2 = 2;
        }
        if (num2 < 1 || num2 > 256) {
            throw new RuntimeException(new Exception("ComponentId must be an integer from 1 to 256 inclusive."));
        }
        int num3 = (int)((priority - (long)(0x1000000 * hostTypePreference - (256 - num2))) / 256L);
        if (num3 >= 0) {
            return num3;
        }
        return 0;
    }

    public static long calculatePriority(IceCandidateType type, int localPreference, IceComponent component) {
        byte hostTypePreference = 0;
        int num2 = 0;
        IceCandidateType _var0 = type;
        if (_var0 == IceCandidateType.Host) {
            hostTypePreference = _hostTypePreference;
        } else if (_var0 == IceCandidateType.ServerReflexive) {
            hostTypePreference = _serverReflexivePreference;
        } else if (_var0 == IceCandidateType.PeerReflexive) {
            hostTypePreference = _peerReflexivePreference;
        } else if (_var0 == IceCandidateType.Relayed) {
            hostTypePreference = _relayPreference;
        }
        IceComponent _var1 = component;
        if (_var1 == IceComponent.Rtp) {
            num2 = 1;
        } else if (_var1 == IceComponent.Rtcp) {
            num2 = 2;
        }
        if (num2 < 1 || num2 > 256) {
            throw new RuntimeException(new Exception("ComponentId must be an integer from 1 to 256 inclusive."));
        }
        long num3 = 0x1000000 * hostTypePreference + 256 * localPreference + (256 - num2);
        if (num3 >= 0L) {
            return num3;
        }
        return IceCandidate.getUnset();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            IceCandidate candidate = Global.tryCast(obj, IceCandidate.class);
            return Global.equals(this.getIPAddress(), candidate.getIPAddress()) && this.getPort() == candidate.getPort();
        }
        catch (Exception exception1) {
            return false;
        }
    }

    public static IceCandidate fromSdpCandidateAttribute(Object lockObject, CandidateAttribute candidateAttribute) {
        long priority = -1L;
        IceCandidateType host = IceCandidateType.Host;
        if (Global.equals(candidateAttribute.getCandidateType(), CandidateType.getPeerReflexive())) {
            host = IceCandidateType.PeerReflexive;
        } else if (Global.equals(candidateAttribute.getCandidateType(), CandidateType.getServerReflexive())) {
            host = IceCandidateType.ServerReflexive;
        } else if (Global.equals(candidateAttribute.getCandidateType(), CandidateType.getRelayed())) {
            host = IceCandidateType.Relayed;
        } else {
            if (!Global.equals(candidateAttribute.getCandidateType(), CandidateType.getHost())) {
                throw new RuntimeException(new Exception("Only host, server reflexive, peer reflexive, and relayed candidates are supported by ICE."));
            }
            host = IceCandidateType.Host;
        }
        if (candidateAttribute.getPriority() <= 0L) {
            throw new RuntimeException(new Exception("Invalid priority signaled for remote candidate."));
        }
        priority = candidateAttribute.getPriority();
        ProtocolType protocol = StringExtensions.toLower(candidateAttribute.getProtocol()).equals(StringExtensions.toLower(TransportProtocol.getUdp())) ? ProtocolType.Udp : ProtocolType.Tcp;
        IceCandidate candidate = new IceCandidate(lockObject, candidateAttribute.getFoundation(), protocol, candidateAttribute.getConnectionAddress(), candidateAttribute.getPort(), host, candidateAttribute.getRelatedAddress(), candidateAttribute.getRelatedPort());
        candidate.setPriority(priority);
        return candidate;
    }

    public CandidateAttribute generateAttribute(int componentId) {
        String host = CandidateType.getHost();
        if (Global.equals((Object)this.getType(), (Object)IceCandidateType.PeerReflexive)) {
            host = CandidateType.getPeerReflexive();
        } else if (Global.equals((Object)this.getType(), (Object)IceCandidateType.Relayed)) {
            host = CandidateType.getRelayed();
        } else if (Global.equals((Object)this.getType(), (Object)IceCandidateType.ServerReflexive)) {
            host = CandidateType.getServerReflexive();
        }
        return new CandidateAttribute(this.getFoundation(), this.getPriority(), this.getIPAddress(), this.getPort(), host, this.getRelatedIPAddress(), this.getRelatedPort(), Global.equals((Object)this.getOperatingProtocol(), (Object)ProtocolType.Tcp) ? TransportProtocol.getTcp() : TransportProtocol.getUdp(), componentId);
    }

    static String generateLocalCandidateFoundation(IceCandidateType type, String mappedIPAddress, TransportAddress serverAddress, ProtocolType protocol) {
        String iPAddress = "-";
        if (serverAddress != null && serverAddress.getIPAddress() != null) {
            iPAddress = serverAddress.getIPAddress();
        }
        String str2 = Global.equals((Object)protocol, (Object)ProtocolType.Udp) ? "Udp" : "Tcp";
        return BitAssistant.getHexString(Crypto.getMd5Hash(StringExtensions.format("{0}|{1}|{2}|{3}", new Object[]{type.toString(), mappedIPAddress, iPAddress, str2})));
    }

    long getAdapterSpeed() {
        return this._adapterSpeed;
    }

    IceCandidate getBase() {
        return this._base;
    }

    public ProtocolType getDiscoverProtocol() {
        return this._discoverProtocol;
    }

    IAction3<DataBuffer, IceCandidate, TransportAddress> getDispatchApplicationData() {
        return this._dispatchApplicationData;
    }

    IAction1<IceSendMessageArgs> getDispatchStunMessage() {
        return this._dispatchStunMessage;
    }

    public Error getError() {
        return this._error;
    }

    public String getFoundation() {
        return this._foundation;
    }

    public String getIPAddress() {
        return this._ipAddress;
    }

    protected Object getLock() {
        return this.__lock;
    }

    public ProtocolType getOperatingProtocol() {
        return this.__operatingProtocol;
    }

    String getPassword() {
        return this._password;
    }

    public int getPort() {
        return this._port;
    }

    public long getPriority() {
        return this._priority;
    }

    public String getRelatedIPAddress() {
        return this._relatedIPAddress;
    }

    public int getRelatedPort() {
        return this._relatedPort;
    }

    public IceLocalCandidateState getState() {
        return this.__state;
    }

    public TransportAddress getTransportAddress() {
        return new TransportAddress(this.getIPAddress(), this.getPort());
    }

    public IceCandidateType getType() {
        return this._type;
    }

    public static int getUnset() {
        return -1;
    }

    String getUsername() {
        return this._username;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public IceCandidate(Object lockObject, String foundation, ProtocolType protocol, String address, int port, IceCandidateType type, String relatedIPAddress, int relatedPort) {
        this.setDiscoverProtocol(ProtocolType.Unknown);
        this.__lock = lockObject;
        this.setFoundation(foundation);
        this.setOperatingProtocol(protocol);
        this.setIPAddress(address);
        this.setPort(port);
        this.setType(type);
        this.setRelatedIPAddress(relatedIPAddress);
        this.setRelatedPort(relatedPort);
        this.setState(IceLocalCandidateState.Ready);
    }

    public IceCandidate(Object lockObject, String foundation, ProtocolType protocol, String address, int port, IceCandidateType type) {
        this(lockObject, foundation, protocol, address, port, type, null, IceCandidate.getUnset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyOfSocketError(Error error) {
        Object object = this.__lock;
        synchronized (object) {
            this.setError(error);
            this.setState(IceLocalCandidateState.Failed);
            if (Global.equals((Object)this.getType(), (Object)IceCandidateType.Relayed)) {
                ((IceLocalRelayedCandidate)this).processDSMFailure();
            }
        }
    }

    void removeOnStateChange(IAction1<IceCandidate> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onStateChange.remove(value);
    }

    public void send(DataBuffer data, IceCandidate remoteCandidate) {
        if (Global.equals((Object)this.getState(), (Object)IceLocalCandidateState.Ready)) {
            IceCandidate candidate = this.getBase();
            if (candidate != null) {
                TransportAddress address;
                IAction3<DataBuffer, IceCandidate, TransportAddress> dispatchApplicationData = candidate.getDispatchApplicationData();
                TransportAddress transportAddress = address = Global.equals((Object)this.getType(), (Object)IceCandidateType.Relayed) ? ((IceLocalRelayedCandidate)this).getTurnServer() : null;
                if (dispatchApplicationData != null) {
                    dispatchApplicationData.invoke(data, remoteCandidate, address);
                } else {
                    Log.error(StringExtensions.format("Candidate {0} does not have send method assigned. Cannot send message.", this.toString()));
                }
            } else {
                Log.error(StringExtensions.format("Candidate {0} does not have base candidate assigned. Cannot send message.", this.toString()));
            }
        }
    }

    void sendStunMessage(IceSendMessageArgs args) {
        IAction1<IceSendMessageArgs> dispatchStunMessage = this.getBase().getDispatchStunMessage();
        if (dispatchStunMessage != null) {
            try {
                dispatchStunMessage.invoke(args);
            }
            catch (Exception exception) {
                Log.error(StringExtensions.format("IceLink candidate: Could not send stun message. {0}", exception.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendStunMessage(ScheduledItem item) {
        IceSendMessageArgs state = (IceSendMessageArgs)item.getState();
        Object object = this.__lock;
        synchronized (object) {
            if (Global.equals((Object)this.getState(), (Object)IceLocalCandidateState.Ready) || Global.equals((Object)this.getType(), (Object)IceCandidateType.Relayed) && Global.equals((Object)((IceLocalRelayedCandidate)this).getRelayState(), (Object)IceLocalRelayedCandidateState.Closing)) {
                this.sendStunMessage(state);
            }
        }
    }

    void setAdapterSpeed(long value) {
        this._adapterSpeed = value;
    }

    void setBase(IceCandidate value) {
        this._base = value;
    }

    void setDiscoverProtocol(ProtocolType value) {
        this._discoverProtocol = value;
    }

    void setDispatchApplicationData(IAction3<DataBuffer, IceCandidate, TransportAddress> value) {
        this._dispatchApplicationData = value;
    }

    void setDispatchStunMessage(IAction1<IceSendMessageArgs> value) {
        this._dispatchStunMessage = value;
    }

    protected void setError(Error value) {
        this._error = value;
    }

    private void setFoundation(String value) {
        this._foundation = value;
    }

    private void setIPAddress(String value) {
        this._ipAddress = value;
    }

    private void setOperatingProtocol(ProtocolType value) {
        if (Global.equals((Object)value, (Object)ProtocolType.Unknown)) {
            throw new RuntimeException(new Exception("Candidate operating protocol must be either TCP or UDP."));
        }
        this.__operatingProtocol = value;
    }

    void setPassword(String value) {
        this._password = value;
    }

    private void setPort(int value) {
        this._port = value;
    }

    void setPriority(long value) {
        this._priority = value;
    }

    private void setRelatedIPAddress(String value) {
        this._relatedIPAddress = value;
    }

    private void setRelatedPort(int value) {
        this._relatedPort = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(IceLocalCandidateState value) {
        Object object = this.__lock;
        synchronized (object) {
            if (!Global.equals((Object)value, (Object)this.__state)) {
                this.__state = value;
                IAction1<IceCandidate> onStateChange = this._onStateChange;
                if (onStateChange != null) {
                    onStateChange.invoke(this);
                }
            }
        }
    }

    private void setType(IceCandidateType value) {
        this._type = value;
    }

    void setUsername(String value) {
        this._username = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Object object = this.__lock;
        synchronized (object) {
            this.setState(IceLocalCandidateState.Closed);
        }
    }

    public Candidate toCandidate(int componentId, int streamIndex) {
        Candidate candidate = new Candidate();
        candidate.setSdpCandidateAttribute(this.generateAttribute(componentId));
        candidate.setSdpMediaIndex(streamIndex);
        return candidate;
    }

    public String toString() {
        if (this.getIPAddress() == null) {
            return "??:??";
        }
        return StringExtensions.format("{0}:{1}", this.getIPAddress(), IntegerExtensions.toString(this.getPort()));
    }

    static {
        _serverReflexivePreference = (byte)100;
        _relayPreference = 0;
    }
}

