/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Global;
import fm.icelink.HttpRequestArgs;
import fm.icelink.HttpResponseArgs;
import fm.icelink.HttpSendFinishArgs;
import fm.icelink.HttpSendStartArgs;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.Randomizer;
import fm.icelink.StringComparison;
import fm.icelink.StringExtensions;
import fm.icelink.UriExtensions;
import java.util.ArrayList;
import java.util.List;

public abstract class HttpTransfer {
    private static List<IAction1<HttpSendFinishArgs>> __onSendFinish = new ArrayList<IAction1<HttpSendFinishArgs>>();
    private static List<IAction1<HttpSendStartArgs>> __onSendStart = new ArrayList<IAction1<HttpSendStartArgs>>();
    private static String __wildcardCharacters;
    private static IAction1<HttpSendFinishArgs> _onSendFinish;
    private static IAction1<HttpSendStartArgs> _onSendStart;

    public static void addOnSendFinish(IAction1<HttpSendFinishArgs> value) {
        __onSendFinish.add(value);
    }

    public static void addOnSendStart(IAction1<HttpSendStartArgs> value) {
        __onSendStart.add(value);
    }

    public static String addQueryToUrl(String url, String key, String value) {
        if (StringExtensions.isNullOrEmpty(key)) {
            return url;
        }
        if (value == null) {
            value = StringExtensions.empty;
        }
        key = UriExtensions.escapeDataString(key);
        value = UriExtensions.escapeDataString(value);
        return StringExtensions.concat(new String[]{url, StringExtensions.indexOf(url, "?", StringComparison.OrdinalIgnoreCase) == -1 ? "?" : "&", key, "=", value});
    }

    public static String addQueryToUrl(String url, String key) {
        return HttpTransfer.addQueryToUrl(url, key, null);
    }

    private void finishRequest(HttpResponseArgs responseArgs) {
        this.raiseOnSendFinish(responseArgs);
    }

    public static String getRandomWildcardCharacter() {
        String wildcardCharacters = HttpTransfer.getWildcardCharacters();
        int startIndex = new Randomizer().next(StringExtensions.getLength(wildcardCharacters));
        return StringExtensions.substring(wildcardCharacters, startIndex, 1);
    }

    public static String getWildcardCharacters() {
        return __wildcardCharacters;
    }

    protected HttpTransfer() {
    }

    private void raiseOnSendFinish(HttpResponseArgs responseArgs) {
        IAction1<HttpSendFinishArgs> onSendFinish = _onSendFinish;
        if (onSendFinish != null) {
            HttpSendFinishArgs p = new HttpSendFinishArgs();
            p.setSender(responseArgs.getRequestArgs().getSender());
            p.setRequestBinaryContent(responseArgs.getRequestArgs().getBinaryContent());
            p.setRequestTextContent(responseArgs.getRequestArgs().getTextContent());
            p.setResponseBinaryContent(responseArgs.getBinaryContent());
            p.setResponseTextContent(responseArgs.getTextContent());
            p.setResponseHeaders(responseArgs.getHeaders());
            onSendFinish.invoke(p);
        }
    }

    private void raiseOnSendStart(HttpRequestArgs requestArgs) {
        IAction1<HttpSendStartArgs> onSendStart = _onSendStart;
        if (onSendStart != null) {
            HttpSendStartArgs p = new HttpSendStartArgs();
            p.setSender(requestArgs.getSender());
            p.setRequestBinaryContent(requestArgs.getBinaryContent());
            p.setRequestTextContent(requestArgs.getTextContent());
            onSendStart.invoke(p);
        }
    }

    public static void removeOnSendFinish(IAction1<HttpSendFinishArgs> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(__onSendFinish, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        __onSendFinish.remove(value);
    }

    public static void removeOnSendStart(IAction1<HttpSendStartArgs> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(__onSendStart, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        __onSendStart.remove(value);
    }

    public static String replaceWildcards(String url) {
        return url.replace("*", HttpTransfer.getRandomWildcardCharacter());
    }

    public HttpResponseArgs send(HttpRequestArgs requestArgs) {
        HttpResponseArgs args;
        this.startRequest(requestArgs);
        try {
            args = requestArgs.getBinaryContent() != null ? this.sendBinary(requestArgs) : this.sendText(requestArgs);
        }
        catch (Exception exception) {
            HttpResponseArgs args2 = new HttpResponseArgs(requestArgs);
            args2.setException(exception);
            args = args2;
        }
        this.finishRequest(args);
        return args;
    }

    public void sendAsync(HttpRequestArgs requestArgs, final IAction1<HttpResponseArgs> callback) {
        IAction1<HttpResponseArgs> action = null;
        IAction1<HttpResponseArgs> action2 = null;
        this.startRequest(requestArgs);
        try {
            if (requestArgs.getBinaryContent() != null) {
                if (action == null) {
                    action = new IAction1<HttpResponseArgs>(){

                        @Override
                        public void invoke(HttpResponseArgs responseArgs) {
                            HttpTransfer.this.finishRequest(responseArgs);
                            callback.invoke(responseArgs);
                        }
                    };
                }
                this.sendBinaryAsync(requestArgs, action);
            } else {
                if (action2 == null) {
                    action2 = new IAction1<HttpResponseArgs>(){

                        @Override
                        public void invoke(HttpResponseArgs responseArgs) {
                            HttpTransfer.this.finishRequest(responseArgs);
                            callback.invoke(responseArgs);
                        }
                    };
                }
                this.sendTextAsync(requestArgs, action2);
            }
        }
        catch (Exception exception) {
            HttpResponseArgs p = new HttpResponseArgs(requestArgs);
            p.setException(exception);
            callback.invoke(p);
        }
    }

    public abstract HttpResponseArgs sendBinary(HttpRequestArgs var1);

    public abstract void sendBinaryAsync(HttpRequestArgs var1, IAction1<HttpResponseArgs> var2);

    public abstract HttpResponseArgs sendText(HttpRequestArgs var1);

    public abstract void sendTextAsync(HttpRequestArgs var1, IAction1<HttpResponseArgs> var2);

    public static void setWildcardCharacters(String value) {
        __wildcardCharacters = value;
    }

    public abstract void shutdown();

    private void startRequest(HttpRequestArgs requestArgs) {
        this.raiseOnSendStart(requestArgs);
    }

    static {
        _onSendFinish = new IAction1<HttpSendFinishArgs>(){

            @Override
            public void invoke(HttpSendFinishArgs p0) {
                for (IAction1 action : new ArrayList(__onSendFinish)) {
                    action.invoke(p0);
                }
            }
        };
        _onSendStart = new IAction1<HttpSendStartArgs>(){

            @Override
            public void invoke(HttpSendStartArgs p0) {
                for (IAction1 action : new ArrayList(__onSendStart)) {
                    action.invoke(p0);
                }
            }
        };
        __wildcardCharacters = "abcdefghijklmnopqrstuvwxyz";
    }
}

